<?php

namespace App\Http\Controllers\Admin;

use App\Helpers\Helper\Helper;
use App\Http\Controllers\Controller;
use App\Models\Addon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\File;
use ZipArchive;
use Illuminate\Support\Str;
use Illuminate\Filesystem\Filesystem;
use Spatie\Permission\Models\Permission;
use Spatie\Permission\Models\Role;

class AddonController extends Controller
{
    function index()
    {
        $data['page_title'] = 'Manage Addon';

        $file = new Filesystem;
        $file->cleanDirectory('asset/images/addons');

        $data['addons'] = Addon::latest()->get();

        return view('admin.addon')->with($data);
    }

    function addonStatus(Request $request)
    {
        $addon = Addon::findOrFail($request->id);

        $addon->status = !$addon->status;

        $addon->save();

        return redirect()->back()->with('success', 'Addon Status Change Succesfully');
    }

    function installUpdate(Request $request)
    {
        $request->validate([
            'file' => 'required|file|mimes:zip'
        ]);


        $filename = uploadImage($request->file, 'images/addons');

        $zipFile = 'assets/images/addons/' . $filename;

        $zip = new ZipArchive;

        $isOpen = $zip->open($zipFile, ZipArchive::CREATE);

        $filesInside = [];

        for ($i = 0; $i < $zip->count(); $i++) {
            array_push($filesInside, $zip->getNameIndex($i));
        }

        $intersection = array_intersect(Addon::REQUIRED_FILES, $filesInside);


        if (count($intersection) !== count(Addon::REQUIRED_FILES)) {

            return redirect()->back()->with('alert', 'Wrong File Uploaded');
        }



        $string = $zip->getFromName("config.json");

        if ($string == '') {
            unlink($zipFile);
            return redirect()->back()->with('alert', 'Invalid Configuration File');
        }

        $addonInformation = json_decode($string, true);

        $addon = Addon::where('app_id', $addonInformation['unique_identifier'])->first();

        if ($addon) {

            return redirect()->back()->with('error', 'Already Install This Addon');
        }

        if ($zip->open($zipFile) === true) {

            if(!file_exists(app_path('Modules'))){

                mkdir(app_path('Modules',0775, true));
            }
            if(!file_exists('assets/addons/')){

                mkdir('assets/addons/' . $addonInformation['unique_identifier'], 0775, true);
            }

            $zip->extractTo(app_path('Modules/' . $addonInformation['unique_identifier']));


            if (file_exists(app_path('Modules') . '/' . $addonInformation['unique_identifier'] . '/' . 'asset/img/logo.png')) {
                File::copy(app_path('Modules') . '/' . $addonInformation['unique_identifier'] . '/' . 'asset/img/logo.png', 'assets/addon/s' . $addonInformation['unique_identifier'] . '/' . 'logo.png');
            }

            $zip->close();
        } else {

            return redirect()->back()->with('error', "Failed to extract the ZIP file.");
        }


        Addon::create([
            'name' => $addonInformation['app_name'],
            'app_id' => $addonInformation['unique_identifier'],
            'current_version' => $addonInformation['version'],
            'is_actived' => 1,
            'status' => 0,
            'image' => $addonInformation['unique_identifier'] . '\\asset\img\logo.png'
        ]);

        if(app_path('Modules').$addonInformation['unique_identifier'])

        Artisan::call("module:migrate", ['module' => $addonInformation['app_name']]);

        return redirect()->back()->with('success', 'Successfully Installed Addon');
    }

    function delete($id)
    {

        $addon = Addon::findOrFail($id);

        $name = ucwords($addon->name);

        $path = "app/Modules/{$name}/Migrations/2023_07_31_101709_create_" . strtolower($addon->name) . "_table.php";

        if(file_exists($path)){
            Artisan::call('migrate:rollback', ['--path' => $path]);
        }

        File::deleteDirectory(app_path('Modules') . '/' . $name);

        $addon->delete();

        return redirect()->back()->with('success', 'Successfully Uninstall Addon');
    }



    private function getPurchaseCode($code)
    {
        $personalToken = "q4L0C1Vdg5y0OfXAgjwtUM3bUHCRk2cv";
        $code = trim($code);
        if (!preg_match("/^([a-f0-9]{8})-(([a-f0-9]{4})-){3}([a-f0-9]{12})$/i", $code)) {
            return array('error' => true, 'message' => "Invalid purchase code");
        }

        $ch = curl_init();
        curl_setopt_array($ch, array(
            CURLOPT_URL => "https://api.envato.com/v3/market/author/sale?code={$code}",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_TIMEOUT => 20,
            CURLOPT_HTTPHEADER => array(
                "Authorization: Bearer {$personalToken}",
                "User-Agent: Purchase code verification script"
            )
        ));

        $response = @curl_exec($ch);
        $responseCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);

        if (curl_errno($ch) > 0) {
            return array('error' => true, 'message' => "Failed to connect");
        }

        switch ($responseCode) {
            case 404:
                return array('error' => true, 'message' => "Invalid purchase code");
            case 403:
                return array('error' => true, 'message' => "The personal token is missing the required permission for this script");
            case 401:
                return array('error' => true, 'message' => "The personal token is invalid or has been deleted");
        }

        if ($responseCode !== 200) {
            return array('error' => true, 'message' => "Got status {$responseCode}, try again shortly");
        }

        $body = @json_decode($response, true);

        if ($body === false && json_last_error() !== JSON_ERROR_NONE) {
            return array('error' => true, 'message' => "Error parsing response, try again");
        }

        $body['error'] = false;

        return $body;
    }
}
