<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\EmailTemplate;
use App\Models\General;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Artisan;

class EmailTemplateController extends Controller
{
    public function index()
    {
        $data['page_title'] = 'Default Template';
        $general = General::first();
        $data['email_templates'] = EmailTemplate::orderBy('id', 'DESC')->paginate($general->paginate);
        return view('admin.email_template.index', $data);
    }
    
    public function edit($id)
    {
        $email_template = EmailTemplate::findOrFail($id);
        $data['page_title'] = $email_template->name;
        return view('admin.email_template.edit', $data, compact('email_template'));
    }
    
    public function update(Request $request, $id)
    {
        $request->validate([
            'subj' => 'required',
            'email_body' => 'required',
        ]);
        try{
            $email_template = EmailTemplate::findOrFail($id);
            $email_template->update([
                'subj' => $request->subj,
                'email_body' => $request->email_body,
                'email_status' => $request->email_status ? 1 : 0
            ]);
            return back()->with('success',__('Update Successfully'));
        }catch (\Exception $e){
            return back()->with('alert',$e->getMessage());
        }
    }

    public function emailControl(){
        $data['page_title'] = "Email Controls";
        $general = General::first();
        $data['email_description'] = $general->email_description;
        return view('admin.email_template.config', $data, compact('general'));
    }

    public function emailConfigure(Request $request)
    {
        $request->validate([
            'email_method' => 'required',
            'sender_email' => 'required|email',
            'sender_email_name' => 'required',
            'smtp_host' => 'required',
            'smtp_port' => 'required',
            'smtp_username' => 'required',
            'smtp_password' => 'required',
        ]);

        $genrl = General::first();

        $genrl->sender_email = $request['sender_email'];
        $genrl->sender_email_name = $request['sender_email_name'];
        $genrl->email_description = $genrl->email_template;
        $genrl->email_configuration = [
            'name' => $request['email_method'],
            'smtp_host' => $request['smtp_host'],
            'smtp_port' => $request['smtp_port'],
            'smtp_encryption' => $request['smtp_encryption'],
            'smtp_username' => $request['smtp_username'],
            'smtp_password' => $request['smtp_password']
        ];
        $genrl->save();


        $data = [
            'MAIL_HOST'=>"mail.wowtheme7.com",
            'MAIL_PORT'=>"587",
            'MAIL_USERNAME'=>"investpro@wowtheme7.com",
            'MAIL_PASSWORD'=>"aAXkh!(^XknU",
            'MAIL_ENCRYPTION'=>"tls",
            'MAIL_FROM_ADDRESS'=>"investpro@wowtheme7.com",
            'MAIL_FROM_NAME'=>"Investpro"
        ];

        $this->changeEnv($data);

        Artisan::call('config:clear');
        Artisan::call('view:clear');

        session()->flash('success', __('Email Configuration Has Been Updated'));
        return back();
    }


    public function globalControl()
    {
        $data['page_title'] = "Global Template";
        return view('admin.email_template.global', $data);
    }



    protected function changeEnv($data = array())
    {
        if (count($data) > 0) {

            // Read .env-file
            $env = file_get_contents(base_path() . '/.env');

            // Split string on every " " and write into array
            $env = preg_split('/\s+/', $env);;

            // Loop through given data
            foreach ((array)$data as $key => $value) {

                // Loop through .env-data
                foreach ($env as $env_key => $env_value) {

                    // Turn the value into an array and stop after the first split
                    // So it's not possible to split e.g. the App-Key by accident
                    $entry = explode("=", $env_value, 2);

                    // Check, if new key fits the actual .env-key
                    if ($entry[0] == $key) {
                        // If yes, overwrite it with the new one
                        $env[$env_key] = $key . "='" . $value."'";
                    } else {
                        // If not, keep the old one
                        $env[$env_key] = $env_value;
                    }
                }
            }

            // Turn the array back to an String
            $env = implode("\n", $env);

            // And overwrite the .env with the new data
            file_put_contents(base_path() . '/.env', $env);

            return true;
        } else {
            return false;
        }
    }

}

?>