<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Ranking;
use Illuminate\Http\Request;

class RankingController extends Controller
{
    function index()
    {
        $page_title = "Ranking";
        $rankings = Ranking::latest()->paginate();
        return view('admin.ranking.index', compact('rankings', 'page_title'));
    }

    function store(Request $request)
    {
        $data = $request->validate([
            'title' => 'required|unique:rankings,title',
            'image' => 'required|image|mimes:jpg,png,jpeg',
            'minimum_deposit' => 'required|gt:0',
            'minimum_invest' => "required|gt:0",
            'minimum_referral' => 'required|gt:0',
            'bonus' => 'required|gt:0',
            'status' => 'required'
        ]);

        if(isset($data['image'])){
            $data['image'] = uploadImage($request->file('image'),'images/ranking');
        }

        Ranking::create($data);

        return back()->with('success', 'Ranking Create Successfull');
    }


    function update(Request $request, Ranking $ranking)
    {
        $data = $request->validate([
            'title' => 'required|unique:rankings,title,'.$ranking->id,
            'image' => 'nullable|image|mimes:jpg,png,jpeg',
            'minimum_deposit' => 'required|gt:0',
            'minimum_invest' => "required|gt:0",
            'minimum_referral' => 'required|gt:0',
            'bonus' => 'required|gt:0',
            'status' => 'required'
        ]);

        if(isset($data['image'])){
            $data['image'] = uploadImage($request->file('image'),'images/ranking');

            if(file_exists('public/images/ranking/'.$ranking->image)){
                unlink('public/images/ranking/'.$ranking->image);
            }
        }

        $ranking->update($data);

        return back()->with('success', 'Ranking Update Successfull');
    }
}
