<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Slider;
use Illuminate\Http\Request;

class SliderController extends Controller
{
    public function sliderIndex(){
        $sliders = Slider::all();
        $page_title = "Sliders";
        return view('admin.slider.index',compact('sliders','page_title'));
    }

    public function sliderStore(Request $request){
        $request->validate([
            'header' => 'required',
            'title' => 'required',
            'description' => 'required',
            'image' => 'sometimes|mimes:jpeg,png,bmp,gif,svg|max:1024',
        ]);
        try{
            $fileName = uploadImage($request->file('image'),'images/slider');
            Slider::create([
                'header' => $request->header,
                'title' => $request->title,
                'description' => $request->description,
                'image' => $fileName,
            ]);
            return back()->with('success','Create Successfully');
        }catch (\Exception $e){
            return back()->with('alert',$e->getMessage());
        }
    }

    public function sliderUpdate(Request $request, Slider $sliderArea){
        $request->validate([
            'header' => 'required',
            'title' => 'required',
            'description' => 'required',
            'image' => 'sometimes|mimes:jpeg,png,bmp,gif,svg|max:1024',
        ]);
        try{
            if ($request->file('image')){
                @unlink('public/images/slider/'.$sliderArea->image);
                $fileName = uploadImage($request->file('image'),'images/slider');
            }else{
                $fileName = $sliderArea->image;
            }
            $sliderArea->update([
                'header' => $request->header,
                'title' => $request->title,
                'description' => $request->description,
                'image' => $fileName,
            ]);
            return back()->with('success','Update Successfully');
        }catch (\Exception $e){
            return back()->with('alert',$e->getMessage());
        }
    }

    public function sliderDelete(Slider $sliderArea){
        try{
            @unlink('public/images/slider/'.$sliderArea->image);
            $sliderArea->delete();
            return back()->with('success','Delete Successfully');
        }catch (\Exception $e){
            return back()->with('alert',$e->getMessage());
        }
    }
}
