<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\General;
use App\Models\WithdrawLog;
use App\Models\WithdrawMethod;
use Illuminate\Http\Request;
use Intervention\Image\Facades\Image;

class WithDrawMethodController extends Controller
{
    public function index()
    {
        $page_title = "Withdraw";
        $withdraw = WithdrawMethod::all();
        return view('admin.withdraw.index', compact('withdraw','page_title'));
    }

    public function create(){
        $data['page_title'] = "Withdraw Add";
        return view('admin.withdraw.create', $data);
    }

    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required',
            'image' => 'required|image',
            'min_amo' => 'required|numeric|min:0',
            'max_amo' => 'required|numeric|min:0',
            'chargefx' => 'required|numeric|min:0',
            'chargepc' => 'required|numeric|min:0',
            'rate' => 'required|numeric|min:0',
            'processing_day' => 'required',
            'field_options' => 'required',
        ]);

        try{

            $fileName = uploadImage($request->file('image'),'images/withdraw_methods');
            WithdrawMethod::create([
                'image' => $fileName,
                'name' => $request->name,
                'rate' => $request->rate,
                'min_amo' => $request->min_amo,
                'max_amo' => $request->max_amo,
                'chargefx' => $request->chargefx,
                'chargepc' => $request->chargepc,
                'currency' => $request->currency,
                'processing_day' => $request->processing_day,
                'field_options' => isset($request['field_options']) ? json_encode($request['field_options']) : null,
                'status' => 1,
            ]);
        
            return back()->with('success',__('Create Successfully'));
        }
        catch (\Exception $e){
            return back()->with('alert',$e->getMessage());
        }
    }

    public function edit($id)
    {
        $data['page_title'] = "Withdraw Edit";
        $withdraw = WithdrawMethod::find($id);
        return view('admin.withdraw.edit', $data, compact('withdraw'));
    }

    

    public function update(Request $request,$id)
    {
        $request->validate([
            'name' => 'required',
            'image' => 'mimes:jpg,jpeg,png,svg',
            'min_amo' => 'required|numeric|min:1',
            'max_amo' => 'required|numeric|min:1',
            'chargefx' => 'required',
            'chargepc' => 'required',
            'rate' => 'required',
            'currency' => 'required',
            'processing_day' => 'required',
            'status' => 'required',
            'field_options' => 'required',
        ]);

        try{
            $withdraw = WithdrawMethod::find($id);

            if ($request->file('image')){
                @unlink('public/images/withdraw_methods/'.$withdraw->image);
                $fileName = uploadImage($request->file('image'),'images/withdraw_methods');
            }else{
                $fileName = $withdraw->image;
            }
            $withdraw->update([
                'image' => $fileName,
                'name' => $request->name,
                'min_amo' => $request->min_amo,
                'max_amo' => $request->max_amo,
                'chargefx' => $request->chargefx,
                'chargepc' => $request->chargepc,
                'rate' => $request->rate,
                'currency' => $request->currency,
                'processing_day' => $request->processing_day,
                'field_options' => isset($request['field_options']) ? json_encode($request['field_options']) : null,
                'status' => $request->status,
            ]);

            return back()->with('success',__('Update Successfully'));
        }catch (\Exception $e){
            return back()->with('alert',$e->getMessage());
        }
        
    }

    public function requestWithdraw()
    {
        $page_title = "Withdraw Requests";
        $withdraw = WithdrawLog::orderBy('id', 'desc')->where('status', 0)->paginate(15);
        return view('admin.withdraw.withdraw_request', compact('withdraw','page_title'));
    }

    public function detailWithdraw($id)
    {
        $page_title = "Withdraw Details";
        $data = WithdrawLog::findOrFail($id);
        return view('admin.withdraw.withdraw_detal', compact('data','page_title'));
    }

    public function showReceipt($id){
        $data = WithdrawLog::find($id)->detail;
        return view('admin.withdraw.include.__withdraw_action', compact('data', 'id'))->render();

    }

    public function repondWithdraw(Request $request, $id)
    {
        $request->validate([
            'message' => 'required',
        ]);
        $withdraw = WithdrawLog::find($id);
        if ( $withdraw instanceof  WithdrawLog){
            $withdraw->status = $request->status;
            $withdraw->update();
            $user = $withdraw->user;
            if ($request->status == 1 ) {
                $message = $request->message;
                $general = General::first();
                $shortCodes = [
                    'trx' => $withdraw->trx,
                    'amount' => $withdraw->amount,
                    'charge' => $withdraw->charge,
                    'currency' => $general->currency,
                    'rate' => $withdraw->method_rate,
                    'method_name' => $withdraw->method_name,
                    'method_currency' => $withdraw->method_cur,
                    'method_message' => $message
                ];
                @send_email($user, 'WITHDRAW_APPROVE' , $shortCodes);
                return back()->with('success','Paid Complete');
            }else{
                $withdraw->user()->update([
                    'balance' => floatval($user->balance) + floatval($withdraw->amount) + floatval($withdraw->charge)
                ]);
                $message = $request->message;
                $general = General::first();
                $shortCodes = [
                    'trx' => $withdraw->trx,
                    'amount' => $withdraw->amount,
                    'charge' => $withdraw->charge,
                    'currency' => $general->currency,
                    'rate' => $withdraw->method_rate,
                    'method_name' => $withdraw->method_name,
                    'method_currency' => $withdraw->method_cur,
                    'method_message' => $message
                ];
                @send_email($user, 'WITHDRAW_REJECT' , $shortCodes);
                return back()->with('success','Refund Complete');
            }
        }

        return back()->with('alert','Log not found');
    }
    public function showWithdrawLog()
    {
        $page_title = "Withdraw Log";
        $withdraw = WithdrawLog::latest('updated_at')->paginate(15);
        return view('admin.withdraw.view_log', compact('withdraw','page_title'));
    }
}

?>