<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use Illuminate\Foundation\Auth\SendsPasswordResetEmails;
use Illuminate\Http\Request;
use App\Models\User;
use App\Models\PaymentGatway;
use App\Models\PasswordReset as PS;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;

class ForgotPasswordController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Password Reset Controller
    |--------------------------------------------------------------------------
    |
    | This controller is responsible for handling password reset emails and
    | includes a trait which assists in sending these notifications from
    | your application to your users. Feel free to explore this trait.
    |
    */

    use SendsPasswordResetEmails;

    public function __construct()
    {
        $this->theme = template();
    }

    public function showEmailForm() {
        $data['gateways'] = PaymentGatway::where('status', 1)->get();
        return view($this->theme .'user.auth.passwords.email',$data);
    }

    public function sendResetPassMail(Request $request)
    {
        $request->validate([
            'resetEmail' => 'required',
        ]);
        $user = User::where('email', $request->resetEmail)->first();
        if ($user == null){
            return back()->with('alert', 'Email Not Available');
        }else{
            $to =$user->email;
            $code = Str::random(30);
            DB::table('password_resets')->insert(
                ['email' => $to, 'token' => $code, 'status' => 0, 'created_at' => date("Y-m-d h:i:s")]
            );
            $userIpInfo = getIpInfo();
            $userBrowserInfo = osBrowser();
            send_email($user, 'PASS_RESET_CODE', [
                'code' => ''.url('/').'/reset/'.$code,
                'operating_system' => @$userBrowserInfo['os_platform'],
                'browser' => @$userBrowserInfo['browser'],
                'ip' => @$userIpInfo['ip'],
                'time' => @$userIpInfo['time']
            ]);
            return back()->with('success', 'Password Reset Email Sent Successfully');

        }

    }

    public function resetPasswordForm($code) {
        $ps = PS::where('token', $code)->first();

        if ($ps == null) {
            return redirect()->route('user.showEmailForm');
        } else {
            if ($ps->status == 0) {
                $emp = User::where('email', $ps->email)->first();
                $data['email'] = $emp->email;
                $data['code'] = $code;
                return view($this->theme .'user.auth.passwords.reset', $data);
            } else {
                return redirect()->route('user.showEmailForm');
            }
        }
    }

    public function resetPassword(Request $request) {
        $messages = [
            'password_confirmation.confirmed' => 'Password does not match'
        ];

        $validatedData = $request->validate([
            'password' => 'required|confirmed',
        ], $messages);

        $user = User::where('email', $request->email)->first();
        $user->password = Hash::make($request->password);
        $user->save();

        $credentials = $request->only('email', 'password');
        if (Auth::attempt($credentials)) {
            // Authentication passed...

            $userIpInfo = getIpInfo();
            $userBrowser = osBrowser();
            send_email($user, 'PASS_RESET_DONE', [
                'operating_system' => @$userBrowser['os_platform'],
                'browser' => @$userBrowser['browser'],
                'ip' => @$userIpInfo['ip'],
                'time' => @$userIpInfo['time']
            ]);
            return redirect()->route('home');
        }
    }
}

?>