<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Providers\RouteServiceProvider;
use App\Models\User;
use App\Models\General;
use App\Models\Notification;
use App\Models\Wallet;
use App\Models\PaymentGatway;
use Illuminate\Foundation\Auth\RegistersUsers;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
use Illuminate\Auth\Events\Registered;
use Illuminate\Http\Request;
use Illuminate\Support\Str;

class RegisterController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Register Controller
    |--------------------------------------------------------------------------
    |
    | This controller handles the registration of new users as well as their
    | validation and creation. By default this controller uses a trait to
    | provide this functionality without requiring any additional code.
    |
    */

    use RegistersUsers;

    
    protected function validator(array $data)
    {
        return Validator::make($data, [
            'name' => ['required', 'string', 'max:255'],
            'email' => ['required', 'string', 'email', 'max:255', 'unique:users'],
            'password' => ['required', 'string', 'min:8', 'confirmed'],
        ]);
    }

    /**
     * Create a new user instance after a valid registration.
     *
     * @param  array  $data
     * @return \App\User
     */
    protected function create(array $data)
    {
        $basic = General::first();

        if ($basic->emailver == 1) {
            $email_verify = 1;
        } else {
            $email_verify = 0;
        }

        return User::create([
            'name' => $data['name'],
            'email' => $data['email'],
            'emailv' => $email_verify,
            'tfver' => 0,
            'balance' => 0,
            'identity_verify' => 0,
            'password' => Hash::make($data['password']),
            'referral_token' => uniqid(),
            'ref_id' => isset($data['ref_id']) ? $data['ref_id'] : null,
        ]);
    }

    public function showRegistrationForm($referral_token = null)
    {
        if($referral_token){
            $data['refName'] = User::where('referral_token',$referral_token)->first();
        }
        $data['page_title'] = "Sign-up";
        $data['gateways'] = PaymentGatway::where('status', 1)->get();
        return view(template().'user.auth.register',$data);
    }

    public function register(Request $request)
    {
        $this->validator($request->all())->validate();
        event(new Registered($user = $this->create($request->all())));
        $this->guard()->login($user);
        $characters = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $ran_address = Str::random(16)
                    .mt_rand(1000000, 9999999)
                    . mt_rand(1000000, 9999999)
                    . $characters[rand(0, strlen($characters) - 1)];
        Wallet::create([
            'user_id' => $user['id'],
            'wallet_name' => 'Default',
            'address' => $ran_address,
            'balance' => 0,
            'status' => 1,
        ]);

        $adminNotification = new Notification();
        $adminNotification->user_id = $user->id;
        $adminNotification->title = 'New member registered';
        $adminNotification->click_url = urlPath('user.view',$user->id);
        $adminNotification->save();
       
        return $this->registered($request, $user)
            ?: redirect($this->redirectPath());
    }

    /**
     * The user has been registered.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  mixed  $user
     * @return mixed
     */
    protected function registered(Request $request, $user)
    {
        $general = General::first();

        if ($general->joining_bonus == 1) {
            $amount = $general->bonus_amount;
            $user->balance += $amount;
            $user->save();
        }
    }
}

?>