<?php

namespace App\Http\Controllers;

use App\Models\Deposit;
use App\Models\General;
use App\Http\Controllers\DepositController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;
use PayPal\Auth\OAuthTokenCredential;
use PayPal\Api\Amount;
use PayPal\Api\Payer;
use PayPal\Api\Payment;
use PayPal\Api\RedirectUrls;
use PayPal\Api\Transaction;
use PayPal\Api\PaymentExecution;
use PayPal\Rest\ApiContext;


class PayPalController extends Controller
{
    public function payment()
    {
        
            $track = Session::get('Track');
            $depositData = Deposit::where('trx', $track)->orderBy('id', 'DESC')->first();
            $gnl = General::first();

            $apiContext = new ApiContext(
                new OAuthTokenCredential(
                    $depositData->gateway->gateway_key_one,
                    $depositData->gateway->gateway_key_two
                )
            );
    
            $payer = new Payer();
            $payer->setPaymentMethod("paypal");
    
            // Set redirect URLs
            $redirectUrls = new RedirectUrls();
            $redirectUrls->setReturnUrl(route('paypal.payment.success'))
                ->setCancelUrl(route('home'));
    
    
            // Set payment amount
            $amount = new Amount();
            $amount->setCurrency('USD')
                ->setTotal($depositData['usd_amo']);
    
            // Set transaction object
            $transaction = new Transaction();
            $transaction->setAmount($amount)
                ->setDescription("Transaction Number {$depositData->trx}");
    
            // Create the full payment object
            $payment = new Payment();
            $payment->setIntent('sale')
                ->setPayer($payer)
                ->setRedirectUrls($redirectUrls)
                ->setTransactions(array($transaction));
    
    
    
            // Create payment with valid API context
            try {
                $payment->create($apiContext);
    
                // Get PayPal redirect URL and redirect the customer
                $approvalUrl = $payment->getApprovalLink();
                
    
                $data = json_decode($payment);
    
                return $data->links[1]->href;
            }catch (\PayPal\Exception\PayPalConnectionException $ex) {
                return redirect()->route('users.showDepositMethods')->with('alert', $ex->getMessage());
            }

    }

    public function cancel()
    {
        return redirect()->route('users.showDepositMethods')->with('alert', 'Sorry you payment is canceled');
    }


    public function success(Request $request, DepositController $controller)
    {
        $provider = new ExpressCheckout;
        $response = $provider->getExpressCheckoutDetails($request->token);
        $deposit = Deposit::where('trx',$response['INVNUM'])->first();
        if (in_array(strtoupper($response['ACK']), ['SUCCESS', 'SUCCESSWITHWARNING'])) {
            return $controller->userDataUpdate($deposit);
        }
        return redirect()->route('users.showDepositMethods')->with('alert', 'Something is wrong.');
    }
}

?>