<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\PaymentGatway;
use App\Models\General;
use App\Models\Deposit;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Str;
use App\Models\DepositRequest;
use App\Lib\coinPayments;
use App\Models\Notification;
use App\Models\User;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;
use Intervention\Image\Facades\Image;

class PaymentGatwayController extends Controller
{

    public function __construct()
    {
        $this->theme = template();
    }

    public function gateway($code)
    {
        $gateway = PaymentGatway::code($code)->first();

        if ($gateway->id > 69) {
            $gateway = PaymentGatway::code($code)->first();

            $fieldOptions = $gateway->field_options;

            $gateway = array_merge($gateway->toArray(), ['credentials' => view($this->theme . 'user.deposit.include.manual', compact('fieldOptions'))->render()]);
        }

        return $gateway;
    }

    public function addDeposit()
    {
        $data['gateways'] = PaymentGatway::where('status', 1)->get();
        $data['page_title'] = 'Add Fund';
        return view($this->theme . 'user.deposit.deposit', $data);
    }

    public function depositAmountInsert(Request $request)
    {
        $request->validate( [
            'amount' => 'required|numeric|min:0',
            'gateway' => 'required|integer'
        ]);

        $gateway = PaymentGatway::whereStatus(1)->whereId($request->gateway)->first();
        $gnl = General::first();

        if ($gateway instanceof PaymentGatway) {
            $trx = Str::random(16);
            if ($gateway->minimum_deposit_amount <= $request->amount && $gateway->maximum_deposit_amount >= $request->amount) {
                $charge = $gateway->fixed_charge + ($request->amount * $gateway->percentage_charge / 100);
                $usdamo = ($request->amount + $charge) / $gateway->rate;

                if ($gateway->id > 69) {

                    $params = $request->manual_data;

                    foreach ($params as $key => $value) {
                        if (is_file($value)) {
                            $fileName = uploadImage($value, 'images/receipt_img');
                            $params[$key] = $fileName;
                        }
                    }


                    $dr = new DepositRequest;
                    $dr->user_id = Auth::user()->id;
                    $dr->gateway_id = $gateway->id;
                    $dr->amount = floatval($request->amount);
                    $dr->charge = $charge;
                    $dr->usd_amo = floatval($usdamo);
                    $dr->trx = $trx;
                    $dr->detail = json_encode($params);

                    $adminNotification = new Notification();
                    $adminNotification->user_id = Auth::id();
                    $adminNotification->title = 'Deposit request send successfully via ' . $dr->gateway->name;
                    $adminNotification->click_url = urlPath('admin.deposit.pending');
                    $adminNotification->save();

                    $user = User::find($dr->user_id);
                    $shortCodes = [
                        'trx' => $dr->trx,
                        'amount' => $dr->amount,
                        'charge' => $dr->charge,
                        'rate' => $dr->gateway->rate,
                        'currency' => $gnl->currency,
                        'method_name' => $dr->gateway->name,
                        'method_currency' => $gnl->currency,
                    ];
                    @send_email($user, 'DEPOSIT_REQUEST', $shortCodes);
                    $dr->save();
                }
                $depo['user_id'] = Auth::id();
                $depo['gateway_id'] = $gateway->id;
                $depo['amount'] = $request->amount;
                $depo['charge'] = $charge;
                $depo['usd_amo'] = round($usdamo, 2);
                $depo['btc_amo'] = 0;
                $depo['btc_wallet'] = "";
                $depo['trx'] = $trx;
                $depo['try'] = 0;
                $depo['status'] = 0;
                Deposit::create($depo);
                Session::put('Track', $depo['trx']);
                return redirect()->route('user.deposit.preview');
            }
            return back()->with('alert', 'Minimum :' . $gateway->minimum_deposit_amount . ' & Maximum' . $gateway->maximum_deposit_amount . ' amount is required for ' . $gateway->name);
        }
        return back()->with('alert', 'Gateway not found please try again.');
    }

    public function depositPreview()
    {
        $track = Session::get('Track');
        $data = Deposit::where('status', 0)->where('trx', $track)->first();


        $drcount = DepositRequest::where('trx', $track)->count();
        if ($drcount > 0) {
            $dr = DepositRequest::where('trx', $track)->first();
        } else {
            $dr = '';
        }
        $page_title = 'Deposit Preview';
        $data['gateways'] = PaymentGatway::where('status', 1)->get();

        return view($this->theme . 'user.deposit.preview', $data, compact('page_title', 'data', 'dr'));
    }

    public function depositPayNow()
    {

        $track = Session::get('Track');
        $data = Deposit::where('trx', $track)->orderBy('id', 'DESC')->first();
        $gnl = General::first();


        if (!$data instanceof Deposit) {

            return redirect()->route('users.showDepositMethods')->with('alert', 'Invalid Deposit Request');
        }

        try {
            $method = $data->gateway;

            if ($data->gateway_id == 1) {
                return redirect()->to(App::call('App\Http\Controllers\PayPalController@payment'));
            }

            if ($data->gateway_id == 2) {

                $all = file_get_contents("https://blockchain.info/ticker");
                $res = json_decode($all);
                $btcrate = $res->USD->last;
                $amon = $data->amount;
                $usd = $data->usd_amo;
                $bcoin = round($usd / $btcrate, 8);
                $callbackUrl = route('ipn.coinpayemnt');
                $CP = new coinPayments();


                $CP->setMerchantId($method->gateway_key_one);
                $CP->setSecretKey($method->gateway_key_two);
                $ntrc = $data->trx;
                $form = $CP->createPayment('Deposit', 'BTC',  $bcoin, $ntrc, $callbackUrl);
                $page_title = $method->name;
                $data['gateways'] = PaymentGatway::where('status', 1)->get();
                return view($this->theme . 'user.deposit.payment_views.coinpay', $data, compact('bcoin', 'form', 'page_title', 'amon', 'gnl'));
            }

            if ($data->gateway_id == 3) {
                $gatewayData = $data->gateway;
                $page_title = $gatewayData->name;
                $data['gateways'] = PaymentGatway::where('status', 1)->get();
                return view($this->theme . 'user.deposit.payment_views.stripe', $data, compact('track', 'page_title', 'gatewayData'));
            }

            if ($data->gateway_id == 4) {
                $url = 'https://www.payfast.co.za/eng/process'; //https://sandbox.payfast.co.za​/eng/process
                $user = Auth::user();
                $n = explode(" ", $user->name);
                if (count($n) > 1) {
                    $fn = $n['0'];
                    $ln = $n['1'];
                } else {
                    $fn = $user->name;
                    $ln = $user->name;
                }
                $cartTotal = floatval($data->usd_amo);
                $payFast = array(
                    'merchant_id' => $data->gateway->gateway_key_one,
                    'merchant_key' => $data->gateway->gateway_key_two,

                    'return_url' => route('payfast.payment.success'),
                    'cancel_url' => route('payfast.payment.cancel'),
                    'notify_url' => route('payfast.payment.notify'),

                    'name_first' => $fn,
                    'name_last'  => $ln,
                    'email_address' => $user->email,
                    'm_payment_id' => $data->trx,
                    'amount' => number_format(sprintf('%.2f', $cartTotal), 2, '.', ''),
                    'item_name' => 'Deposit#' . $data->trx
                );

                $signature = $this->generateSignature($payFast);
                $payFast['signature'] = $signature;

                $testingMode = true;
                $pfHost = $testingMode ? 'sandbox.payfast.co.za' : 'www.payfast.co.za';
                $htmlForm = '<form id="PayForm" action="https://' . $pfHost . '/eng/process" method="post">';
                foreach ($payFast as $name => $value) {
                    $htmlForm .= '<input name="' . $name . '" type="hidden" value="' . $value . '" />';
                }

                return view($this->theme . 'user.deposit.payment_views.payfast', compact('htmlForm'));
            }

            if ($data->gateway_id == 5) {

                $gatewayData = $data;
                $page_title = $gatewayData->name;
                $data['gateways'] = PaymentGatway::where('status', 1)->get();
                $gateway = PaymentGatway::find(5);
                config([
                    'paystack.publicKey'     => $gateway->gateway_key_one,
                    'paystack.secretKey'     => $gateway->gateway_key_two,
                    'paystack.paymentUrl'     => 'https://api.paystack.co',
                    'paystack.merchantEmail'     => $gateway->gateway_key_three,
                ]);

                return view($this->theme . 'user.deposit.payment_views.paystack', $data, compact('track', 'page_title', 'gatewayData'));
            }

            if ($data->gateway_id == 6) {
                $page_title = $data->gateway->name;
                return view($this->theme . 'user.deposit.payment_views.rave', $data, compact('track', 'page_title'));
            }

            if ($data->gateway_id == 7) {

                $page_title = $data->gateway->name;
                return view($this->theme . 'user.deposit.payment_views.paytm', $data, compact('track', 'page_title'));
            }

            if ($data->gateway_id == 8) {

                $skrill = new SkrillPaymentController;
                return $skrill->makePayment();
            }

            if ($data->gateway_id == 9) {
                $gatewayData = $data;
                $page_title = $gatewayData->name;
                $usd = $data->usd_amo;
                return view($this->theme . 'user.deposit.payment_views.authorizepay', compact('track', 'page_title', 'usd'));
            }

            if ($data->gateway_id == 10) {
                return App::call('App\Http\Controllers\MollieController@preparePayment');
            }

            if ($data->gateway_id == 11) {
                $gatewayData = $data;
                $page_title = $gatewayData->name;
                return view($this->theme . 'user.deposit.payment_views.instamojo', compact('track', 'page_title'));
            }

            if ($data->gateway_id == 12) {
                $gatewayData = $data;
                $page_title = $gatewayData->name;
                return view($this->theme . 'user.deposit.payment_views.sceurionpay', compact('track', 'page_title'));
            }

            if ($data->gateway_id == 13) {
                return App::call('App\Http\Controllers\CoingateController@prepareData');
            }

            if ($data->gateway_id == 14) {
                return App::call('App\Http\Controllers\CoinbasecommerceController@prepareData');
            }

            if ($data->gateway_id == 15) {
                $gatewayData = $data;
                $page_title = $gatewayData->name;
                return view($this->theme . 'user.deposit.payment_views.two_checkout', compact('track', 'page_title', 'gatewayData', 'data'));
            }


            if ($data->gateway_id == 16) {
                $page_title = 'razoroay';
                return view($this->theme . 'user.deposit.payment_views.razorpay', compact('page_title', 'data'));
            }

            if ($data->gateway_id > 3) {

                $dr = DepositRequest::where('trx', $track)->first();
                $dr->sent = 1;
                $dr->save();
                $data->status = 1;
                $data->save();

                Session::flash('success', 'Deposit request sent successfully!');
                return redirect()->route('users.showDepositMethods');
            }


            return redirect()->route('users.showDepositMethods')->with('alert', 'Something went wrong please try again latter.');
        } catch (\Exception $e) {
            return redirect()->route('users.showDepositMethods')->with('alert', $e->getMessage());
        }
    }

    function generateSignature($data, $passPhrase = null)
    {
        $pfOutput = '';
        foreach ($data as $key => $val) {
            if (!empty($val)) {
                $pfOutput .= $key . '=' . urlencode(trim($val)) . '&';
            }
        }
        $getString = substr($pfOutput, 0, -1);
        if ($passPhrase !== null) {
            $getString .= '&passphrase=' . urlencode(trim($passPhrase));
        }
        return md5($getString);
    }
}
