<?php

namespace App\Http\Controllers;

use App\Models\Deposit;
use App\Models\Faq;
use App\Models\General;
use App\Models\PaymentGatway;
use App\Models\InvestLog;
use App\Models\Investor;
use App\Models\Language;
use App\Models\Menu;
use App\Models\News;
use App\Models\Partners;
use App\Models\Plan;
use App\Models\Ranking;
use App\Models\Referral;
use App\Models\Service;
use App\Models\Slider;
use App\Models\User;
use App\Models\WithdrawLog;
use App\Models\WorkArea;
use Carbon\Carbon;

class UiController extends Controller
{
    public function __construct()
    {
        $this->theme = template();
    }
    
    public function index(){

        $data['workAreaFirst'] = WorkArea::first();
        $data['workArea'] = WorkArea::where('id','!=',$data['workAreaFirst']['id'])->get();
        $data['services'] = Service::get();
        $data['sliders'] = Slider::get();
        $data['referral'] = Referral::get();
        $data['investors'] = Investor::get();
        $data['partners'] = Partners::get();
        $data['faqs'] = Faq::get();
        $data['rankings'] = Ranking::where('status', 1)->get();
        $data['news'] = News::get();
        $data['roi_plans'] = Plan::where('return_time_status',1)->get();
        $data['fixed_plans'] = Plan::where('return_time_status',0)->get();
        $data['gateways'] = PaymentGatway::where('status', 1)->get();
        $data['deposits'] = Deposit::latest('updated_at')->take(6)->get();
        $data['withdraw'] = WithdrawLog::latest('updated_at')->take(6)->get();
        return view($this->theme .'frontend.index',$data);
    }

    public function newsIndex(){
        $data['news'] = News::latest('updated_at')->paginate(6);
        $data['gateways'] = PaymentGatway::where('status', 1)->get();
        $data['page_title'] = "All News";
        return view($this->theme .'frontend.news',$data);
    }

    public function contactsIndex(){
        $data['page_title'] = "Contact-us";
        $data['gateways'] = PaymentGatway::where('status', 1)->get();
        return view($this->theme .'frontend.contact',$data);
    }

    public function singlePage($class = null, $id = null){
        if (!is_null($class)){
            try{
                $gnl = General::first();
                $menu = Menu::whereId($id)->whereSlug(trim(strtolower($class)))->first();
                if ($menu) {
                  
                    $data['menu'] = $menu;
                    $data['title'] = $menu->title;
                    $data['description'] = $menu->description;
                    $data['updated_at'] = $menu->updated_at;
                    $data['page_title'] = $menu->title .' Details';

                    $data['recentPostSingle'] = News::latest('updated_at')->take(6)->get();
                    $data['gateways'] = PaymentGatway::where('status', 1)->get();
                    return view($this->theme .'frontend.single',$data);
                }

                if ($class == 'news'){
                    $news = News::find($id);
                    $data['image'] = asset('public/images/news/'.$news->image);
                    $data['title'] = $news->title;
                    $data['description'] = $news->description;
                    $data['updated_at'] = $news->updated_at;
                    $data['page_title'] = "News";
                }elseif ($class == 'work'){
                    $work = WorkArea::findOrFail($id);
                    $data['image'] = asset('public/images/work/'.$work->icon);
                    $data['title'] = $work->title;
                    $data['description'] = $work->description;
                    $data['updated_at'] = $work->updated_at;
                    $data['page_title'] = "Work";
                }elseif ($class == 'about_one'){
                    $data['title'] = $gnl->single_about1_title;
                    $data['description'] = $gnl->single_about1_description;
                    $data['page_title'] = 'Details';
                }elseif ($class == 'about_two'){
                    $data['title'] = $gnl->single_about2_title;
                    $data['description'] = $gnl->single_about2_description;
                    $data['page_title'] = 'Details';
                }else{
                    return back()->with('alert','No Data found');
                }
                $data['recentPostSingle'] = News::latest('updated_at')->take(6)->get();
                $data['gateways'] = PaymentGatway::where('status', 1)->get();
                return view($this->theme .'frontend.single',$data);

            }catch (\Exception $e){
                return back()->with('alert','No Data found');
            }
        }
        return back()->with('alert','No Data found');
    }


    public function cronAction(){
        $general = General::first();
        $lend = InvestLog::where('status',0)->where('next_time', '<', Carbon::now())->cursor();
        
        if (Carbon::now()->format('D') == json_decode($general->date_wise_action)) {
            return "ok";
        }

        $dateWise = json_decode($general->date_wise_action);
        $dateCarbon = Carbon::now()->format('D');
        foreach ($dateWise as $date){
            if($date == $dateCarbon){
                foreach ($lend as $data){
                    if ((is_null($data->get_action)) || ($data->get_action > $data->took_action)){
                        $data->took_action = $data->took_action +1;
                        $data->next_time = Carbon::now()->addHours($data->get_period);

                        if ($data->user){
                            $user = User::find($data->user->id);
                            $payable = (floatval($data->invest_amount) * floatval($data->get_percent))/100;
                            $newBal = floatval($user->balance) + floatval($payable);
                            createTransaction("Return Of Invest : ".$data->plan_name,$payable, $user->balance, $newBal, 4,$data->user_id);
                            $user->balance = $newBal;
                            $user->update();
                            $message =' Congratulation, Money back. '.$payable. $general->currency.' added your balance. And your current balance is '.$newBal. $general->currency.'. Please check for sure.';
                            send_email($user->email, $user->name ,"Return Of Invest : ".$data->plan_name, $message);
                        }
                    
                    }else{
                        $data->status = 1;
                        if($data->capital_back == 1){
                            $user = User::find($data->user->id);
                            $payable = floatval($data->invest_amount);
                            $newBal = floatval($user->balance) + floatval($payable);
                            createTransaction("Return Of Capital : ".$data->plan_name,$payable, $user->balance, $newBal, 4,$data->user_id);
                            $user->balance = $newBal;
                            $user->update();
                            $message =' Congratulation, Capital back. '.$payable. $general->currency.' added your balance. And your current balance is '.$newBal. $general->currency.'. Please check for sure.';
                            @send_email($user->email, $user->name ,"Return Of Capital : ".$data->plan_name, $message);
                        }
                    }
                    $data->update();
                }
            }
        }
    }

    public function changeLang($lang){
        $language = Language::where('code', $lang)->first();
        if (!$language) $lang = 'en';
        session()->put('lang', $lang);
        return redirect()->back();
    }
}

?>