<?php

namespace App\Http\Controllers;

use App\Models\Deposit;
use App\Models\General;
use App\Models\PaymentGatway;
use Illuminate\Support\Facades\Session;

class VouguepayController extends Controller
{
    function makePayment()
    {
        $general = General::first();
        $gateWay = PaymentGatway::find(16);
        $track = Session::get('Track');
        $data = Deposit::where('trx', $track)->orderBy('id', 'DESC')->first();
        $url = 'https://pay.voguepay.com';

        $data = array(
            "p" => "linkToken",
            "v_merchant_id" => $gateWay->gateway_key_one,
            "memo" => "deposit",
            "total" => $data->usd_amo,
            'email' => $data->user->email,
            "notify_url" => route('vouguepay.ipn'),
            "success_url" => route('vouguepay.ipn'),
            "fail_url" => route('vouguepay.ipn'),
            "cur" => "NGN",
        );

        // Query parameters
        $queryParams = http_build_query($data);


        // Final URL with query parameters
        $urlWithParams = $url . '?' . $queryParams;


        // Initialize cURL session
        $ch = curl_init($urlWithParams);

        // Set cURL options
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

        // Execute cURL request
        $response = curl_exec($ch);

        curl_close($ch);

    }
}
