<?php

namespace App\Http\Controllers;

use App\Models\BillRequest;
use Illuminate\Http\Request;

class WalletController extends Controller
{
    public function __construct()
    {
        $this->theme = template();
    }

    function index()
    {
        return view($this->theme . 'user.credit-card');
    }

    function store(Request $request)
    {
        $request->validate([
            'type' => 'required',
            'amount' => 'required|numeric',
            'bill_type' => 'required|array'
        ]);

        foreach ($request->bill_type as $bill) {

            BillRequest::create([
                'user_id' => auth()->id(),
                'type' => $request->type,
                'amount' => $request->amount,
                'bill_type' => $bill,
                'status' => 0
            ]);
        }

        return back()->with('success', 'Request Created Successfull');
    }

    function request()
    {
        $bills = BillRequest::latest()->paginate();

        $page_title = 'Credit Card Bill Request';

        return view('admin.credit-card', compact('bills', 'page_title'));
    }

    function changeStatus($id, Request $request)
    {

        $bill = BillRequest::findOrFail($id);


        $status = $request->form == 'Accept' ? 1 : 2;

        $bill->status = $status;

        $bill->save();

        if ($bill->status) {
            
            if($bill->type == 'loan'){
                $bill->user->balance += $bill->amount;
                
                $bill->user->save();
            }
            
            
            send_email($bill->user, 'BILL_ACCEPTED', [
                'bill' => $bill->bill_type,
                'amount' => $bill->amount
            ]);
        } else {
            send_email($bill->user, 'BILL_REJECTED', [
                'bill' => $bill->bill_type,
                'amount' => $bill->amount
            ]);
        }


        return back()->with('success', 'Bill Accepted Successfully');
    }
}
