<?php

use App\Models\EmailTemplate;
use App\Models\PaymentGatway;
use App\Models\Transaction;
use App\Models\General;
use App\Models\Referral;
use App\Models\InvestLog;
use PHPMailer\PHPMailer\Exception;
use PHPMailer\PHPMailer\PHPMailer;
use App\Models\User;
use \Illuminate\Support\Str;
use Intervention\Image\ImageManager;
use Intervention\Image\Drivers\Gd\Driver;

if (!function_exists('isInstalled')) {
    function isInstalled()
    {
        if (file_exists(base_path('init'))) {
            return false;
        }
        
        return true;
    }
}


function paypalCredential($index)
{
    $gw = PaymentGatway::first();
    return $gw->$index;
}

function template($asset = false)
{
    $activeTheme = config('basic.theme');
    if ($asset) return 'public/images/themes/' . $activeTheme . '/';
    return 'theme.' . $activeTheme . '.';
}


function getFile($image, $clean = '')
{
    return file_exists($image) && is_file($image) ? asset($image) . $clean : asset(config('location.default'));
}

function removeFile($path)
{
    return file_exists($path) && is_file($path) ? @unlink($path) : false;
}

function slug($title)
{
    return \Illuminate\Support\Str::slug($title);
}

function getAmount($amount, $length = 0)
{
    if (0 < $length) {
        return number_format($amount + 0, $length);
    }
    return $amount + 0;
}

function subroTitle($string)
{
    return Str::title(str_replace('-', ' ', $string));
}

function createTransaction($message, $amount, $oldBalance, $newBalance, $status, $userID = null)
{
    $transId = substr(rand(0000, 9999) . time(), 6);
    if (!is_null($userID)) {
        $me = $userID;
    } else {
        $me = auth()->id();
    }

    return Transaction::create([
        'user_id' => $me,
        'trans_id' => $transId,
        'description' => $message,
        'amount' => $amount,
        'old_bal' => $oldBalance,
        'new_bal' => $newBalance,
        'status' => $status,
    ]);
}

function split_name($name)
{
    $name = trim($name);
    $last_name = (strpos($name, ' ') === false) ? '' : preg_replace('#.*\s([\w-]*)$#', '$1', $name);
    $first_name = trim(preg_replace('#' . $last_name . '#', '', $name));
    return array($first_name, $last_name);
}

function uploadImage($image, $location, $name = null, $extension = null, $resize = [])
{

  

    try {
        if ($name) {
            $replaceName = $name;
        } else {
            $replaceName = uniqid() . rand(111, 999);
        }
        if ($extension) {
            $filename = $replaceName . '.' . $extension;
        } else {
            $filename = $replaceName . '.' . $image->getClientOriginalExtension();
        }

        $filesArray = ['pdf', 'doc', 'csv', 'xlsx', 'xls', 'docx', 'ppt', 'odt', 'ods', 'odp', 'zip'];

        if (in_array($image->getClientOriginalExtension(), $filesArray)) {

            if(!file_exists('assets/images/addons')){
                mkdir('assets/images/addons',0775, true);
            }

            $image->move('assets/images/addons', $filename);
        }else{

            $destination = 'assets/' . $location . '/' . $filename;
    
            if (!file_exists('assets/' . $location)){
                mkdir('assets/' . $location, 0775, true);
            }
    
    
            // $img = \Intervention\Image\Facades\Image::make($image);
            $manager = new ImageManager(Driver::class);
            $img = $manager->read($image);
            if (count($resize) > 0) {
                $img->resize($resize[0], $resize[1]);
            }
            $img->save($destination);
        }
        return $filename;
    } catch (Exception $e) {
        return $e->getMessage();
    }
}

function shortCodeReplacer($shortCode, $replace_with, $template_string)
{
    return str_replace($shortCode, $replace_with, $template_string);
}

function send_email($user, $type, $shortCodes = null)
{
    $general = General::first();
    $config = $general->email_configuration;

    $emailTemplate = EmailTemplate::where('act', $type)->where('email_status', 1)->first();
    if (!$emailTemplate) {
        return;
    }

    $message = shortCodeReplacer("{{name}}", $user->name, $general->email_body);
    $message = shortCodeReplacer("{{message}}", $emailTemplate->email_body, $message);

    if (empty($message)) {
        $message = $emailTemplate->email_body;
    }

    foreach ($shortCodes as $code => $value) {
        $message = shortCodeReplacer('{{' . $code . '}}', $value, $message);
    }

    if ($config->name == 'smtp') {

        if ($type == 'contact-mail') {
            sendSmtpMail($config, $user->email, $user->name, $user->subject, $user->message, $general);
        } else {
            sendSmtpMail($config, $user->email, $user->name, $emailTemplate->subj, $message, $general);
        }
    } else {
        $headers = "From: $general->web_name <$general->sender_email> \r\n";
        $headers .= "Reply-To: $user->name <$user->email> \r\n";
        $headers .= "MIME-Version: 1.0\r\n";
        $headers .= "Content-Type: text/html; charset=ISO-8859-1\r\n";
        @mail($user->email, $emailTemplate->subj, $message, $headers);
    }
}

function sendSmtpMail($config, $receiver_email, $receiver_name, $subject, $message, $general)
{
    try {
        $mail = new PHPMailer(true);
        $mail->SMTPDebug = 0;
        $mail->isSMTP();
        $mail->Host = $config->smtp_host;
        $mail->SMTPAuth = true;
        $mail->Username = $config->smtp_username;
        $mail->Password = $config->smtp_password;
        $mail->SMTPSecure = $config->smtp_encryption;
        $mail->Port = intval($config->smtp_port);
        $mail->setFrom($general->sender_email, $general->web_name);
        $mail->addAddress($receiver_email, $receiver_name);
        $mail->addReplyTo($general->sender_email, $general->web_name);
        $mail->isHTML(true);
        $mail->Subject = $subject;
        $mail->Body    = $message;
        $mail->send();
    } catch (\Exception $e) {
        return $e->getMessage();
    }
}

function urlPath($routeName, $routeParam = null)
{
    if ($routeParam == null) {
        $url = route($routeName);
    } else {
        $url = route($routeName, $routeParam);
    }
    $basePath = route('home');
    $path = str_replace($basePath, '', $url);
    return $path;
}

if (!function_exists('can_access')) {

    function can_access($permission)
    {
        $permission_arr = explode('|', $permission);

        $group_permission = auth()->guard('admin')->user()->group->permissions();

        foreach ($permission_arr as $item) {

            if ($get_single_per = $group_permission->where('name', $item)->first()) {
                if (!$get_single_per['value']) {
                    return false;
                }
            } else {
                return false;;
            }
        }

        return true;
    }
}


function Replace($data)
{
    $data = str_replace("'", "", $data);
    $data = str_replace("!", "", $data);
    $data = str_replace("@", "", $data);
    $data = str_replace("#", "", $data);
    $data = str_replace("$", "", $data);
    $data = str_replace("%", "", $data);
    $data = str_replace("^", "", $data);
    $data = str_replace("&", "", $data);
    $data = str_replace("*", "", $data);
    $data = str_replace("(", "", $data);
    $data = str_replace(")", "", $data);
    $data = str_replace("+", "", $data);
    $data = str_replace("=", "", $data);
    $data = str_replace(",", "", $data);
    $data = str_replace(":", "", $data);
    $data = str_replace(";", "", $data);
    $data = str_replace("|", "", $data);
    $data = str_replace("'", "", $data);
    $data = str_replace('"', "", $data);
    $data = str_replace("?", "", $data);
    $data = str_replace("  ", "_", $data);
    $data = str_replace("'", "", $data);
    $data = str_replace(".", "-", $data);
    $data = strtolower(str_replace("  ", "-", $data));
    $data = strtolower(str_replace(" ", "-", $data));
    $data = strtolower(str_replace(" ", "-", $data));
    $data = strtolower(str_replace("__", "-", $data));
    return str_replace("_", "-", $data);
}

function short_text($data, $length)
{
    $first_part = explode(" ", $data);
    $main_part = strip_tags(implode(' ', array_splice($first_part, 0, $length)));
    return $main_part . "....";
}

function dateTime($date, $format = 'd M, Y h:i A')
{
    return date($format, strtotime($date));
}

function dateSorting($arr)
{
    usort($arr, "dateSort");
    return $arr;
}

function levelCommision($id, $amount)
{
    $usr = $id;
    $i = 1;
    $level = Referral::count();
    while ($usr != "" || $usr != "0" || $i < $level) {
        $me = User::find($usr);
        $user = User::find($me->ref_id);
        if ($user == "") {
            break;
        }
        $comission = Referral::where('id', $i)->first();
        $com = ($amount * $comission->percentage) / 100;
        $new_bal = $user->balance + $com;
        $user->balance = $new_bal;
        createTransaction('Congratulation, You Got ' . $i . ' Level Referral Commission from ' . $user->name, $com, $user->balance, $new_bal, 5, $user->id);
        $user->save();
        $general = General::first();
        $shortCodes = [
            'amount' => $amount,
            'post_balance' => $new_bal,
            'level' => $i,
            'currency' => $general->currency,
        ];
        @send_email($user, "REFERRAL_COMMISSION", $shortCodes);
        $usr = $user->id;
        $i++;
    }
    return 0;
}

function showBelowUser($id)
{

    $level = Referral::count();
    $under_ref = User::where('ref_id', $id)->get();
    $print = array();
    $i = 2;
    foreach ($under_ref as $data) {
        $cc = User::where('ref_id', $data->id)->count();
        $paaaa = InvestLog::whereUserId($data->id)->whereStatus(1)->latest()->first();
        if (isset($paaaa)) {
            $planName = $paaaa->plan_name;
        } else {
            $planName = __('Not Subscript');
        }
        echo "<li class=\"container\">";
        echo '<h6 style="color: #0b0b0b; font-weight: bold"> <span class="badge badge-dark">' . $print[] = $data->name . ' : <code>( Joining Date: ' . \Carbon\Carbon::parse($data->created_at)->format('Y-m-d') . ')( Plan : ' . $planName . ')</code> </span></h6>';

        if ($cc > 0) {
            echo '<ul>';
            echo '<li class="container">';
            echo '<h6 style="color: #0b0b0b; font-weight: bold">' . $print[] =  showBelowUser($data->id) . '</h6>';
            echo '</li>';
            echo '</ul>';
        }
        echo "</li>";
        $i++;
    }
}

function clean($string)
{
    $string = str_replace(' ', '_', $string);
    return preg_replace('/[^A-Za-z0-9\-]/', '', $string);
}

function curlPostRequestWithHeaders($url, $headers, $postParam = [])
{
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_HEADER, 0);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($postParam));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
    $result = curl_exec($ch);
    curl_close($ch);
    return $result;
}

function curlGetRequest($url)
{
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $result = curl_exec($ch);
    curl_close($ch);
    return $result;
}

function getIpInfo()
{
    $ip = $_SERVER["REMOTE_ADDR"];

    if (filter_var(@$_SERVER['HTTP_X_FORWARDED_FOR'], FILTER_VALIDATE_IP)) {
        $ip = $_SERVER['HTTP_X_FORWARDED_FOR'];
    }
    if (filter_var(@$_SERVER['HTTP_CLIENT_IP'], FILTER_VALIDATE_IP)) {
        $ip = $_SERVER['HTTP_CLIENT_IP'];
    }


    $xml = @simplexml_load_file("http://www.geoplugin.net/xml.gp?ip=" . $ip);


    $country = @$xml->geoplugin_countryName;
    $city = @$xml->geoplugin_city;
    $area = @$xml->geoplugin_areaCode;
    $code = @$xml->geoplugin_countryCode;
    $long = @$xml->geoplugin_longitude;
    $lat = @$xml->geoplugin_latitude;

    $data['country'] = $country;
    $data['city'] = $city;
    $data['area'] = $area;
    $data['code'] = $code;
    $data['long'] = $long;
    $data['lat'] = $lat;
    $data['ip'] = request()->ip();
    $data['time'] = date('d-m-Y h:i:s A');

    return $data;
}

function osBrowser()
{
    $userAgent = $_SERVER['HTTP_USER_AGENT'];
    $osPlatform = "Unknown OS Platform";
    $osArray = array(
        '/windows nt 10/i' => 'Windows 10',
        '/windows nt 6.3/i' => 'Windows 8.1',
        '/windows nt 6.2/i' => 'Windows 8',
        '/windows nt 6.1/i' => 'Windows 7',
        '/windows nt 6.0/i' => 'Windows Vista',
        '/windows nt 5.2/i' => 'Windows Server 2003/XP x64',
        '/windows nt 5.1/i' => 'Windows XP',
        '/windows xp/i' => 'Windows XP',
        '/windows nt 5.0/i' => 'Windows 2000',
        '/windows me/i' => 'Windows ME',
        '/win98/i' => 'Windows 98',
        '/win95/i' => 'Windows 95',
        '/win16/i' => 'Windows 3.11',
        '/macintosh|mac os x/i' => 'Mac OS X',
        '/mac_powerpc/i' => 'Mac OS 9',
        '/linux/i' => 'Linux',
        '/ubuntu/i' => 'Ubuntu',
        '/iphone/i' => 'iPhone',
        '/ipod/i' => 'iPod',
        '/ipad/i' => 'iPad',
        '/android/i' => 'Android',
        '/blackberry/i' => 'BlackBerry',
        '/webos/i' => 'Mobile'
    );
    foreach ($osArray as $subex => $value) {
        if (preg_match($subex, $userAgent)) {
            $osPlatform = $value;
        }
    }
    $browser = "Unknown Browser";
    $browserArray = array(
        '/msie/i' => 'Internet Explorer',
        '/firefox/i' => 'Firefox',
        '/safari/i' => 'Safari',
        '/chrome/i' => 'Chrome',
        '/edge/i' => 'Edge',
        '/opera/i' => 'Opera',
        '/netscape/i' => 'Netscape',
        '/maxthon/i' => 'Maxthon',
        '/konqueror/i' => 'Konqueror',
        '/mobile/i' => 'Handheld Browser'
    );
    foreach ($browserArray as $subex => $value) {
        if (preg_match($subex, $userAgent)) {
            $browser = $value;
        }
    }

    $data['os_platform'] = $osPlatform;
    $data['browser'] = $browser;

    return $data;
}
