<?php

namespace App\Http\Middleware;

use Closure;

class PermissionMiddleware
{
    public function handle($request, Closure $next, $permission = null){
        $permission_arr = explode('|',$permission);
        $group_permission= auth()->guard('admin')->user()->group->permissions();
        foreach ($permission_arr as $item){
            if($get_single_per = $group_permission->where('name',$item)->first()){
                if(!$get_single_per['value']){
                    return redirect()->to(route('admin.home'))->with('alert','Unauthorised access');
                }
            }else{
               return redirect()->to(route('admin.home'))->with('alert','Unauthorised access');
            }
        }
        return $next($request);
    }
}
