<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class DepositRequest extends Model
{
    use HasFactory;
    protected $guarded = ['id'];

    public function user(){
        return $this->belongsTo(User::class, 'user_id')->withDefault();
    }

    public function gateway() {
        return $this->belongsTo(PaymentGatway::class,'gateway_id')->withDefault();
    }

    public function scopeCode($query, $code)
    {
        return $query->where('id', $code);
    }
}
