<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;

class User extends Authenticatable
{
    use HasFactory, Notifiable, HasApiTokens;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $guarded = ['id'];

    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
        'password', 'remember_token',
    ];

    /**
     * The attributes that should be cast to native types.
     *
     * @var array
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
    ];

    public function refUser()
    {
        return $this->hasMany(User::class, 'ref_id');
    }

    public function investLog()
    {
        return $this->hasMany(InvestLog::class, 'user_id');
    }
    
    public function deposits()
    {
        return $this->hasMany(Deposit::class, 'user_id');
    }

    public function rankings()
    {
        return $this->hasMany(UserRanking::class, 'user_id');
    }

    public function bill_requests()
    {
        return $this->hasMany(BillRequest::class, 'user_id');
    }
}
