<?php

namespace App\Providers;

use App\Models\General;
use App\Models\Language;
use App\Models\Menu;
use App\Models\News;
use App\Models\Notification;
use App\Models\Social;
use App\Models\Support;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\View;
use Illuminate\Support\ServiceProvider;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
       
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        if (isInstalled()) {

            if (Schema::hasTable('generals')) {
                view()->share('general', General::first());
            }

            if (Schema::hasTable('socials')) {
                view()->share('social', Social::get());
            }

            if (Schema::hasTable('menus')) {
                view()->share('frontMenu', Menu::get());
            }

            if (Schema::hasTable('languages')) {
                view()->share('lang', Language::get());
            }

            if (Schema::hasTable('supports')) {
                view()->share('check_count', Support::where('status', 1)->get());
            }

            if (Schema::hasTable('news')) {
                view()->share('recentPost', News::latest('updated_at')->take(2)->get());
            }

            if (Schema::hasTable('notifications')) {
                view()->composer('admin.layouts.partials.nav', function ($view) {
                    $view->with([
                        'adminNotifications' => Notification::where('read_status', 0)->with('user')->orderBy('id', 'desc')->get(),
                    ]);
                });


                $data['theme'] = template();
                $data['themeTrue'] = template(true);

                View::share($data);

                $modulePath = app_path('Modules');

                if (file_exists($modulePath)) {
                    foreach ($dirs = File::directories($modulePath) as $module) {
                        View::addLocation($module . '/views');
                    }
                }
            }
        }
    }
}
