@extends('admin.layouts.master')
@section('title', __('Addon'))
@section('content')
    <div class="row">
        <div class="col-lg-12">
            <div class="card">

                <div class="card-header">
                    <button class="btn btn-sm btn-primary addon">{{ __('Install Addon') }}</button>
                </div>

                <div class="card-body p-0">

                   
                        <table class="table s7__table">
                            <thead>
                                <tr>
                                    <th>{{ __('Addon Name') }}</th>
                                    <th>{{ __('Image') }}</th>
                                    <th>{{ __('Status') }}</th>
                                    <th>{{ __('Actions') }}</th>
                                </tr>
                            </thead>
                            <tbody>

                                @forelse ($addons as $addon)
                                    <tr>

                                        <td>{{ $addon->name }}</td>
                                        <td>
                                            <img src="{{ asset('asset/addon/' . $addon->app_id . '/logo.png') }}"
                                                alt="" width="50">
                                        </td>
                                        <td>
                                            @if ($addon->status)
                                                <span class="badge badge-success">{{__('Active')}}</span>
                                            @else
                                                <span class="badge badge-danger">{{__('Deactive')}}</span>
                                            @endif
                                        </td>
                                        <td>

                                            @if ($addon->status)
                                                <button class="btn btn-danger btn-sm active" data-route="{{route('addon.status', $addon->id)}}"><i
                                                        class="fa fa-times"></i></button>
                                            @else
                                                <button class="btn btn-success btn-sm deactive" data-route="{{route('addon.status', $addon->id)}}"><i
                                                        class="fa fa-check"></i></button>
                                            @endif

                                            <button class="btn btn-sm btn-danger delete" data-route="{{route('addon.delete', $addon->id)}}"><i class="fa fa-trash"></i></button>
                                        </td>

                                    </tr>
                                @empty
                                    <tr>
                                        <td class="text-center" colspan="100%">
                                            {{ __('No Addons Added') }}
                                        </td>
                                    </tr>
                                @endforelse


                            </tbody>
                        </table>

                   
                </div>
            </div>
        </div>

    </div>


    <div class="modal fade" id="addon" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">{{ __('Install Addon') }}</h5>
                    <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <form class="" action="" method="post" enctype="multipart/form-data">
                        @csrf
                        <div class="form-gorup mb-3">
                            <label for="">{{ __('Addon File') }}</label>
                            <input class="form-control" type="file" name="file" required>

                        </div>


                        <div class="">
                            <button type="submit" name="button" class="btn btn-lg btn-primary w-100">@lang('Install Addon')</button>
                        </div>
                    </form>
                </div>

            </div>
        </div>
    </div>


    <div class="modal fade" id="active" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <form action="" method="post">
                @csrf
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">{{__('Addon Status')}}</h5>
                        <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <p>{{__('Are you sure to Change Status this addon')}}</p>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-primary">{{__('Update')}}</button>
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{__('Close')}}</button>
                    </div>
                </div>
            </form>
        </div>
    </div>


    <div class="modal fade" id="delete" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <form action="" method="post">
                @csrf
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">{{__('Uninstall Addon')}}</h5>
                        <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <p>{{__('Are you sure to uninstall this addon')}}</p>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-danger">{{__('Uninstall')}}</button>
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{__('Close')}}</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
@endsection

@section('script')
    <script>
        $(function() {
            'use strict'

            $('.addon').on('click', function() {
                const modal = $('#addon')

                modal.modal('show')
            })
            
            
            $('.active').on('click', function() {
                const modal = $('#active')

                modal.find('form').attr('action', $(this).data('route'));

                modal.modal('show')
            })


            $('.deactive').on('click', function() {
                const modal = $('#active')

                modal.find('form').attr('action', $(this).data('route'));

                modal.modal('show')
            })

            $('.delete').on('click', function() {
                const modal = $('#delete')

                modal.find('form').attr('action', $(this).data('route'));

                modal.modal('show')
            })
        })
    </script>
@endsection
