@extends('admin.layouts.master')
@section('title', __('Bill Payment Request'))
@section('content')

    <div class="card">
        <div class="card-header">
            <h2>@lang('Bill Payments')</h2>
        </div>

        <div class="card-body p-0">
            <table class="table s7__table">
                <thead>
                    <tr>
                        <th>{{ __('User') }}</th>
                        <th>{{ __('Bill Type') }}</th>
                        <th>{{ __('Bill') }}</th>
                        <th>{{ __('Amount') }}</th>
                        <th>{{ __('Date') }}</th>
                        <th>{{ __('Status') }}</th>
                        <th>{{ __('Action') }}</th>
                    </tr>
                </thead>
                <tbody>

                    @forelse ($bills as $bill)
                        <tr>
                            <td>{{ $bill->user->name }}</td>
                            <td>{{ $bill->type }}</td>
                            <td>{{ $bill->bill_type }}</td>
                            <td>{{ $bill->amount }}</td>
                            <td>{{ $bill->created_at }}</td>

                            <td>
                                @if($bill->status == 1)
                                    <span class="badge bg-success">{{__('Accepted')}}</span>
                                @elseif($bill->status == 2)
                                    <span class="badge bg-danger">{{__('Rejected')}}</span>
                                @else
                                    <span class="badge bg-warning">{{__('Pending')}}</span>
                                @endif
                            </td>

                            <td>
                                <button class="btn btn-primary action" data-href="{{ route('credit-card-accept', $bill->id) }}"><i
                                        class="fa fa-pen"></i></button>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td class="text-center" colspan="100">@lang('No Data Found')</td>
                        </tr>
                    @endforelse

                </tbody>
            </table>
        </div>
    </div>


    <div class="modal fade" id="accept" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <form action="" method="post">
                @csrf

                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">{{__('Accept/Reject')}}</h5>
                        <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <p>{{__('Are you sure to take this action?')}}</p>
                    </div>
                    <div class="modal-footer">
                        <input type="submit" class="btn btn-success" name="form" value="Accept">
                        <input type="submit" class="btn btn-danger" name="form" value="Reject">
                    </div>
                </div>
            </form>
        </div>
    </div>

@endsection

@section('script')

<script>
    $('.action').on('click', function(){
        const modal = $('#accept');

        modal.find('form').attr('action', $(this).data('href'))

        modal.modal('show')
    })
</script>
    
@endsection