@extends('admin.layouts.master')
@section('title',__('Gateway'))
@section('content')
    <div class="card">
        <h4 class="card-header">{{__('Gateway List')}}
            <button type="button" class="btn btn-success float-end btn-sm" data-bs-toggle="modal" data-bs-target="#addModal">
                <i class="fa fa-plus"></i> @lang('Add Gateway')
            </button>
        </h4>
        <div class="card-body p-0">
            <table class="table table-sm s7__table">
                <thead>
                <tr>
                    <th>@lang('SL')</th>
                    <th>@lang('Gateway')</th>
                    <th>@lang('Status')</th>
                    <th>@lang('Action')</th>
                </tr>
                </thead>
                <tbody>
                @foreach($gateways as $k=>$gateway)
                    <tr>
                        <td>{{ ++$k }}</td>
                        <td>{{$gateway->name}}</td>
                        <td>
                            @if($gateway->status == 1)
                                <span class="badge bg-success">@lang('Active')</span>
                            @else
                                <span class="badge bg-danger">@lang('Inactive')</span>
                            @endif
                        </td>
                        <td>
                            <button class="btn s7__btn-primary s7__bg-base btn-sm"
                                    data-bs-toggle="modal" data-bs-target="#editModal{{$gateway->id}}"
                                    data-act="Edit">
                            {{__('Edit')}}
                            </button>
                        </td>
                    </tr>

                    <div class="modal fade editModal" id="editModal{{$gateway->id}}" tabindex="-1"
                            role="dialog">
                        <div class="modal-dialog" role="document">
                            <div class="modal-content">

                                <div class="modal-header">
                                    <h4 class="modal-title" id="myModalLabel">@lang('Edit')
                                        <strong>{{$gateway->name}}</strong></h4>
                                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                </div>
                                <form method="post" action="{{route('update.gateway')}}" enctype="multipart/form-data">
                                    {{ csrf_field() }}

                                    <div class="modal-body">
                                        <input class="form-control" value="{{$gateway->id}}" type="hidden" name="id">
                                        <input class="form-control abir_id" value="{{$gateway->id}}" type="hidden" name="id">

                                        <div class="form-group">
                                            <label class="form-label">@lang('Gateway Image')</label>
                                            <input type="file" id="file-input" class="form-control" name="image">
                                            <div class="row mt-2">
                                                <div class="col-md-12">
                                                    <div id='img_contain'>
                                                        <img id="image-preview" class="img-fluid" align='middle' src="{{asset('assets/images/gateway/'.$gateway->image)}}" alt="your image" title=''/>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="form-group">
                                            <div class="row">
                                                <div class="col-md-6">
                                                    <strong>@lang('Name of Gateway')</strong>
                                                    <input type="text" value="{{$gateway->name}}" class="form-control" id="name" name="name" >
                                                </div>
                                                <div class="col-md-6">
                                                    <strong>@lang('Rate')</strong>
                                                    <div class="input-group mb-3">
                                                        <span class="input-group-text">1 USD=</span>
                                                        <input name="rate" value="{{$gateway->rate}}" type="text" class="form-control">
                                                        <span class="input-group-text">{{$general->currency}}</span>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row mb-2">
                                            <div class="col-md-6">
                                                <div class="card mb-3 max-width-18rem">
                                                    <div class="card-header bg-primary text-white"><strong>{{__('Deposit Limit')}}</strong></div>
                                                    <div class="card-body">
                                                        <strong>{{__('Minimum Amount')}}</strong>
                                                        <div class="input-group mb-3">
                                                            <input value="{{$gateway->minimum_deposit_amount}}" type="text" name="minimum_deposit_amount" class="form-control" >
                                                            <span class="input-group-text" id="basic-addon2">{{$general->currency}}</span>
                                                        </div>
                                                        <strong>{{__('Maximum Amount')}}</strong>
                                                        <div class="input-group mb-3">
                                                            <input value="{{$gateway->maximum_deposit_amount}}" type="text" name="maximum_deposit_amount" class="form-control">
                                                            <span class="input-group-text" id="basic-addon2">{{$general->currency}}</span>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="card mb-3 max-width-18rem">
                                                    <div class="card-header bg-primary text-white"><strong>@lang('Deposit Charge')</strong></div>
                                                    <div class="card-body">
                                                        <strong>@lang('Fixed Charge')</strong>
                                                        <div class="input-group mb-3">
                                                            <input value="{{$gateway->fixed_charge}}" type="text" name="fixed_charge" class="form-control" >
                                                            <span class="input-group-text" id="basic-addon2">{{$general->currency}}</span>
                                                        </div>
                                                        <strong>@lang('Charge in Percentage')</strong>
                                                        <div class="input-group mb-3">
                                                            <input value="{{$gateway->percentage_charge}}" type="text" name="percentage_charge" class="form-control">
                                                            <span class="input-group-text" id="basic-addon2">%</span>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        @if ($gateway->id > 69)
                                            <div class="col-xl-4">
                                                <a href="javascript:void(0)" id="generate"
                                                class="btn btn-primary mb-3">{{ __('Add Field option') }}</a>
                                            </div>
                                            <div class="addOptions">
                                            </div>
                                            <div class="form-group">
                                                <strong>@lang('PAYMENT DETAILS')</strong>
                                                <textarea class="form-control" name="gateway_key_four" rows="3" cols="80">{!! $gateway->gateway_key_four !!}</textarea>
                                            </div>
                                        @endif

                                        @if($gateway->id==1)
                                            <div class="form-group mb-2">
                                                <strong>@lang('PAYPAL API USERNAME')</strong>
                                                <input type="text" value="{{$gateway->gateway_key_one}}" class="form-control" id="gateway_key_one" name="gateway_key_one" >
                                            </div>

                                            <div class="form-group mb-2">
                                                <strong>@lang('PAYPAL API PASSWORD')</strong>
                                                <input type="text" value="{{$gateway->gateway_key_two}}" class="form-control" id="gateway_key_two" name="gateway_key_two" >
                                            </div>

                                            <div class="form-group mb-2">
                                                <strong>@lang('PAYPAL API SECRET')</strong>
                                                <input type="text" value="{{$gateway->gateway_key_three}}" class="form-control" id="gateway_key_three" name="gateway_key_three" >
                                            </div>
                                        @endif

                                        @if($gateway->id==2)
                                            <div class="form-group">
                                                <strong>@lang('COINPAYMENT MERCHANT ID')</strong>
                                                <input type="text" value="{{$gateway->gateway_key_one}}" class="form-control" id="gateway_key_one" name="gateway_key_one" >
                                            </div>

                                                <div class="form-group">
                                                <strong>@lang('COINPAYMENT SECRET')</strong>
                                                <input type="text" value="{{$gateway->gateway_key_two}}" class="form-control" id="gateway_key_two" name="gateway_key_two" >
                                            </div>

                                        @endif

                                        @if($gateway->id==3)
                                            <div class="form-group">
                                                <strong>@lang('STRIPE SECRET')</strong>
                                                <input type="text" value="{{$gateway->gateway_key_one}}" class="form-control" id="gateway_key_one" name="gateway_key_one" >
                                            </div>

                                            <div class="form-group">
                                                <strong>@lang('STRIPE KEY')</strong>
                                                <input type="text" value="{{$gateway->gateway_key_two}}" class="form-control" id="gateway_key_two" name="gateway_key_two" >
                                            </div>
                                        @endif

                                        @if($gateway->id==4)
                                            <div class="form-group">
                                                <strong>@lang('PAYFAST MERCHANT ID')</strong>
                                                <input type="text" value="{{$gateway->gateway_key_one}}" class="form-control" id="gateway_key_one" name="gateway_key_one" >
                                            </div>

                                            <div class="form-group">
                                                <strong>@lang('PAYFAST MERCHANT KEY')</strong>
                                                <input type="text" value="{{$gateway->gateway_key_two}}" class="form-control" id="gateway_key_two" name="gateway_key_two" >
                                            </div>
                                        @endif

                                        @if($gateway->id==5)
                                            <div class="form-group">
                                                <strong>@lang('Callback URL')</strong>
                                                <input type="text" value="{{url('/')}}/paystack-payment/callback" class="form-control" readonly>
                                                <p class="text-success"><small>{{__('Copy this link & save on your paystack portal (API Keys & Webhooks)')}}</small></p>
                                            </div>
                                            <div class="form-group">
                                                <strong>@lang('PAYSTACK assets KEY')</strong>
                                                <input type="text" value="{{$gateway->gateway_key_one}}" class="form-control" id="gateway_key_one" name="gateway_key_one" >
                                            </div>

                                            <div class="form-group">
                                                <strong>@lang('PAYSTACK SECRET KEY')</strong>
                                                <input type="text" value="{{$gateway->gateway_key_two}}" class="form-control" id="gateway_key_two" name="gateway_key_two" >
                                            </div>

                                            <div class="form-group">
                                                <strong>@lang('MERCHANT EMAIL')</strong>
                                                <input type="text" value="{{$gateway->gateway_key_three}}" class="form-control" id="gateway_key_three" name="gateway_key_three" >
                                            </div>
                                        @endif

                                        @if($gateway->id==6)
                                            <div class="form-group">
                                                <strong>@lang('FLW assets KEY')</strong>
                                                <input type="text" value="{{$gateway->gateway_key_one}}" class="form-control" id="gateway_key_one" name="gateway_key_one" >
                                            </div>

                                            <div class="form-group">
                                                <strong>@lang('FLW SECRET KEY')</strong>
                                                <input type="text" value="{{$gateway->gateway_key_two}}" class="form-control" id="gateway_key_two" name="gateway_key_two" >
                                            </div>

                                            <div class="form-group">
                                                <strong>@lang('FLW SECRET HASH')</strong>
                                                <input type="text" value="{{$gateway->gateway_key_three}}" class="form-control" id="gateway_key_three" name="gateway_key_three" >
                                            </div>
                                        @endif

                                        @if($gateway->id==7)
                                            <div class="form-group">
                                                <strong>@lang('PAYTM MERCHANT ID')</strong>
                                                <input type="text" value="{{$gateway->gateway_key_one}}" class="form-control" id="gateway_key_one" name="gateway_key_one" >
                                            </div>

                                            <div class="form-group">
                                                <strong>@lang('PAYTM MERCHANT KEY')</strong>
                                                <input type="text" value="{{$gateway->gateway_key_two}}" class="form-control" id="gateway_key_two" name="gateway_key_two" >
                                            </div>
                                        @endif

                                        @if($gateway->id==8)
                                            <div class="form-group">
                                                <strong>@lang('Skrill EMAIL')</strong>
                                                <input type="text" value="{{$gateway->gateway_key_one}}" class="form-control" id="gateway_key_one" name="gateway_key_one" >
                                            </div>
                                        @endif

                                        @if($gateway->id==9)
                                            <div class="form-group">
                                                <strong>{{__('MERCHANT LOGIN ID')}}</strong>
                                                <input type="text" value="{{$gateway->gateway_key_one}}" class="form-control" id="gateway_key_one" name="gateway_key_one" >
                                            </div>

                                            <div class="form-group">
                                                <strong>{{__('MERCHANT TRANSACTION KEY')}}</strong>
                                                <input type="text" value="{{$gateway->gateway_key_two}}" class="form-control" id="gateway_key_two" name="gateway_key_two" >
                                            </div>
                                        @endif

                                        @if($gateway->id==10)
                                            <div class="form-group">
                                                <strong>{{__('API KEY')}}</strong>
                                                <input type="text" value="{{$gateway->gateway_key_one}}" class="form-control" id="gateway_key_one" name="gateway_key_one" >
                                            </div>
                                        @endif

                                        @if($gateway->id==11)
                                            <div class="form-group">
                                                <strong>{{__('API KEY')}}</strong>
                                                <input type="text" value="{{$gateway->gateway_key_one}}" class="form-control" id="gateway_key_one" name="gateway_key_one" >
                                            </div>
                                            <div class="form-group">
                                                <strong>{{__('AUTH TOKEN')}}</strong>
                                                <input type="text" value="{{$gateway->gateway_key_two}}" class="form-control" id="gateway_key_two" name="gateway_key_two" >
                                            </div>
                                            <div class="form-group">
                                                <strong>{{__('API URL')}}</strong>
                                                <input type="text" value="{{$gateway->gateway_key_three}}" class="form-control" id="gateway_key_three" name="gateway_key_three" >
                                        @endif

                                        @if($gateway->id==12)
                                            <div class="form-group">
                                                <strong>{{__('assets KEY')}}</strong>
                                                <input type="text" value="{{$gateway->gateway_key_one}}" class="form-control" id="gateway_key_one" name="gateway_key_one" >
                                            </div>
                                            <div class="form-group">
                                                <strong>{{__('SECRET KEY')}}</strong>
                                                <input type="text" value="{{$gateway->gateway_key_two}}" class="form-control" id="gateway_key_two" name="gateway_key_two" >
                                            </div>
                                        @endif

                                        @if($gateway->id==13)
                                            <div class="form-group">
                                                <strong>{{__('API KEY')}}</strong>
                                                <input type="text" value="{{$gateway->gateway_key_one}}" class="form-control" id="gateway_key_one" name="gateway_key_one" >
                                            </div>
                                        @endif

                                        @if($gateway->id==14)
                                            <div class="form-group">
                                                <strong>{{__('API KEY')}}</strong>
                                                <input type="text" value="{{$gateway->gateway_key_one}}" class="form-control" id="gateway_key_one" name="gateway_key_one" >
                                            </div>
                                            <div class="form-group">
                                                <strong>{{__('SECRET KEY')}}</strong>
                                                <input type="text" value="{{$gateway->gateway_key_two}}" class="form-control" id="gateway_key_two" name="gateway_key_two" >
                                            </div>
                                        @endif

                                        @if($gateway->id==15)
                                            <div class="form-group">
                                                <strong>{{__('PUBLISHABLE KEY')}}</strong>
                                                <input type="text" value="{{$gateway->gateway_key_one}}" class="form-control" id="gateway_key_one" name="gateway_key_one" >
                                            </div>
                                            <div class="form-group">
                                                <strong>{{__('PRIVATE KEY')}}</strong>
                                                <input type="text" value="{{$gateway->gateway_key_two}}" class="form-control" id="gateway_key_two" name="gateway_key_two" >
                                            </div>
                                        @endif


                                        <div class="form-group">
                                            <strong>{{__('Status')}}</strong>
                                            <select class="form-select" name="status">
                                                <option value="1" {{$gateway->status==1?'selected':''}}>@lang('Active')</option>
                                                <option value="0" {{$gateway->status==0?'selected':''}}>@lang('Inactive')</option>
                                            </select>
                                        </div>
                                    </div>

                                    <div class="modal-footer">
                                        <button type="button" class=" btn btn-danger" data-bs-dismiss="modal" aria-hidden="true">@lang('Close')</button>
                                        <button type="submit" class="btn btn-success ">@lang('Save Changes')</button>
                                    </div>

                                </form>
                            </div>
                        </div>
                    </div>
                @endforeach
                <tbody>
            </table>
        </div>
    </div>

<div class="modal fade" id="addModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <form class="" action="{{route('store.gateway')}}" method="post" enctype="multipart/form-data">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">@lang('Add Payment Gateway')</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    {{csrf_field()}}

                    <div class="form-group">
                        <div class="row">
                            <div class="col-md-12 mb-2">
                                <strong>@lang('Gateway Image')</strong>
                                <input type="file" value="" class="form-control" name="image" required>
                            </div>

                            <div class="col-md-6">
                                <strong>@lang('Name of Gateway')</strong>
                                <input type="text" value="" class="form-control" id="name" name="name" >
                            </div>
                            <div class="col-md-6">
                                <strong>@lang('Rate')</strong>
                                <div class="input-group mb-3">
                                        <span class="input-group-text">1 USD = </span>
                                    <input name="rate" type="text" class="form-control">
                                        <span class="input-group-text"> {{ $general->currency }}</span>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row mb-2">
                        <div class="col-md-6">
                            <div class="card mb-3 max-width-18rem">
                                <div class="card-header bg-primary text-white"><strong>@lang('Deposit Limit')</strong></div>
                                <div class="card-body">
                                    <strong>@lang('Minimum Amount')</strong>
                                    <div class="input-group mb-3">
                                        <input type="text" name="minimum_deposit_amount" class="form-control" >
                                            <span class="input-group-text" id="basic-addon2">{{$general->currency}}</span>
                                    </div>
                                    <strong>@lang('Maximum Amount')</strong>
                                    <div class="input-group mb-3">
                                        <input type="text" name="maximum_deposit_amount" class="form-control">
                                            <span class="input-group-text" id="basic-addon2">{{$general->currency}}</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="card mb-3 max-width-18rem">
                                <div class="card-header bg-primary text-white"><strong>@lang('Deposit Charge')</strong></div>
                                <div class="card-body">
                                    <strong>@lang('Fixed Charge')</strong>
                                    <div class="input-group mb-3">
                                        <input type="text" name="fixed_charge" class="form-control" placeholder="">
                                            <span class="input-group-text" id="basic-addon2">{{$general->currency}}</span>
                                    </div>
                                    <strong>@lang('Charge in Percentage')</strong>
                                    <div class="input-group mb-3">
                                        <input type="text" name="percentage_charge" class="form-control">
                                            <span class="input-group-text" id="basic-addon2">%</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="form-group mb-2">
                        <strong>@lang('Payment Details')</strong>
                        <textarea name="gateway_key_four" rows="3" cols="80" class="form-control"></textarea>
                    </div>

                    <div class="form-group mb-2">
                        <strong>@lang('Status')</strong>
                        <select class="form-select" name="status">
                            <option value="1">@lang('Active')</option>
                            <option value="0">@lang('Inactive')</option>
                        </select>
                    </div>

                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary">@lang('Submit')</button>
                </div>
            </form>
        </div>
    </div>
</div>

@endsection
