@extends('admin.layouts.master')
@section('title',__('Deposit Log'))
@section('content')
    <div class="card">
        <div class="card-header">
            <h4>
                @if (request()->path() == 'admin/deposit/acceptedRequests')
                    @lang('Accepted')
                @elseif (request()->path() == 'admin/deposit/rejectedRequests')
                    @lang('Rejected')
                @elseif (request()->path() == 'admin/deposit/pending')
                    @lang('Pending')
                @endif
                @lang('Deposit Request')
            </h4>
        </div>

        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table s7__table">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>@lang('Name')</th>
                            <th>@lang('Gateway Name')</th>
                            <th>@lang('Amount')</th>
                            <th>@lang('Charge')</th>
                            <th>@lang('Receipt')</th>
                            @if (request()->path() != 'admin/deposit/acceptedRequests' && request()->path() != 'admin/deposit/rejectedRequests')
                                <th>@lang('Action')</th>
                            @endif
                        </tr>
                    </thead>
                    <tbody>
                    @php
                        $i = 0;
                    @endphp
                    @foreach ($deposits as $deposit)
                        <tr>
                            <td data-label="Name">{{++$i}}</td>
                            <td data-label="Username"><a target="_blank" href="{{route('user.view', $deposit->user_id)}}">{{$deposit->user->name}}</a></td>
                            <td data-label="Email">{{$deposit->gateway->name}}</td>
                            <td data-label="Mobile">{{round($deposit->amount, 8)}} {{$general->currency}}</td>
                            <td data-label="Balance">{{round($deposit->charge, 8)}} {{$general->currency}}</td>
                            <td>
                                <button type="button" class="btn s7__btn-primary s7__bg-base showImageInModal" id="deposit-action" data-id="{{$deposit->id}}" ><i class="fa fa-eye"></i> @lang('Show')</button>
                            </td>
                            @if (request()->path() != 'admin/deposit/acceptedRequests' && request()->path() != 'admin/deposit/rejectedRequests')
                                <td data-label="Details">
                                    <form class="inline-block deposit_rec mb-1" action="{{route('admin.deposit.accept')}}" method="post">
                                        {{csrf_field()}}
                                        <input type="hidden" name="gid" value="{{$deposit->gateway->id}}">
                                        <input type="hidden" name="dID" value="{{$deposit->id}}">
                                        <button type="submit" class="btn btn-sm btn-success">
                                            <i class="fa fa-check"></i>  @lang('Accept')
                                        </button>
                                    </form>
                                    <form class="inline-block deposit_rec" action="{{route('admin.deposit.rejectReq')}}" method="post">
                                        {{csrf_field()}}
                                        <input type="hidden" name="dID" value="{{$deposit->id}}">
                                        <button type="submit" class="btn btn-sm btn-danger">
                                            <i class="fa fa-times"></i> @lang('Reject')
                                        </button>
                                    </form>
                                </td>
                            @endif
                        </tr>
                    @endforeach
                    </tbody>
                </table>
                <div class="d-flex justify-content-center">
                    {{$deposits->links('pagination::bootstrap-4')}}
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade showImageModal" id="deposit-action-modal" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title">@lang('Receipt Image') <span id="modalHeader"></span></h4>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="deposit-action">

                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">@lang('Close')</button>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('script')
    <script>
        (function($) {
            "use strict";

            $('body').on('click', '#deposit-action', function () {
                $('.deposit-action').empty();
                var id = $(this).data('id');
                var url = '{{ route("admin.deposit.showReceipt",":id") }}';
                url = url.replace(':id', id);
                $.get(url, function (data) {
                    $('.deposit-action').append(data)
                    imagePreview()
                });

                $('#deposit-action-modal').modal('toggle');
            })


    })(jQuery);
    </script>
@stop
