@extends('admin.layouts.master')
@section('title',__($page_title))
@section('content')
    <div class="card">
        <div class="card-body">
            <h4 class="card-title text-end"><a href="{{route('admin.manual.gateway')}}" class="btn btn-sm s7__btn-dark @if(Request::routeIs('admin.manual.gateway')) active @endif">
                <i class="las la-arrow-left"></i> {{__('Go Back')}}
                </a>
            </h4>

            <form action="{{route('gateway.store')}}" method="post" class='forms-sample' enctype="multipart/form-data">
                @csrf
                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label><strong>{{__('Image')}} <small>{{__('(PNG format is standard)')}}</small></strong></label>
                            <input type="file" name="image" class="form-control">
                            <div class="row mt-2">
                                <div class="col-md-12">
                                    <div id='img_contain'>
                                        <img id="image-preview" class="img-fluid" src="{{asset('assets/images/no-image.png')}}" alt="your image"/>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-8">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label><strong>{{__('Name of Gateway')}}</strong></label>
                                    <input type="text" value="" class="form-control" id="name" name="name">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label><strong>{{__('Rate')}}</strong></label>
                                    <div class="input-group mb-3">
                                        <span class="input-group-text">1 USD = </span>
                                        <input name="rate" type="text" class="form-control">
                                        <span class="input-group-text"> {{ $general->currency }}</span>
                                    </div>
                                </div>
                            </div>
                        </div>
        
                        <div class="row justify-content-center">
                            <div class="col-md-6">
                                <div class="card mb-3 max-width-18rem">
                                    <div class="card-header bg-primary text-white"><strong>{{__('Deposit Limit')}}</strong></div>
                                    <div class="card-body">
                                        <label><strong>{{__('Minimum Amount')}}</strong></label>
                                        <div class="input-group mb-3">
                                            <input type="text" name="minimum_deposit_amount" class="form-control">
                                            <span class="input-group-text" id="basic-addon2">{{$general->currency}}</span>
                                        </div>
                                        <label><strong>{{__('Maximum Amount')}}</strong></label>
                                        <div class="input-group">
                                            <input type="text" name="maximum_deposit_amount" class="form-control">
                                            <span class="input-group-text" id="basic-addon2">{{$general->currency}}</span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="card">
                                    <div class="card-header bg-primary text-white"><strong>{{__('Deposit Charge')}}</strong></div>
                                    <div class="card-body">
                                        <label><strong>{{__('Fixed Charge')}}</strong></label>
                                        <div class="input-group mb-3">
                                            <input type="text" name="fixed_charge" class="form-control" placeholder="">
                                            <span class="input-group-text" id="basic-addon2">{{$general->currency}}</span>
                                        </div>
                                        <label><strong>{{__('Charge in Percentage')}}</strong></label>
                                        <div class="input-group">
                                            <input type="text" name="percentage_charge" class="form-control">
                                            <span class="input-group-text" id="basic-addon2">%</span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label><strong>{{__('Status')}}</strong></label>
                                    <select class="form-select" name="status">
                                        <option value="1">{{__('Active')}}</option>
                                        <option value="0">{{__('Inactive')}}</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                </div>

                <div class="row">
                    <div class="col-xl-3">
                        <a href="javascript:void(0)" id="generate"
                           class="btn btn-primary mb-3">{{ __('Add Field option') }}</a>
                    </div>
                    <div class="addOptions">
                    </div>
                </div>
                

                <div class="form-group">
                    <label><strong>{{__('Payment Details')}}</strong></label>
                    <textarea name="gateway_key_four" rows="3" cols="80" class="form-control"></textarea>
                </div>

                <div class="text-center mt-3">
                    <button type="submit" class="btn s7__btn-primary me-2">{{__('Submit')}}</button>
                </div>
            </form>
        </div>
    </div>

@endsection
@section('script')
    <script>
        (function ($) {
            var i = 0;
            "use strict";

            $("#generate").on('click', function () {
                ++i;
                var form = `<div class="mb-4">
                  <div class="option-remove-row row">
                    <div class="col-xl-4 col-lg-6 col-md-6 col-sm-6 col-12">
                      <div class="site-input-groups">
                        <input name="field_options[` + i + `][name]" class="box-input form-control" type="text" value="" required placeholder="Field Name">
                      </div>
                    </div>

                    <div class="col-xl-4 col-lg-6 col-md-6 col-sm-6 col-12">
                      <div class="site-input-groups">
                        <select name="field_options[` + i + `][type]" class="form-select mb-3">
                            <option value="text">Input Text</option>
                            <option value="textarea">Textarea</option>
                            <option value="file">File upload</option>
                        </select>
                      </div>
                    </div>
                    <div class="col-xl-3 col-lg-6 col-md-6 col-sm-6 col-12">
                      <div class="site-input-groups mb-0">
                        <select name="field_options[` + i + `][validation]" class="form-select mb-1">
                            <option value="required">Required</option>
                            <option value="nullable">Optional</option>
                        </select>
                      </div>
                    </div>

                    <div class="col-xl-1 col-lg-6 col-md-6 col-sm-6 col-12">
                      <button class="delete-option-row delete_desc  btn btn-danger" type="button">
                        <i class="fas fa-times"></i>
                      </button>
                    </div>
                    </div>
                  </div>`;
                $('.addOptions').append(form)
            });

            $(document).on('click', '.delete_desc', function () {
                $(this).closest('.option-remove-row').parent().remove();
            });


        })(jQuery)
    </script>
@endsection