@extends('admin.layouts.master')
@section('title', __($page_title))
@section('content')
    <div class="card">
        <div class="card-body">
            <form action="{{ route('gateway.update', $gateway->id) }}" method="post" enctype="multipart/form-data"
                class="forms-sample">
                @csrf
                @method('PATCH')
                <div class="row mb-3">
                    <div class="col-md-5">
                        <input class="form-control" value="{{ $gateway->id }}" type="hidden" name="id">
                        <div class="form-group">
                            <label><strong>{{ __('Image') }}
                                    <small>{{ __('(PNG format is standard)') }}</small></strong></label>
                            <input type="file" name="image" class="form-control">
                            <div class="row mt-2">
                                <div class="col-md-12">
                                    <div id='img_contain'>
                                        <img id="image-preview" class="img-fluid"
                                            src="{{ asset('assets/images/gateway/' . $gateway->image) }}" alt="your image" />
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-7">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label><strong>{{ __('Name of Gateway') }}</strong></label>
                                    <input type="text" name="name" value="{{ $gateway->name }}" id="name"
                                        class="form-control">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label><strong>{{ __('Rate') }}</strong></label>
                                    <div class="input-group mb-3">
                                        <span class="input-group-text">1 USD =</span>
                                        <input type="number" class="form-control" value="{{ $gateway->rate }}"
                                            name="rate" step="any">
                                        <span class="input-group-text">{{ $general->currency }}</span>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="card card--custom mb-3">
                                    <div class="card-header bg-primary text-white">
                                        <strong>{{ __('Deposit Limit') }}</strong></div>
                                    <div class="card-body">
                                        <label><strong>{{ __('Minimum Amount') }}</strong></label>
                                        <div class="input-group mb-3">
                                            <input type="number" step="any" class="form-control"
                                                value="{{ $gateway->minimum_deposit_amount }}"
                                                name="minimum_deposit_amount">
                                            <span class="input-group-text"
                                                id="basic-addon2">{{ $general->currency }}</span>
                                        </div>
                                        <label><strong>{{ __('Maximum Amount') }}</strong></label>
                                        <div class="input-group mb-3">
                                            <input type="number" step="any" name="maximum_deposit_amount"
                                                value="{{ $gateway->maximum_deposit_amount }}" class="form-control">
                                            <span class="input-group-text"
                                                id="basic-addon2">{{ $general->currency }}</span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="card card--custom mb-3">
                                    <div class="card-header bg-primary text-white">
                                        <strong>{{ __('Deposit Charge') }}</strong></div>
                                    <div class="card-body">
                                        <label><strong>{{ __('Fixed Charge') }}</strong></label>
                                        <div class="input-group mb-3">
                                            <input type="number" step="any" class="form-control"
                                                value="{{ $gateway->fixed_charge }}" name="fixed_charge">
                                            <span class="input-group-text"
                                                id="basic-addon2">{{ $general->currency }}</span>
                                        </div>
                                        <label><strong>{{ __('Charge in Percentage') }}</strong></label>
                                        <div class="input-group mb-3">
                                            <input type="number" step="any" class="form-control"
                                                value="{{ $gateway->percentage_charge }}" name="percentage_charge">
                                            <span class="input-group-text" id="basic-addon2">%</span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label><strong>{{ __('Status') }}</strong></label>
                                    <select class="form-select" name="status">
                                        <option value="1" {{ $gateway->status == 1 ? 'selected' : '' }}>{{ __('Active') }}
                                        </option>
                                        <option value="0" {{ $gateway->status == 0 ? 'selected' : '' }}>
                                            {{ __('Inactive') }}</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                @if ($gateway->id > 69)
                    <div class="row">
                        <div class="col-xl-3">
                            <a href="javascript:void(0)" id="generate"
                                class="btn btn-primary mb-3">{{ __('Add Field option') }}</a>
                        </div>

                        <div class="addOptions">
                            @php
                                $fieldOptions = json_decode($gateway->field_options ?? '[]', true) ?? [];
                            @endphp
                            @foreach ($fieldOptions as $key => $value)
                                <div class="mb-4">
                                    <div class="option-remove-row row">
                                        <div class="col-xl-4 col-lg-6 col-md-6 col-sm-6 col-12">
                                            <div class="site-input-groups">
                                                <input name="field_options[{{ $key }}][name]"
                                                    class="box-input form-control" type="text"
                                                    value="{{ $value['name'] }}" required placeholder="Field Name">
                                            </div>
                                        </div>

                                        <div class="col-xl-4 col-lg-6 col-md-6 col-sm-6 col-12">
                                            <div class="site-input-groups">
                                                <select name="field_options[{{ $key }}][type]"
                                                    class="form-select form-select-lg mb-3">
                                                    <option value="text"
                                                        @if ($value['type'] == 'text') selected @endif>Input
                                                        Text
                                                    </option>
                                                    <option value="textarea"
                                                        @if ($value['type'] == 'textarea') selected @endif>
                                                        Textarea
                                                    </option>
                                                    <option value="file"
                                                        @if ($value['type'] == 'file') selected @endif>File
                                                        upload
                                                    </option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-xl-3 col-lg-6 col-md-6 col-sm-6 col-12">
                                            <div class="site-input-groups mb-0">
                                                <select name="field_options[{{ $key }}][validation]"
                                                    class="form-select form-select-lg mb-1">
                                                    <option value="required"
                                                        @if ($value['validation'] == 'required') selected @endif>
                                                        Required
                                                    </option>
                                                    <option value="nullable"
                                                        @if ($value['validation'] == 'nullable') selected @endif>
                                                        Optional
                                                    </option>
                                                </select>
                                            </div>
                                        </div>

                                        <div class="col-xl-1 col-lg-6 col-md-6 col-sm-6 col-12">
                                            <button class="delete-option-row delete_desc btn btn-danger" type="button">
                                                <i class="fas fa-times"></i>
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    </div>
                    <div class="form-group">
                        <label><strong>{{ __('PAYMENT DETAILS') }}</strong></label>
                        <textarea name="gateway_key_four" cols="30" rows="10" class="form-control">{{ $gateway->gateway_key_four }}</textarea>
                    </div>
                @endif

                @if ($gateway->id == 1)
                    <div class="form-group">
                        <label><strong>{{ __('PAYPAL API LIVE CLIENT ID') }}</strong></label>
                        <input type="text" name="gateway_key_one" value="{{ $gateway->gateway_key_one }}"
                            class="form-control">
                    </div>

                    <div class="form-group">
                        <label><strong>{{ __('PAYPAL API LIVE CLIENT SECRET') }}</strong></label>
                        <input type="text" name="gateway_key_two" value="{{ $gateway->gateway_key_two }}"
                            class="form-control">
                    </div>
                @endif

                @if ($gateway->id == 2)
                    <div class="form-group">
                        <label><strong>{{ __('COINPAYMENT MERCHANT ID') }}</strong></label>

                        <input type="text" name="gateway_key_one" value="{{ $gateway->gateway_key_one }}"
                            class="form-control">
                    </div>

                    <div class="form-group">
                        <label><strong>{{ __('COINPAYMENT SECRET') }}</strong></label>
                        <input type="text" name="gateway_key_two" value="{{ $gateway->gateway_key_two }}"
                            class="form-control">
                    </div>
                @endif

                @if ($gateway->id == 3)
                    <div class="form-group">
                        <label><strong>{{ __('STRIPE SECRET') }}</strong></label>
                        <input type="text" name="gateway_key_one" value="{{ $gateway->gateway_key_one }}"
                            class="form-control">
                    </div>

                    <div class="form-group">
                        <label><strong>{{ __('STRIPE KEY') }}</strong></label>
                        <input type="text" name="gateway_key_two" value="{{ $gateway->gateway_key_two }}"
                            class="form-control">
                    </div>
                @endif

                @if ($gateway->id == 4)
                    <div class="form-group">
                        <label><strong>{{ __('PAYFAST MERCHANT ID') }}</strong></label>
                        <input type="text" name="gateway_key_one" value="{{ $gateway->gateway_key_one }}"
                            class="form-control">
                    </div>

                    <div class="form-group">
                        <label><strong>{{ __('PAYFAST MERCHANT KEY') }}</strong></label>
                        <input type="text" name="gateway_key_two" value="{{ $gateway->gateway_key_two }}"
                            class="form-control">
                    </div>
                @endif


                @if ($gateway->id == 5)
                    <div class="form-group">
                        <label><strong>{{ __('Callback URL') }}</strong></label>
                        <input type="text" value="{{ url('/') }}/paystack-payment/callback" class="form-control"
                            readonly>
                        <p class="text-success">
                            <small>{{ __('Copy this link & save on your paystack portal (API Keys & Webhooks)') }}</small>
                        </p>
                    </div>
                    <div class="form-group">
                        <label><strong>{{ __('PAYSTACK assets KEY') }}</strong></label>
                        <input type="text" name="gateway_key_one" value="{{ $gateway->gateway_key_one }}"
                            class="form-control">
                    </div>

                    <div class="form-group">
                        <label><strong>{{ __('PAYSTACK SECRET KEY') }}</strong></label>
                        <input type="text" name="gateway_key_two" value="{{ $gateway->gateway_key_two }}"
                            class="form-control">
                    </div>

                    <div class="form-group">
                        <label><strong>{{ __('MERCHANT EMAIL') }}</strong></label>
                        <input type="text" name="gateway_key_three" value="{{ $gateway->gateway_key_three }}"
                            class="form-control">
                    </div>
                @endif

                @if ($gateway->id == 6)
                    <div class="form-group">
                        <label><strong>{{ __('FLW assets KEY') }}</strong></label>
                        <input type="text" name="gateway_key_one" value="{{ $gateway->gateway_key_one }}"
                            class="form-control">
                    </div>

                    <div class="form-group">
                        <label><strong>{{ __('FLW SECRET KEY') }}</strong></label>
                        <input type="text" name="gateway_key_two" value="{{ $gateway->gateway_key_two }}"
                            class="form-control">
                    </div>

                    <div class="form-group">
                        <label><strong>{{ __('FLW SECRET HASH') }}</strong></label>
                        <input type="text" name="gateway_key_three" value="{{ $gateway->gateway_key_three }}"
                            class="form-control">
                    </div>
                @endif


                @if ($gateway->id == 7)
                    <div class="form-group">
                        <label><strong>{{ __('PAYTM MERCHANT ID') }}</strong></label>
                        <input type="text" name="gateway_key_one" value="{{ $gateway->gateway_key_one }}"
                            class="form-control">
                    </div>

                    <div class="form-group">
                        <label><strong>{{ __('PAYTM MERCHANT KEY') }}</strong></label>
                        <input type="text" name="gateway_key_two" value="{{ $gateway->gateway_key_two }}"
                            class="form-control">
                    </div>
                @endif

                @if ($gateway->id == 8)
                    <div class="form-group">
                        <label><strong>{{ __('Skrill EMAIL') }}</strong></label>
                        <input type="email" name="gateway_key_one" value="{{ $gateway->gateway_key_one }}"
                            class="form-control">
                    </div>
                @endif
                @if ($gateway->id == 9)
                    <div class="form-group">
                        <label><strong>{{ __('MERCHANT LOGIN ID') }}</strong></label>
                        <input type="text" name="gateway_key_one" value="{{ $gateway->gateway_key_one }}"
                            class="form-control">
                    </div>

                    <div class="form-group">
                        <label><strong>{{ __('MERCHANT TRANSACTION KEY') }}</strong></label>
                        <input type="text" name="gateway_key_two" value="{{ $gateway->gateway_key_two }}"
                            class="form-control">
                    </div>
                @endif
                @if ($gateway->id == 10)
                    <div class="form-group">
                        <label><strong>{{ __('API KEY') }}</strong></label>
                        <input type="text" name="gateway_key_one" value="{{ $gateway->gateway_key_one }}"
                            class="form-control">
                    </div>
                @endif
                @if ($gateway->id == 11)
                    <div class="form-group">
                        <label><strong>{{ __('API KEY') }}</strong></label>
                        <input type="text" name="gateway_key_one" value="{{ $gateway->gateway_key_one }}"
                            class="form-control">
                    </div>
                    <div class="form-group">
                        <label><strong>{{ __('AUTH TOKEN') }}</strong></label>
                        <input type="text" name="gateway_key_two" value="{{ $gateway->gateway_key_two }}"
                            class="form-control">
                    </div>
                    <div class="form-group">
                        <label><strong>{{ __('API URL') }}</strong></label>
                        <input type="text" name="gateway_key_three" value="{{ $gateway->gateway_key_three }}"
                            class="form-control">
                    </div>
                @endif
                @if ($gateway->id == 12)
                    <div class="form-group">
                        <label><strong>{{ __('assets KEY') }}</strong></label>
                        <input type="text" name="gateway_key_one" value="{{ $gateway->gateway_key_one }}"
                            class="form-control">
                    </div>
                    <div class="form-group">
                        <label><strong>{{ __('SECRET KEY') }}</strong></label>
                        <input type="text" name="gateway_key_two" value="{{ $gateway->gateway_key_two }}"
                            class="form-control">
                    </div>
                @endif
                @if ($gateway->id == 13)
                    <div class="form-group">
                        <label><strong>{{ __('API KEY') }}</strong></label>
                        <input type="text" name="gateway_key_one" value="{{ $gateway->gateway_key_one }}"
                            class="form-control">
                    </div>
                @endif
                @if ($gateway->id == 14)
                    <div class="form-group">
                        <label><strong>{{ __('API KEY') }}</strong></label>
                        <input type="text" name="gateway_key_one" value="{{ $gateway->gateway_key_one }}"
                            class="form-control">
                    </div>
                    <div class="form-group">
                        <label><strong>{{ __('SECRET KEY') }}</strong></label>
                        <input type="text" name="gateway_key_two" value="{{ $gateway->gateway_key_two }}"
                            class="form-control">
                    </div>
                @endif
                @if ($gateway->id == 15)
                    <div class="form-group">
                        <label><strong>{{ __('PUBLISHABLE KEY') }}</strong></label>
                        <input type="text" name="gateway_key_one" value="{{ $gateway->gateway_key_one }}"
                            class="form-control">
                    </div>
                    <div class="form-group">
                        <label><strong>{{ __('PRIVATE KEY') }}</strong></label>
                        <input type="text" name="gateway_key_two" value="{{ $gateway->gateway_key_two }}"
                            class="form-control">
                    </div>
                @endif


                @if ($gateway->id == 16)
                    <div class="form-group">
                        <label><strong>{{ __('Razor Key') }}</strong></label>
                        <input type="text" name="gateway_key_one" value="{{ $gateway->gateway_key_one }}"
                            class="form-control">
                    </div>
                    <div class="form-group">
                        <label><strong>{{ __('Razor Secret') }}</strong></label>
                        <input type="text" name="gateway_key_two" value="{{ $gateway->gateway_key_two }}"
                            class="form-control">
                    </div>
                @endif

                <div class="text-center mt-3">
                    <button type="submit" class="btn s7__btn-primary me-2">{{ __('Update') }}</button>
                </div>
        </div>
        </form>
    </div>
@endsection
@section('script')
    <script>
        (function($) {
            'use strict';

            let i = 0;

            try {
                const options = JSON.parse(@json($gateway->field_options ?? '[]'));
                i = Object.keys(options).length;
            } catch (e) {
                console.warn("Invalid JSON in field_options", e);
            }

            $("#generate").on('click', function() {
                ++i;
                const form = `<div class="mb-4">
              <div class="option-remove-row row">
                <div class="col-xl-4 col-lg-6 col-md-6 col-sm-6 col-12">
                  <div class="site-input-groups">
                    <input name="field_options[${i}][name]" class="box-input form-control" type="text" value="" required placeholder="Field Name">
                  </div>
                </div>
    
                <div class="col-xl-4 col-lg-6 col-md-6 col-sm-6 col-12">
                  <div class="site-input-groups">
                    <select name="field_options[${i}][type]" class="form-select mb-3">
                        <option value="text">Input Text</option>
                        <option value="textarea">Textarea</option>
                        <option value="file">File upload</option>
                    </select>
                  </div>
                </div>
                <div class="col-xl-3 col-lg-6 col-md-6 col-sm-6 col-12">
                  <div class="site-input-groups mb-0">
                    <select name="field_options[${i}][validation]" class="form-select mb-1">
                        <option value="required">Required</option>
                        <option value="nullable">Optional</option>
                    </select>
                  </div>
                </div>
    
                <div class="col-xl-1 col-lg-6 col-md-6 col-sm-6 col-12">
                  <button class="delete-option-row delete_desc btn btn-danger" type="button">
                    <i class="fas fa-times"></i>
                  </button>
                </div>
              </div>
            </div>`;

                $('.addOptions').append(form);
            });

            $(document).on('click', '.delete_desc', function() {
                $(this).closest('.option-remove-row').parent().remove();
            });

        })(jQuery);
    </script>
@endsection
