@extends('admin.layouts.master')
@section('title',__('About'))
@section('content')
    <div class="card">
        <div class="card-header">
            <h4>@lang('About')</h4>
        </div>
        <div class="card-body">
            <form action="{{route('general.store')}}" method="POST" enctype="multipart/form-data">
                @csrf
                <div class="row mb-3">
                    <div class="form-group col-md-6">
                        <label class="form-label">@lang('Right Side Image') <small>@lang('(PNG format is standard)')</small></label>
                        <input type="file" id="file-input" class="form-control" name="single_about_img">
                        <div class="row mt-2">
                            <div class="col-md-12">
                                <div id='img_contain'>
                                    <img id="image-preview" class="img-fluid" align='middle' src="{{asset('assets/images/about/about_right_img.png')}}" alt="your image" title=''/>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="form-group col-md-6">
                        <div class="row">
                            <div class="form-group">
                                <label class="form-label">@lang('Header Text')</label>
                                <input type="text" class="form-control" name="about_head" value="{{$general->about_head}}">
                            </div>
        
                            <div class="form-group">
                                <label class="form-label">@lang('Title Text')</label>
                                <input type="text" class="form-control" name="about_title" value="{{$general->about_title}}">
                            </div>
        
                            <div class="form-group">
                                <label class="form-label">@lang('Body Text')</label>
                                <textarea class="form-control" name="about_body" rows="8">{{$general->about_body}}</textarea>
                            </div>
                        </div>
                    </div>
                </div>

                
                <div class="row mb-2">
                    <div class="col-md-6">
                        <div class="card">
                            <div class="card-header">
                                <h3>@lang('Content One')</h3>
                            </div>
                            <div class="card-body">
                                <div class="row">
                                    <div class="form-group col-md-6">
                                        <label class="form-label">@lang('Background Image') <small>@lang('(PNG format is standard)')</small></label>
                                        <input type="file" id="file-input" class="form-control" name="single_about1_icon">
                                        <div class="row mt-2">
                                            <div class="col-md-12">
                                                <div id='img_contain'>
                                                    <img id="image-preview" class="img-fluid" align='middle' src="{{asset('assets/images/about/one.png')}}" alt="your image" title=''/>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label class="form-label">@lang('Content One Title')</label>
                                            <input type="text" class="form-control" name="single_about1_title" value="{{$general->single_about1_title}}">
                                        </div>

                                        <div class="form-group">
                                            <label class="form-label">@lang('Content One Description')</label>
                                            <textarea class="form-control" name="single_about1_description" id="" cols="30" rows="10">{{$general->single_about1_description}}</textarea>
                                        </div>
                                    </div>

                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="card">
                            <div class="card-header">
                                <h3>@lang('Content Two')</h3>
                            </div>
                            <div class="card-body">
                                <div class="row">
                                    <div class="form-group col-md-6">
                                        <label class="form-label">@lang('Front Image') <small>@lang('(PNG format is standard)')</small></label>
                                        <input type="file" id="file-input2" class="form-control" name="single_about2_icon">
                                        <div class="row mt-2">
                                            <div class="col-md-12">
                                                <div id='img_contain2'>
                                                    <img id="image-preview2" class="img-fluid" align='middle' src="{{asset('assets/images/about/two.png')}}" alt="your image" title=''/>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label class="form-label">@lang('Content Two Title')</label>
                                            <input type="text" class="form-control" name="single_about2_title" value="{{$general->single_about2_title}}">
                                        </div>

                                        <div class="form-group">
                                            <label class="form-label">@lang('Content Two Description')</label>
                                            <textarea class="form-control" name="single_about2_description" id="" cols="30" rows="10">{{$general->single_about2_description}}</textarea>
                                        </div>
                                    </div>

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="text-center">
                    <button type="submit" class="btn s7__btn-primary s7__bg-base mt-2">@lang('Update')</button>
                </div>
            </form>
        </div>
    </div>
@endsection
