@extends('admin.layouts.master')
@section('title',__('Ico Settings'))
@section('content')
    <div class="card">
        <div class="card-header">
            <h4>@lang('Ico')</h4>
        </div>
        <div class="card-body">
            <form class="form-cont" action="{{route('general.store')}}" method="POST">
                @csrf
                <div class="row mb-2">
                    <div class="form-group col-md-4">
                        <label class="form-label">@lang('Crypto Currency (Ex: BTC, BTC, ADA)')</label>
                        <input type="text" class="form-control" name="cp_currency" value="{{$general->cp_currency}}">
                    </div>
                    <div class="form-group col-md-4">
                        <label class="form-label">@lang('Crypto Currency Rate')</label>
                        <input type="number" step="any" class="form-control" name="cp_currency_rt" value="{{$general->cp_currency_rt}}">
                    </div>
                    <div class="form-group col-md-4">
                        <label class="form-label">@lang('Status')</label>
                        <div class="onOff-radio-field">
                            <div class="onOff-radio-option">
                                <input type="radio" name="ico" id="ico" value="1" <?php if ($general->ico == 1):echo 'checked'; endif ?>>
                                <label class="bgc-success" for="ico">ON</label>
                            </div>
    
                            <div class="onOff-radio-option">
                                <input type="radio" name="ico" id="ico1" value="0" <?php if ($general->ico == 0):echo 'checked'; endif ?>>
                                <label class="bgc-danger" for="ico1">OFF</label>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row mb-3">
                    <div class="form-group col-md-6">
                        <label class="form-label">@lang('Coin Fixed Charge (Balance Transfer)')</label>
                        <input type="number" step="any" class="form-control" name="bal_trans_coin_fixed_charge" value="{{$general->bal_trans_coin_fixed_charge}}">
                    </div>

                    <div class="form-group col-md-6">
                        <label class="form-label">@lang('Coin Percentage (%) Charge (Balance Transfer)')</label>
                        <input type="number" step="any" class="form-control" name="bal_trans_coin_percentage_charge" value="{{$general->bal_trans_coin_percentage_charge}}">
                    </div>
                </div>
                
                <div class="text-center">
                    <button type="submit" class="btn s7__btn-primary s7__bg-base mt-2">{{__('Update')}}</button>
                </div>
            </form>

        </div>
    </div>


@endsection
