@extends('admin.layouts.master')
@section('title', __('Identity Form Edit'))
@section('content')

    <div class="card">
        <div class="card-header">
            <h1 class="modal-title fs-5" id="myModalLabel"><i class="fa fa-plus-circle"></i>
                {{ trans('Update Identity Form') }}</h1>
        </div>
        <div class="card-body">
            <form action="" method="post">
                @csrf
                @method('PUT')
                <input type="hidden" name="name" value="{{$form->name}}">
                <div class="row ">
                    <div class="col-md-6 form-group ">
                        <label for="inputName" class="control-label d-block"><strong>{{ trans('Status') }}
                                :</strong></label>
                        <select class="form-select  w-100 edit_status" data-live-search="true" name="status"
                            required="">
                            <option disabled>@lang('Select Status')</option>
                            <option value="1" {{$form->status == 1 ? 'selected' : ''}}>{{ trans('Active') }}</option>
                            <option value="0" {{$form->status == 0 ? 'selected' : ''}}>{{ trans('Deactive') }}</option>
                        </select>
                        <br>
                        @error('status')
                            <span class="text-danger">{{ trans($message) }}</span>
                        @enderror
                    </div>

                    <div class="col-md-6 form-group">
                        <br>
                        <a href="javascript:void(0)" class="btn btn-success btn-sm float-right generate"><i
                                class="fa fa-plus-circle"></i> {{ trans('Add Field') }}</a>

                    </div>
                </div>

                <div class="row addedField mt-3">

                    @if ($form->services_form)


                        @foreach ($form->services_form as $item)
                            <div class="col-md-12 mb-3">

                                <div class="card border-primary">

                                    <div class="card-header  bg-primary p-2 d-flex justify-content-between">
                                        <h5 class="card-title text-white font-weight-bold">{{ trans('Field information') }}
                                            </h3>
                                            <button class="btn  btn-danger btn-sm delete_desc" type="button">
                                                <i class="fa fa-times"></i>
                                            </button>
                                    </div>

                                    <div class="card-body">
                                        <div class="row">
                                            <div class="col-md-4 form-group">
                                                <label>{{ trans('Field Name') }}</label>
                                                <input name="field_name[]" class="form-control"
                                                    value="{{$item->field_level}}" type="text" required
                                                    placeholder="{{ trans('Field Name') }}">
                                            </div>

                                            <div class="col-md-2 form-group">
                                                <label>{{ trans('Form Type') }}</label>
                                                <select name="type[]" class="form-select">
                                                    <option value="text" {{$item->type === 'text' ?
                                                        'selected="selected"' : '' }}>{{ trans('Input Text') }}</option>
                                                    <option value="textarea" {{$item->type === 'textarea' ?
                                                        'selected="selected"' : '' }}>{{ trans('Textarea') }}</option>
                                                    <option value="file" {{$item->type === 'file' ?
                                                        'selected="selected"' : '' }}>{{ trans('File upload') }}</option>
                                                </select>
                                            </div>

                                            <div class="col-md-2 form-group">
                                                <label>{{ trans('Field Length') }}</label>
                                                <input name="field_length[]" class="form-control " type="number"
                                                    min="2" required value="{{$item->field_length}}"
                                                    placeholder="{{ trans('Length') }}">
                                            </div>

                                            <div class="col-md-2 form-group">
                                                <label>{{ trans('Field Length Type') }}</label>
                                                <select name="length_type[]" class="form-select">
                                                    <option value="max" {{$item->length_type === 'max' ?
                                                        'selected="selected"' : '' }}>{{ trans('Maximum Length') }}
                                                    </option>
                                                    <option value="digits" {{$item->length_type === 'digits' ?
                                                        'selected="selected"' : '' }}>{{ trans('Fixed Length') }}</option>
                                                </select>
                                            </div>



                                            <div class="col-md-2 form-group">
                                                <label>{{ trans('Form Validation') }}</label>
                                                <select name="validation[]" class="form-select">
                                                    <option value="required" {{$item->validation === 'required' ?
                                                        'selected="selected"' : '' }}>{{ trans('Required') }}</option>
                                                    <option value="nullable" {{$item->validation === 'nullable' ?
                                                        'selected="selected"' : '' }}>{{ trans('Optional') }}</option>
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        @endforeach


                    @endif


                </div>
                <button type="submit" class="btn s7__btn-primary s7__bg-base">{{ trans('Update') }}</button>

            </form>
        </div>
    </div>




@endsection


@section('script')
    <script>
        "use strict";
        $(document).ready(function() {

            $(".generate").on('click', function() {
                var form = `<div class="col-md-12 mb-3">
                                 <div class="card border-primary">
                                        <div class="card-header  bg-primary p-2 d-flex justify-content-between">
                                            <h5 class="card-title text-white font-weight-bold">{{ trans('Field information') }}</h3>
                                            <button  class="btn  btn-danger btn-sm delete_desc" type="button">
                                                <i class="fa fa-times"></i>
                                            </button>
                                        </div>
                                        <div class="card-body">
                                            <div class="row">
                                                <div class="col-md-4 form-group">
                                                    <label>{{ trans('Field Name') }}</label>
                                                    <input name="field_name[]" class="form-control " type="text" value="" required
                                                           placeholder="{{ trans('Field Name') }}">
                                                </div>

                                                <div class="col-md-2 form-group">
                                                    <label>{{ trans('Form Type') }}</label>
                                                    <select name="type[]" class="form-select">
                                                        <option value="text">{{ trans('Input Text') }}</option>
                                                        <option value="textarea">{{ trans('Textarea') }}</option>
                                                        <option value="file">{{ trans('File upload') }}</option>
                                                    </select>
                                                </div>

                                                <div class="col-md-2 form-group">
                                                    <label>{{ trans('Field Length') }}</label>
                                                    <input name="field_length[]" class="form-control " type="number" min="2" value="" required
                                                           placeholder="{{ trans('Length') }}">
                                                </div>

                                                <div class="col-md-2 form-group">
                                                    <label>{{ trans('Field Length Type') }}</label>
                                                    <select name="length_type[]" class="form-select">
                                                        <option value="max">{{ trans('Maximum Length') }}</option>
                                                        <option value="digits">{{ trans('Fixed Length') }}</option>
                                                    </select>
                                                </div>



                                                <div class="col-md-2 form-group">
                                                    <label>{{ trans('Form Validation') }}</label>
                                                    <select name="validation[]" class="form-select">
                                                        <option value="required">{{ trans('Required') }}</option>
                                                        <option value="nullable">{{ trans('Optional') }}</option>
                                                    </select>
                                                </div>
                                            </div>
                                        </div>

                                    </div>
                            </div> `;

                $('.addedField').append(form)
            });

            $('select').select2({
                width: '100%'
            });

            $(document).on('click', '.delete_desc', function() {
                $(this).closest('.card').parent().remove();
            });
        });
    </script>
@endsection
