@extends('admin.layouts.master')
@section('title', __('Ranking'))
@section('content')

    <div class="card">
        <div class="card-header">
            <h4>@lang('Ranking List') <button class="btn btn-success btn-sm float-end" data-bs-toggle="modal"
                    data-bs-target="#addRanking"><i class="fa fa-plus"></i> @lang('Add New Ranking')</a> </h4>
        </div>

        <div class="card-body p-0">
            <table class="table s7__table">
                <thead>
                    <tr>
                        <th>@lang('Name')</th>
                        <th>@lang('Minimum Deposit')</th>
                        <th>@lang('Minimum Invest')</th>
                        <th>@lang('Minimum Referral')</th>
                        <th>@lang('Status')</th>
                        <th>@lang('Action')</th>
                    </tr>
                </thead>
                <tbody>

                    @forelse ($rankings as $ranking)
                        <tr>
                            <td>
                                <img width="50" src="{{ asset('assets/images/ranking/' . $ranking->image) }}">
                                {{ $ranking->title }}
                            </td>
                            <td>
                                {{ $ranking->minimum_deposit }}
                            </td>
                            <td>
                                {{ $ranking->minimum_invest }}
                            </td>
                            <td>
                                {{ $ranking->minimum_referral }}
                            </td>
                            <td>
                                @if ($ranking->status)
                                    <span class="s7__badge s7__badge-primary">{{ __('Active') }}</span>
                                @else
                                    <span class="s7__badge s7__badge-primary">{{ __('Deactive') }}</span>
                                @endif
                            </td>
                            <td>
                                <button class="btn btn-primary btn-sm edit" data-bs-toggle="modal"
                                    data-bs-target="#editModal" data-href="{{ route('ranking.update', $ranking->id) }}"
                                    data-ranking="{{ $ranking }}">{{ __('Edit') }}</button>
                            </td>
                        </tr>
                    @empty
                        <tr class="text-center" colspan="100%">
                            <td>{{ __('No Data Found') }}</td>
                        </tr>
                    @endforelse

                </tbody>
            </table>
        </div>
    </div>


    <!-- Modal -->
    <div class="modal fade" id="addRanking" tabindex="-1" role="dialog" aria-labelledby="modalTitleId" aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
            <form action="{{ route('ranking.store') }}" method="post" enctype="multipart/form-data">
                @csrf
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="modalTitleId">
                            {{ __('Add Ranking') }}
                        </h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-md-6">
                                <label for="">{{ __('Ranking Name') }}</label>
                                <input type="text" name="title" class="form-control">
                            </div>
                            <div class="col-md-6">
                                <label for="">{{ __('Ranking Image') }}</label>
                                <input type="file" name="image" class="form-control">
                            </div>
                            <div class="col-md-6">
                                <label for="">{{ __('Minimum Deposit') }}</label>
                                <input type="text" name="minimum_deposit" class="form-control">
                            </div>

                            <div class="col-md-6">
                                <label for="">{{ __('Minimum Invest') }}</label>
                                <input type="text" name="minimum_invest" class="form-control">
                            </div>

                            <div class="col-md-6">
                                <label for="">{{ __('Minimum Referral user') }}</label>
                                <input type="text" name="minimum_referral" class="form-control">
                            </div>

                            <div class="col-md-6">
                                <label for="">{{ __('Bonus') }}</label>
                                <input type="text" name="bonus" class="form-control">
                            </div>


                            <div class="col-md-6">
                                <label for="">{{ __('Status') }}</label>
                                <select name="status" id="" class="form-control">
                                    <option value="1">{{ __('Active') }}</option>
                                    <option value="0">{{ __('Deactive') }}</option>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                            {{ __('Close') }}
                        </button>
                        <button type="submit" class="btn btn-primary">{{ __('Create') }}</button>
                    </div>
                </div>
            </form>
        </div>
    </div>


    <!-- Modal -->
    <div class="modal fade" id="editModal" tabindex="-1" role="dialog" aria-labelledby="modalTitleId" aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
            <form action="" method="post" enctype="multipart/form-data">
                @csrf
                @method('PUT')
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="modalTitleId">
                            {{ __('Edit Ranking') }}
                        </h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-md-6">
                                <label for="">{{ __('Ranking Name') }}</label>
                                <input type="text" name="title" class="form-control">
                            </div>
                            <div class="col-md-6">
                                <label for="">{{ __('Ranking Image') }}</label>
                                <input type="file" name="image" class="form-control">
                            </div>
                            <div class="col-md-6">
                                <label for="">{{ __('Minimum Deposit') }}</label>
                                <input type="text" name="minimum_deposit" class="form-control">
                            </div>

                            <div class="col-md-6">
                                <label for="">{{ __('Minimum Invest') }}</label>
                                <input type="text" name="minimum_invest" class="form-control">
                            </div>

                            <div class="col-md-6">
                                <label for="">{{ __('Minimum Referral user') }}</label>
                                <input type="text" name="minimum_referral" class="form-control">
                            </div>

                            <div class="col-md-6">
                                <label for="">{{ __('Bonus') }}</label>
                                <input type="text" name="bonus" class="form-control">
                            </div>


                            <div class="col-md-6">
                                <label for="">{{ __('Status') }}</label>
                                <select name="status" id="" class="form-control">
                                    <option value="1">{{ __('Active') }}</option>
                                    <option value="0">{{ __('Deactive') }}</option>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                            {{ __('Close') }}
                        </button>
                        <button type="submit" class="btn btn-primary">{{ __('update') }}</button>
                    </div>
                </div>
            </form>
        </div>
    </div>

@endsection

@section('script')
    <script>
        $(function() {
            $('.edit').on('click', function() {
                let route = $(this).data('href')
                let ranking = $(this).data('ranking')

                let modal = $('#editModal')

                modal.find('form').attr('action', route);

                modal.find('input[name=title]').val(ranking.title)
                modal.find('input[name=minimum_deposit]').val(ranking.minimum_deposit)
                modal.find('input[name=minimum_invest]').val(ranking.minimum_invest)
                modal.find('input[name=minimum_referral]').val(ranking.minimum_referral)
                modal.find('input[name=bonus]').val(ranking.bonus)
                modal.find('select[name=status]').val(ranking.status)

            })
        })
    </script>
@endsection
