@extends('admin.layouts.master')
@section('title',__('Slider'))
@section('content')
    <div class="card">
        <div class="card-header">
            <h4>@lang('Slider List')<a href="#addModal" data-bs-toggle="modal" class="btn btn-success btn-sm float-end"><i class="fa fa-plus"></i> @lang('Add New')</a> </h4>
        </div>

        <div class="card-body p-0">
            <table class="table s7__table">
                <thead>
                <tr>
                    <th>@lang('Image')</th>
                    <th>@lang('Header')</th>
                    <th>@lang('Title')</th>
                    <th>@lang('Action')</th>
                </tr>
                </thead>
                <tbody>
                @foreach($sliders as $data)
                <tr>
                    <td>
                        <img width="50" align='middle' src="{{asset('assets/images/slider/'.$data->image)}}" alt="your image"/>
                    </td>
                    <td>{{$data->header}}</td>
                    <td>{{$data->title}}</td>
                    <td>
                        <a href="#editModal" data-bs-toggle="modal" data-route="{{route('slider-area.update',$data->id)}}" data-image="{{asset('assets/images/slider/'.$data->image)}}" data-title="{{$data->title}}" data-header="{{$data->header}}" data-description="{{$data->description}}" class="btn s7__btn-primary s7__bg-base btn-sm editBtn">@lang('Edit')</a>
                        <a href="#delModal" data-route="{{route('slider-area.delete', $data->id)}}" data-bs-toggle="modal" class="btn btn-danger btn-sm editButton">@lang('Delete')</a>
                    </td>
                </tr>
                @endforeach
                </tbody>
            </table>

        </div>
    </div>

    <div id="delModal" class="modal fade" tabindex="-1" data-backdrop="static" data-keyboard="false">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">@lang('Confirm Delete')</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <form id="confirmDel" role="form" action="" method="post">
                    @csrf
                    @method('delete')
                    <div class="modal-body">
                        <h2 class="text-danger">@lang('Are you sure?')</h2>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">@lang('Close')</button>
                        <button type="submit" class="btn btn-danger">@lang('Delete')</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <div id="addModal" class="modal fade" tabindex="-1" data-backdrop="static" data-keyboard="false">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">@lang('Add Slider')</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <form  role="form" action="{{route('slider-area.store')}}" method="post" enctype="multipart/form-data">
                    @csrf
                    <div class="modal-body">
                       <div class="form-row">
                           <div class="form-group col-md-12 mb-2">
                               <label >@lang('Image') <small>@lang('(PNG format is standard)')</small></label>
                               <input type="file" id="file-input" class="form-control" name="image" required>
                               <div class="row mt-2">
                                   <div class="col-md-12">
                                       <div id='img_contain'>
                                           <img id="image-preview" class="img-fluid" align='middle' src="{{asset('assets/images/no-image.png')}}" alt="your image" title=''/>
                                       </div>
                                   </div>
                               </div>
                           </div>
                           <div class="form-group col-md-12 mb-2">
                                <label class="form-label">@lang('Header')</label>
                                <input type="text" class="form-control" name="header" required>
                            </div>
                           <div class="form-group col-md-12 mb-2">
                                <label class="form-label">@lang('title')</label>
                                <input type="text" class="form-control" name="title" required>
                            </div>
                            <div class="form-group col-md-12">
                                <label class="form-label">@lang('Body Text')</label>
                                <input type="text" class="form-control" name="description" required>
                            </div>
                       </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">@lang('Close')</button>
                        <button type="submit" class="btn btn-success">@lang('Submit')</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <div id="editModal" class="modal fade" tabindex="-1" data-backdrop="static" data-keyboard="false">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">@lang('Edit Sliders')</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <form id="editSlider" role="form" action="" method="post" enctype="multipart/form-data">
                    @csrf
                    @method('put')
                    <div class="modal-body">
                        <div class="form-row">
                            <div class="form-group col-md-12 mb-2">
                                <label >@lang('Image') <small>@lang('(PNG format is standard)')</small></label>
                                <input type="file" id="file-input2" class="form-control" name="image">
                                <div class="row mt-2">
                                    <div class="col-md-12">
                                        <div id='img_contain2'>
                                            <img id="image-preview2" class="img-fluid" align='middle' src="" alt="your image" title=''/>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="form-group col-md-12 mb-2">
                                <label class="form-label">@lang('Header')</label>
                                <input type="text" id="header_text" class="form-control" name="header" required>
                            </div>
                            <div class="form-group col-md-12 mb-2">
                                <label class="form-label">@lang('Title')</label>
                                <input type="text" id="header_title" class="form-control" name="title" required>
                            </div>
                            <div class="form-group col-md-12">
                                <label class="form-label">@lang('Body')</label>
                                <input type="text" id="header_body" class="form-control" name="description" required>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">@lang('Close')</button>
                        <button type="submit" class="btn btn-success">@lang('Submit')</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection
@section('script')
    <script>
    (function($) {
        "use strict";
        $(document).ready(function () {
            $('.editBtn').on('click',function () {
                $('#editSlider').attr('action',$(this).data('route'));
                $('#image-preview2').attr('src',$(this).data('image'));
                $('#header_text').val($(this).data('header'));
                $('#header_title').val($(this).data('title'));
                $('#header_body').val($(this).data('description'));
            });
        });
	})(jQuery);
    </script>
@endsection
