@extends('admin.layouts.master')
@section('title',__($page_title))
@section('content')
<div class="card">
    <div class="card-body">
        <h4 class="card-title text-end"><a href="{{route('withdraw-method.index')}}" class="btn btn-sm s7__btn-dark @if(Request::routeIs('withdraw-method.index')) active @endif">
            <i class="las la-arrow-left"></i> {{__('Go Back')}}
            </a>
        </h4>
        <form action="{{ route('withdraw-method.store') }}" method="POST" class="forms-sample" enctype="multipart/form-data">
            @csrf
            <div class="row pb-4">
                <div class="col-md-4">
                    <div class="form-group">
                        <label><strong>{{__('Image')}} <small>{{__('(PNG format is standard)')}}</small></strong></label>
                        <input type="file" name="image" id="file-input" class="form-control" required>
                        <div class="row mt-2">
                            <div class="col-md-12">
                                <div id='img_contain'>
                                    <img id="image-preview" class="img-fluid" src="{{asset('assets/images/no-image.png')}}" alt="your image"/>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-8">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="form-label">@lang('Payment Method Name')</label>
                                <input class="form-control text-capitalize" placeholder="@lang('Method Name')" type="text" required name="name">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="form-label">@lang('Rate for 1 Method Currency')</label>
                                <div class="input-group">
                                    <input class="form-control text-capitalize" placeholder="@lang('Rate')" type="text" required name="rate">
                                    <span class="input-group-text">@lang('Currency')</span>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="form-label">@lang('Minimum Amount For Withdraw')</label>
                                <div class="input-group">
                                    <input class="form-control text-capitalize" placeholder="@lang('Minimum Amount')" type="number" required name="min_amo">
                                    <span class="input-group-text">{{$general->currency}}</span>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="form-label">@lang('Maximum Amount For Withdraw')</label>
                                <div class="input-group">
                                    <input class="form-control text-capitalize" placeholder="@lang('Maximum Amount')" type="number" required name="max_amo">
                                    <span class="input-group-text">{{$general->currency}}</span>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="form-label">@lang('Fixed Charge For With Draw')</label>
                                <div class="input-group">
                                    <input class="form-control text-capitalize" placeholder="@lang('Charge')" type="text" required name="chargefx">
                                    <span class="input-group-text">{{$general->currency}}</span>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="form-label">@lang('Charge Percentage')</label>
                                <div class="input-group">
                                    <input class="form-control text-capitalize" placeholder="@lang('Charge Percentage')" type="text" required name="chargepc">
                                    <span class="input-group-text">%</span>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="form-label">@lang('Method Currency')</label>
                                <input class="form-control text-capitalize" placeholder="@lang('Currency')" type="text" required name="currency">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="form-label">@lang('Payback Days')</label>
                                <div class="input-group">
                                    <input class="form-control text-capitalize" placeholder="@lang('Day')" type="text" required name="processing_day">
                                    <span class="input-group-text">@lang('Days')</span>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>
                
            </div>

            <div class="row">
                <div class="col-xl-3">
                    <a href="javascript:void(0)" id="generate"
                       class="btn btn-primary mb-3">{{ __('Add Field option') }}</a>
                </div>
                <div class="addOptions">
                </div>
            </div>

            <div class="text-center mt-3">
                <button type="submit" class="btn s7__btn-primary me-2">{{__('Submit')}}</button>
            </div>
        </form>
    </div>
</div>

@endsection
@section('script')
<script>
    (function ($) {
        var i = 0;
        "use strict";

        $("#generate").on('click', function () {
            ++i;
            var form = `<div class="mb-4">
              <div class="option-remove-row row">
                <div class="col-xl-4 col-lg-6 col-md-6 col-sm-6 col-12">
                  <div class="site-input-groups">
                    <input name="field_options[` + i + `][name]" class="box-input form-control" type="text" value="" required placeholder="Field Name">
                  </div>
                </div>

                <div class="col-xl-4 col-lg-6 col-md-6 col-sm-6 col-12">
                  <div class="site-input-groups">
                    <select name="field_options[` + i + `][type]" class="form-select mb-3">
                        <option value="text">Input Text</option>
                        <option value="textarea">Textarea</option>
                        <option value="file">File upload</option>
                    </select>
                  </div>
                </div>
                <div class="col-xl-3 col-lg-6 col-md-6 col-sm-6 col-12">
                  <div class="site-input-groups mb-0">
                    <select name="field_options[` + i + `][validation]" class="form-select mb-1">
                        <option value="required">Required</option>
                        <option value="nullable">Optional</option>
                    </select>
                  </div>
                </div>

                <div class="col-xl-1 col-lg-6 col-md-6 col-sm-6 col-12">
                  <button class="delete-option-row delete_desc  btn btn-danger" type="button">
                    <i class="fas fa-times"></i>
                  </button>
                </div>
                </div>
              </div>`;
            $('.addOptions').append(form)
        });

        $(document).on('click', '.delete_desc', function () {
            $(this).closest('.option-remove-row').parent().remove();
        });


    })(jQuery)
</script>
@endsection