@extends('admin.layouts.master')
@section('title', __($page_title))
@section('content')
    <div class="card">
        <div class="card-body">
            <form action="{{ route('withdraw-method.update', $withdraw->id) }}" method="POST" class="forms-sample"
                enctype="multipart/form-data">
                @csrf
                @method('PATCH')
                <div class="row">
                    <div class="col-md-4">
                        <input class="form-control" value="{{ $withdraw->id }}" type="hidden" name="id">
                        <div class="form-group">
                            <label><strong>{{ __('Image') }}
                                    <small>{{ __('(PNG format is standard)') }}</small></strong></label>
                            <input type="file" name="image" id="file-input" class="form-control">
                            <div class="row mt-2">
                                <div class="col-md-12">
                                    <div id='img_contain'>
                                        <img id="image-preview" class="img-fluid"
                                            src="{{ asset('assets/images/withdraw_methods/' . $withdraw->image) }}"
                                            alt="your image" />
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-8">
                        <div class="row mb-4">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="form-label">@lang('Payment Method Name')</label>
                                        <input type="text" name="name" class="form-control"
                                            value="{{ old('name', $withdraw->name) }}">
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="form-label">@lang('Rate for 1 Method Currency')</label>
                                        <div class="input-group">
                                            <input type="text" name="rate" class="form-control"
                                                value="{{ old('rate', $withdraw->rate) }}">
                                            <span class="input-group-text">@lang('Currency')</span>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="form-label">@lang('Minimum Amount For Withdraw')</label>
                                        <div class="input-group">
                                            <input type="text" name="min_amo" class="form-control"
                                                value="{{ old('min_amo', $withdraw->min_amo) }}">
                                            <span class="input-group-text">{{ $withdraw->currency }}</span>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="form-label">@lang('Maximum Amount For Withdraw')</label>
                                        <div class="input-group">
                                            <input type="text" name="max_amo" class="form-control"
                                                value="{{ old('max_amo', $withdraw->max_amo) }}">
                                            <span class="input-group-text">{{ $withdraw->currency }}</span>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="form-label">@lang('Fixed Charge For With Draw')</label>
                                        <div class="input-group">
                                            <input type="text" name="chargefx" class="form-control"
                                                value="{{ old('chargefx', $withdraw->chargefx) }}">
                                            <span class="input-group-text">{{ $withdraw->currency }}</span>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="form-label">@lang('Charge Percentage')</label>
                                        <div class="input-group">
                                            <input type="text" name="chargepc" class="form-control"
                                                value="{{ old('chargepc', $withdraw->chargepc) }}">
                                            <span class="input-group-text">%</span>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="form-label">@lang('Method Currency')</label>
                                        <input type="text" name="currency" class="form-control"
                                            value="{{ old('currency', $withdraw->currency) }}">
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="form-label">@lang('Payback Days')</label>
                                        <div class="input-group">
                                            <input type="text" name="processing_day" class="form-control"
                                                value="{{ old('processing_day', $withdraw->processing_day) }}">
                                            <span class="input-group-text">@lang('Days')</span>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="form-label">@lang('Status')</label>
                                        <select class="form-select" name="status">
                                            <option @if ($withdraw->status == 1) selected @else @endif value="1">
                                                @lang('Active')</option>
                                            <option @if ($withdraw->status == 0) selected @else @endif value="0">
                                                @lang('Inactive')</option>
                                        </select>
                                    </div>
                                </div>
                            </div>


                        </div>
                        <div class="row">
                            <div class="col-xl-6">
                                <a href="javascript:void(0)" id="generate"
                                    class="btn btn-primary mb-3">{{ __('Add Field option') }}</a>
                            </div>

                            <div class="addOptions">
                                @if($withdraw->field_options)
                                @foreach (json_decode($withdraw->field_options, true) as $key => $value)
                                    <div class="mb-4">
                                        <div class="option-remove-row row">
                                            <div class="col-xl-4 col-lg-6 col-md-6 col-sm-6 col-12">
                                                <div class="site-input-groups">
                                                    <input name="field_options[{{ $key }}][name]"
                                                        class="box-input form-control" type="text"
                                                        value="{{ $value['name'] }}" required placeholder="Field Name">
                                                </div>
                                            </div>

                                            <div class="col-xl-4 col-lg-6 col-md-6 col-sm-6 col-12">
                                                <div class="site-input-groups">
                                                    <select name="field_options[{{ $key }}][type]"
                                                        class="form-select form-select-lg mb-3">
                                                        <option value="text"
                                                            @if ($value['type'] == 'text') selected @endif>Input
                                                            Text
                                                        </option>
                                                        <option value="textarea"
                                                            @if ($value['type'] == 'textarea') selected @endif>
                                                            Textarea
                                                        </option>
                                                        <option value="file"
                                                            @if ($value['type'] == 'file') selected @endif>File
                                                            upload
                                                        </option>
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-xl-3 col-lg-6 col-md-6 col-sm-6 col-12">
                                                <div class="site-input-groups mb-0">
                                                    <select name="field_options[{{ $key }}][validation]"
                                                        class="form-select form-select-lg mb-1">
                                                        <option value="required"
                                                            @if ($value['validation'] == 'required') selected @endif>
                                                            Required
                                                        </option>
                                                        <option value="nullable"
                                                            @if ($value['validation'] == 'nullable') selected @endif>
                                                            Optional
                                                        </option>
                                                    </select>
                                                </div>
                                            </div>

                                            <div class="col-xl-1 col-lg-6 col-md-6 col-sm-6 col-12">
                                                <button class="delete-option-row delete_desc btn btn-danger"
                                                    type="button">
                                                    <i class="fas fa-times"></i>
                                                </button>
                                            </div>
                                        </div>
                                    </div>
                                @endforeach
                                @endif
                            </div>
                        </div>
                    </div>
                </div>


                <div class="text-center mt-3">
                    <button type="submit" class="btn s7__btn-primary me-2">{{ __('Update') }}</button>
                </div>
            </form>
        </div>
    @endsection
    @section('script')
    <script>
        $(document).ready(function () {
            'use strict';
    
            // Initialize a counter to keep track of the field options
            let counter = $(".option-remove-row").length;
    
            // Event listener for generating new fields
            $("#generate").on("click", function () {
                counter++; // Increment the counter for unique field keys
                let form = `
                <div class="mb-4">
                    <div class="option-remove-row row">
                        <div class="col-xl-4 col-lg-6 col-md-6 col-sm-6 col-12">
                            <div class="site-input-groups">
                                <input name="field_options[` + counter + `][name]" class="box-input form-control" type="text" required placeholder="Field Name">
                            </div>
                        </div>
                        <div class="col-xl-4 col-lg-6 col-md-6 col-sm-6 col-12">
                            <div class="site-input-groups">
                                <select name="field_options[` + counter + `][type]" class="form-select mb-3">
                                    <option value="text">Input Text</option>
                                    <option value="textarea">Textarea</option>
                                    <option value="file">File Upload</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-xl-3 col-lg-6 col-md-6 col-sm-6 col-12">
                            <div class="site-input-groups mb-0">
                                <select name="field_options[` + counter + `][validation]" class="form-select mb-1">
                                    <option value="required">Required</option>
                                    <option value="nullable">Optional</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-xl-1 col-lg-6 col-md-6 col-sm-6 col-12">
                            <button class="delete-option-row btn btn-danger" type="button">
                                <i class="fas fa-times"></i>
                            </button>
                        </div>
                    </div>
                </div>`;
                $(".addOptions").append(form); // Append the new field set
            });
    
            // Event listener for removing a field row
            $(document).on("click", ".delete-option-row", function () {
                $(this).closest(".option-remove-row").parent().remove();
            });
        });
    </script>
    @endsection
