@extends('admin.layouts.master')
@section('title',__($page_title))
@section('content')
    <div class="card">
        <div class="card-header">
            <h4 class="card-title text-end"><a href="{{route('withdraw-method.create')}}" type="button" class="btn s7__btn-primary btn-sm">
                <i class="las la-plus"></i>
            {{__('Add New')}}
            </a> </h4>
        </div>

        <div class="card-body">
            <table class="table s7__table">
                <thead>
                <tr>
                    <th>@lang('Method Name')</th>
                    <th>@lang('Method Logo')</th>
                    <th>@lang('Min Amount')</th>
                    <th>@lang('Max Amount')</th>
                    <th>@lang('Fix Charge')</th>
                    <th>@lang('Percent of Charge')</th>
                    <th>@lang('Rate')</th>
                    <th>@lang('Processing Day')</th>
                    <th>@lang('Status')</th>
                    <th>@lang('Action')</th>
                </tr>
                </thead>
                <tbody>
                @foreach($withdraw as $key=> $data)
                    <tr id="row1">
                        <td> <b>{{$data->name}}</b></td>
                        <td> <img width="50" src="{{asset('assets/images/withdraw_methods/'.$data->image)}}"></td>
                        <td> {{$data->min_amo}} </td>
                        <td> {{$data->max_amo}} </td>
                        <td> {{$data->chargefx}} {{$general->currency}}</td>
                        <td> {{$data->chargepc}} %</td>
                        <td> {{$data->rate}}</td>
                        <td> {{$data->processing_day}} @lang('Days')</td>
                        <td>
                            @if($data->status == 1)
                                <span class="badge bg-success">@lang('Active')</span>
                            @else
                                <span class="badge bg-danger">@lang('Inactive')</span>
                            @endif
                        </td>
                        <td>
                            <a href="{{route('withdraw-method.edit', $data->id)}}" class="btn s7__btn-dark btn-sm" title="Edit"><i class="las la-edit"></i></a>
                        </td>
                    </tr>
                @endforeach
                </tbody>
            </table>
        </div>
    </div>

@endsection