@extends('installer.master')

@section('content')
    @php
        $isallOk = true;
    @endphp

    <div class="installer-area">
        <div class="container">
            <div class="installer-wrapper">
                <div class="installer-wrapper-header">
                    <h3 class="title">{{ __('wowtheme7 Installer') }}</h3>
                </div>
                <div class="installer-wrapper-body">
                    <div class="row gy-4">
                        <div class="col-md-8">
                            <div class="cover">
                                <h4>{{ __('Extensions') }}</h4>
                                <ul class="liststyle liststyle-two">

                                    @if (version_compare(PHP_VERSION, $minimumPhpVersion, '>='))
                                        <li>
                                            <i class="fa fa-check-circle text-success"></i> @lang('Minimum php version is: ' . $minimumPhpVersion)
                                        </li>
                                    @else
                                        @php
                                            $isallOk = false;
                                        @endphp
                                        <li>
                                            <i class="fa fa-times-circle text-danger"></i> @lang('Minimum php version is: ' . $minimumPhpVersion)
                                        </li>
                                    @endif
                                    @foreach ($requiredExtension as $extension)
                                        @if (in_array($extension, $extensionLoaded))
                                            <li><i class="fa fa-check-circle text-success"></i> {{ $extension . ' is enabled' }}</li>
                                        @else
                                            @php
                                                $isallOk = false;
                                            @endphp

                                            <li><i class="fa fa-times-circle text-danger"></i> {{ $extension . ' is not enabled' }}</li>
                                        @endif
                                    @endforeach

                                </ul>

                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="cover">
                                <h4>{{ __('Permissions') }}</h4>
                                <ul class="liststyle">
                                    @foreach ($permissionFolders as $permission)
                                        @php
                                            $permissionCode = substr(sprintf('%o', fileperms($permission)), -4);
                                        @endphp

                                        @if ($permissionCode >= '0775')
                                            <li><i class="fa fa-check-circle text-success"></i>
                                                {{ $permission . ' has right permission' }}</li>
                                        @else
                                            @php
                                                $isallOk = false;
                                            @endphp


                                            <li><i class="fa fa-times-circle text-danger"></i>
                                                {{ $permission . ' has not right permission' }}</li>
                                        @endif
                                    @endforeach

                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="installer-wrapper-footer">
                    <form action="" method="post">
                        @csrf

                        <div class="row gy-3">

                            {{-- <div class="col-md-6">
                                <label>{{ __('Purchase Code') }}</label>
                                <input type="text" name="purchase_code" class="form-control">
                                @error('purchase_code')
                                    <span class="text-danger">{{ $message }}</span>
                                @enderror
                            </div> --}}

                            <div class="col-md-6">
                                <label>{{ __('Database Name') }}</label>
                                <input type="text" name="db_name" class="form-control">
                                @error('db_name')
                                    <span class="text-danger">{{ $message }}</span>
                                @enderror
                            </div>

                            <div class="col-md-6">
                                <label>{{ __('Database Username') }}</label>
                                <input type="text" name="db_username" class="form-control">
                                @error('db_username')
                                    <span class="text-danger">{{ $message }}</span>
                                @enderror

                            </div>

                            <div class="col-md-6">
                                <label>{{ __('Database Password') }}</label>
                                <input type="text" name="db_password" class="form-control">
                            </div>

                            <div class="col-md-6">
                                <label>{{ __('Database Host') }}</label>
                                <input type="text" name="db_host" class="form-control">
                                @error('db_host')
                                    <span class="text-danger">{{ $message }}</span>
                                @enderror
                            </div>


                            <div class="col-md-6">
                                <label>{{ __('Database Port') }}</label>
                                <input type="text" name="db_port" class="form-control" value="3306">

                                @error('db_port')
                                    <span class="text-danger">{{ $message }}</span>
                                @enderror
                            </div>

                            @if ($isallOk)
                                <div class="col-md-12 mt-3">
                                    <button class="btn btn-primary w-100">{{ __('Submit') }}</button>
                                </div>
                            @else
                                <div class="col-md-12 mt-3">
                                    <p class="btn btn-danger w-100" disabled>{{ __('Not Compitable for Installation') }}</p>
                                </div>
                            @endif

                        </div>


                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('style')
    <style>
        .installer-area {
            padding: 50px 0;
        }

        .installer-wrapper {
            background-color: #fff; 
        }

        .installer-wrapper-header {
            padding: 15px 30px;
            background-color: #363636;
            text-align: center;
        }

        .installer-wrapper-header .title {
            color: #fff;
            margin-bottom: 0;
        }

        .installer-wrapper-body {
            padding: 30px;
        }

        .liststyle {
            list-style: none;
            padding-left: 0;
            margin: -4px;
        }

        .liststyle li {
            padding: 4px;
        }

        .liststyle-two {
            display: flex;
            flex-wrap: wrap;
        }
        
        .liststyle-two li {
            width: 50%;
        }

        .installer-wrapper-footer {
            padding: 30px;
            background-color: #e7edf4;
        }

        .form-control {
            border-color: #dfdfdf;
            background: #fff;
        }

        .form-control:focus {
            border-color: #1ED5A5;
            background: #fff;
        }

        .btn-primary,
        .btn-primary:hover,
        .btn-primary:focus,
        .btn-primary:active {
            background-color: #1ED5A5;
            border-color: #1ED5A5;
        }

        .text-success {
            color: #0dd477 !important;
        }
    </style>
@endpush
