@extends('installer.master')

@section('content')
    <div class="admin-create">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-5">
                    <form action="" method="post" class="admin-create-form">
                        <h4 class="text-center mb-4">{{ __('Create Admin') }}</h4>
                        @csrf
                        <div class="mb-4">
                            <label for="">@lang('Admin Username')</label>
                            <input type="text" name="username" autocomplete="off" class="form-control">
                        </div>

                        <div class="mb-4">
                            <label for="">@lang('Admin Email')</label>
                            <input type="email" name="email" autocomplete="off" class="form-control">
                        </div>

                        <div class="mb-4">
                            <label for="">@lang('Admin Password')</label>
                            <input type="password" name="password" autocomplete="off" class="form-control">
                        </div>

                        <div class="mb-4">
                            <label for="">@lang('Password Confirmation')</label>
                            <input type="password" name="password_confirmation" autocomplete="off" class="form-control">
                        </div>
                        <button class="btn btn-primary w-100">@lang('Migrate')</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection


@push('style')
<style>
    .admin-create {
        min-height: 100vh;
        padding: 50px 0;
        display: flex;
        flex-wrap: wrap;
        justify-content: center;
        align-items: center;
    }

    .form-control {
        border-color: #dfdfdf;
        background: #fff;
    }

    .form-control:focus {
        border-color: #1ED5A5;
        background: #fff;
    }

    .btn-primary,
    .btn-primary:hover,
    .btn-primary:focus,
    .btn-primary:active {
        background-color: #1ED5A5;
        border-color: #1ED5A5;
    }

    .admin-create-form {
        padding: 40px;
        background: #fff;
    }
</style>
@endpush