@extends('admin.layouts.master')
@section('title',__('Language Manager'))
@section('content')

    <div class="card">
        <div class="card-header">
            <h2><a href="#addModal" data-bs-toggle="modal" class="btn btn-success btn-sm float-end"><i class="fa fa-plus"></i> @lang('Add New')</a> </h2>
        </div>

        <div class="card-body p-0">
            <table class="table s7__table">
                <thead>
                    <tr>
                        <th>#</th>
                        <th>@lang('Name')</th>
                        <th>@lang('Code')</th>
                        <th>@lang('Action')</th>
                    </tr>
                </thead>
                <tbody>
                @foreach ($lang_list as $key => $data)
                    <tr id="row1">
                        <td>{{$key+1}}</td>
                        <td>{{$data->name}}</td>
                        <td>{{$data->code}}</td>
                        <td>
                            <a class="btn btn-primary btn-sm" href="{{route('language-key', $data->id)}}"><i class="fa fa-code"></i>@lang('Keyword Edit')</a>
                            <a class="btn btn-primary btn-sm" href="#editModal1{{$data->id}}" data-bs-toggle="modal">@lang('Edit')</a>
                            <button type="button" class="btn btn-danger btn-sm bold uppercase delete_button" data-bs-toggle="modal" data-bs-target="#delModal{{$data->id}}">@lang('Delete')</button>
                        </td>
                    </tr>

                <div id="editModal1{{$data->id}}" class="modal fade" tabindex="-1" data-backdrop="static" data-keyboard="false">
                    <div class="modal-dialog" role="document">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h5 class="modal-title">@lang('Edit') {{$data->name}}</h5>
                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                            </div>
                            <form class="form-cont" role="form" method="post" action="{{route('language-manage-update', $data->id)}}">
                                <div class="modal-body">
                                    {{csrf_field()}}

                                    <div class="row">
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('Language Name')</label>
                                            <input class="form-control text-capitalize" value="{{$data->name}}" id="code" type="text" required name="name">
                                        </div>
                                    </div>
                                </div>

                                <div class="modal-footer">
                                    <button type="button" id="btn-save" data-bs-dismiss="modal" class="btn btn-danger">@lang('Cancel')</button>
                                    <button type="submit" class="btn btn-success"> @lang('Update')</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
                
                <div id="delModal{{$data->id}}" class="modal fade" tabindex="-1" data-backdrop="static" data-keyboard="false">
                    <div class="modal-dialog" role="document">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h5 class="modal-title">@lang('Confirm Delete') {{$data->name}}</h5>
                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                            </div>
                            <div class="modal-body">
                                <h2 class="text-danger">@lang('Are you sure?')</h2>
                            </div>
                            <form class="form-cont" id="confirmDel" role="form" action="{{route('language-manage-del', $data->id)}}" method="post">
                                @csrf
                                @method('delete')
                                <div class="modal-footer">
                                    <input type="hidden" name="delete_id" id="delete_id" class="delete_id" value="0">
                                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">@lang('Close')</button>
                                    <button type="submit" class="btn btn-danger">@lang('Delete')</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
                @endforeach     
                </tbody>
            </table>
        </div>
    </div>

    <div id="addModal" class="modal fade" tabindex="-1" data-backdrop="static" data-keyboard="false">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">@lang('Add New Language')</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <form class="form-cont" role="form" method="post" action="{{route('language-manage-store')}}">
                    <div class="modal-body">
                        {{csrf_field()}}
                        <div class="row mb-2">
                            <div class="col-md-12">
                                <label class="control-label">@lang('Language Name')</label>
                                <input class="form-control text-capitalize" id="code" type="text" required name="name">
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-12">
                                <label class="control-label">@lang('Language Code')</label>
                                <input class="form-control text-capitalize" id="link" type="text" required name="code">
                            </div>
                        </div>
                    </div>

                    <div class="modal-footer">
                        <button type="button" data-bs-dismiss="modal" class="btn btn-danger">@lang('Cancel')</button>
                        <button type="submit" id="btn-save" class="btn btn-primary"> @lang('Submit')</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

@stop