@extends($theme.'frontend.layouts.master')
@section('title', __('Add Fund'))
@section('content')
<div class="contact-area pd-top-120 pd-bottom-120">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-9 col-md-8">
                <div class="stepwizard">
                    <div class="stepwizard-row setup-panel">
                        <div class="stepwizard-step col-xs-3">
                            <a href="#step-1" type="button" class="btn btn-success btn-circle">1</a>
                        <p><small>{{__('Amount')}}</small></p>
                        </div>
                        <div class="stepwizard-step col-xs-3">
                            <a href="#step-2" type="button" class="btn btn-default btn-circle" disabled="disabled">2</a>
                        <p><small>{{__('Gateway')}}</small></p>
                        </div>
                    </div>
                </div>
                <form role="form" method="POST" action="{{ route('submit.amount.deposit') }}" id="submitPayment" enctype="multipart/form-data">
                    @csrf
                    <div class="contact-page-inner bg-black-2 contact-page-inner-cust setup-content" id="step-1">
                        <div class="section-title mb-4 pb-2 text-center">
                            <h2 class="title">{{__('Put Your Deposit Amount')}} </h2>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <div class="single-input-inner">
                                    <label class="control-label">{{__('Amount')}}</label>
                                    <input maxlength="100" type="text" required="required" autocomplete="off" onkeyup="this.value = this.value.replace (/^\.|[^\d\.]/g, '')" name="amount"  id="amount" placeholder="{{__('AMOUNT')}}" />
                                </div>
                            </div>
                            <div class="col-12 text-center mt-3 mb-3">
                                <button type="button" class="btn btn-base border-radius-5 pe-5 ps-5 nextBtn">{{__('Next')}}</button>
                            </div>
                        </div>
                    </div>
                    <div class="payment-area pd-top-120 pd-bottom-220 setup-content" id="step-2">
                        <div class="container">
                            <div class="row justify-content-center">
                                <div class="col-lg-12 align-self-center">
                                    <div class="single-payment-wrap pe-xl-5 px-xl-5">
                                        <div class="row">
                                            <div class="col-lg-12 text-center">
                                                <h3 class="mb-5 mt-4">{{__('Select Payment Gateway')}}</h3>
                                            </div>
                                            @foreach($gateways as $gate)
                                            <div class="col-lg-4 col-md-6">
                                                <div class="payment-gateway-check form-check">
                                                    <input class="form-check-input" type="radio" name="gateway" id="customRadio{{$gate->id}}" data-valFour="{!! $gate->gateway_key_four !!}" data-valFive="{{$gate->name}}" value="{{$gate->id}}">
                                                    <label class="form-check-label" for="customRadio{{$gate->id}}">
                                                        <h6>{{__($gate->name)}}</h6>
                                                      <img src="{{asset('assets/images/gateway/'.$gate->image)}}" alt="img">
                                                      <p class="text-success mb-2">{{__('Min-Max')}} :{{$gate->minimum_deposit_amount}} - {{$gate->maximum_deposit_amount}} {{$general->currency}}</p>
                                                      <p class="text-danger">{{__('Fixed Charge')}} : {{$gate->fixed_charge}} {{$general->currency}} & {{__('Percentage Charge')}} : {{$gate->percentage_charge}}%</p>
                                                    </label>
                                                </div>
                                            </div>
                                            @endforeach
                                            <div class="col-lg-12">
                                                
                                                <button class="btn btn-base mt-4 mb-4 subPre" type="button">{{__('Submit & Preview')}}</button>
                                            </div>
                                        </div>  
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="modal fade" id="depositModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
                            <div class="modal-dialog">
                              <div class="modal-content">
                                <div class="modal-header">
                                  <h5 class="modal-title text-white gateWayFive" id="exampleModalLabel">{{__('Deposit via')}}</h5>
                                  <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                </div>
                                <form method="post" action="{{route('submit.amount.deposit')}}" enctype="multipart/form-data">
                                    @csrf
                                    <div class="modal-body">
                                        <strong class="text-white">{{__('Payment Details')}}</strong> <small>{{__('(Send Here)')}}</small><br>
                                        <div class="gateWayFour text-white">
                        
                                        </div>

                                        <div class="row manual-row">
                                            
                                        </div>
                                        
                                        {{-- <div class="form-group">
                                            <label for="exampleInputRecipt" class="text-white"><strong>{{__('Receipt Image')}}</strong></label>
                                            <input type="file" class="form-control" name="receipt">
                                        </div> --}}
                                    </div>
                                    <div class="modal-footer">
                                        <button type="submit" class="btn btn-success">{{__('Preview')}}</button>
                                        <button type="button" class="btn btn-danger" data-bs-dismiss="modal">{{__('Close')}}</button>
                                    </div>
                                </form>
                              </div>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>



@endsection
@section('script')
    <script>
         (function($) {
            "use strict";
        $(".subPre").on('click',function() {
            document.getElementById('submitPayment').submit();
        });


        $(document).ready(function () {
            $(".form-check-input").change(function() {
                if(this.checked && $(this).val() > 69) {
                    $('#depositModal').modal('show');
                    $('.gateWayFour').html($(this).attr('data-valFour'));
                    $('.gateWayFive').html($(this).attr('data-valFive'));
                }
            });

            var navListItems = $('div.setup-panel div a'),
                allWells = $('.setup-content'),
                allNextBtn = $('.nextBtn');

            allWells.hide();

            navListItems.click(function (e) {
                e.preventDefault();
                var $target = $($(this).attr('href')),
                    $item = $(this);

                if (!$item.hasClass('disabled')) {
                    navListItems.removeClass('btn-success').addClass('btn-default');
                    $item.addClass('btn-success');
                    allWells.hide();
                    $target.show();
                    $target.find('input:eq(0)').focus();
                }
            });

            allNextBtn.click(function () {
                var curStep = $(this).closest(".setup-content"),
                    curStepBtn = curStep.attr("id"),
                    nextStepWizard = $('div.setup-panel div a[href="#' + curStepBtn + '"]').parent().next().children("a"),
                    curInputs = curStep.find("input[type='text'],input[type='url']"),
                    isValid = true;

                $(".form-group").removeClass("has-error");
                for (var i = 0; i < curInputs.length; i++) {
                    if (!curInputs[i].validity.valid) {
                        isValid = false;
                        $(curInputs[i]).closest(".form-group").addClass("has-error");
                    }
                }

                if (isValid) nextStepWizard.removeAttr('disabled').trigger('click');
            });

            $('div.setup-panel div a.btn-success').trigger('click');
        });

    })(jQuery);

    </script>


<script>
    var globalData;
    $(".form-check-input").on('change', function (e) {

        "use strict"
        e.preventDefault();
        $('.manual-row').empty();
        var code = $(this).val()
        var url = '{{ route("user.deposit.gateway",":code") }}';
        url = url.replace(':code', code);
        $.get(url, function (data) {
            globalData = data;
            if (data.credentials !== undefined) {
                $('.manual-row').append(data.credentials)
            }

        });

    });
</script>

@stop
