@extends($theme . 'frontend.layouts.master')
@section('title', __('Welcome In Home'))
@section('content')
    <div class="dashboard-area pd-top-90 pd-bottom-120">
        <div class="container">
            <div class="mb-4">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="input-group mb-3">
                            <input type="text" class="form-control" id="myInputref"
                                value="{{ url('/') }}/register/{{ auth()->user()->referral_token }}">
                            <div class="input-group-append">
                                <button class="btn btn-secondary myrefButtonFunction" type="button"
                                    onclick="myrefButtonFunction()">{{ __('Copy Referral Link') }}</button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="mb-4">
                <div class="row">
                    @foreach ($rankings as $rank)
                        <div class="col-xl-2 col-md-4 col-6 text-center mt-xl-0 mt-4">
                            <div class="raking-item bg-black-2">
                                @php
                                    $rankingIds = auth()->user()->rankings()->pluck('ranking_id')->toArray();
                                @endphp

                                @php
                                    $rank = \App\Models\Ranking::find($rank->id);
                                @endphp
                                @if (in_array($rank->id, $rankingIds))
                                    <img src="{{ asset('assets/images/ranking/' . $rank->image) }}" alt="">
                                    <h5 class="color-base mt-4">{{ $rank->title }}</h5>
                                    <p>{{ $rank->bonus }} {{ $general->currency }}</p>

                                    <p class="fs-14 text-muted"><i class="fa fa-check text-success"></i> {{ __('You are eligible for this level') }}</p>
                                @else
                                    <img src="{{ asset('assets/images/ranking/' . $rank->image) }}" alt="">
                                    <h5 class="color-base mt-4">{{ $rank->title }}</h5>
                                    <p>{{ $rank->bonus }} {{ $general->currency }}</p>

                                    <p class="fs-14 text-muted"><i class="fa fa-times text-danger"></i> {{ __('You are not eligible for this level') }}</p>
                                @endif
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
            <div class="mb-4">
                <div class="row">
                    <div class="col-lg-4 col-md-6">
                        <div class="media bg-light-base image-hover-rotate border-radius-5 p-4 mb-4">
                            <div class="media-left align-self-center pe-4">
                                <img class="rotate-img ps-xl-2" src="assets/frontend/deepblack/img/icon/17.svg"
                                    alt="img">
                            </div>
                            <div class="media-body">
                                <h4 class="color-base mb-1">{{ round(auth()->user()->balance, 8) }} {{ $general->currency }}
                                </h4>
                                <h6 class="mb-0">{{ __('Current Balance') }}</h6>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4 col-md-6">
                        <div class="media bg-light-base image-hover-rotate border-radius-5 p-4 mb-4">
                            <div class="media-left align-self-center pe-4">
                                <img class="rotate-img ps-xl-2" src="assets/frontend/deepblack/img/icon/14.svg"
                                    alt="img">
                            </div>
                            <div class="media-body">
                                <h4 class="color-base mb-1">{{ round($total_earn, 8) }} {{ $general->currency }}</h4>
                                <h6 class="mb-0">{{ __('Total Earning') }}</h6>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4 col-md-6">
                        <div class="media bg-light-base image-hover-rotate border-radius-5 p-4 mb-4">
                            <div class="media-left align-self-center pe-4">
                                <img class="rotate-img ps-xl-2" src="assets/frontend/deepblack/img/icon/10.svg"
                                    alt="img">
                            </div>
                            <div class="media-body">
                                <h4 class="color-base mb-1">{{ round($total_withdraw, 8) }} {{ $general->currency }}</h4>
                                <h6 class="mb-0">{{ __('Total Withdraw') }}</h6>
                            </div>
                        </div>
                    </div>



                    <div class="col-lg-4 col-md-6">
                        <div class="media bg-light-base image-hover-rotate border-radius-5 p-4 mb-4">
                            <div class="media-left align-self-center pe-4">
                                <img class="rotate-img ps-xl-2" src="assets/frontend/deepblack/img/icon/15.svg"
                                    alt="img">
                            </div>
                            <div class="media-body">
                                <h4 class="color-base mb-1">{{ round($month_earn, 8) }} {{ $general->currency }}</h4>
                                <h6 class="mb-0">{{ __('This Month Earn') }}</h6>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4 col-md-6">
                        <div class="media bg-light-base image-hover-rotate border-radius-5 p-4 mb-4">
                            <div class="media-left align-self-center pe-4">
                                <img class="rotate-img ps-xl-2" src="assets/frontend/deepblack/img/icon/16.svg"
                                    alt="img">
                            </div>
                            <div class="media-body">
                                <h4 class="color-base mb-1">{{ round($month_deposit, 8) }} {{ $general->currency }}</h4>
                                <h6 class="mb-0">{{ __('This Month Deposit') }}</h6>
                            </div>
                        </div>
                    </div>

                    <div class="col-lg-4 col-md-6">
                        <div class="media bg-light-base image-hover-rotate border-radius-5 p-4 mb-4">
                            <div class="media-left align-self-center pe-4">
                                <img class="rotate-img ps-xl-2" src="assets/frontend/deepblack/img/icon/11.svg"
                                    alt="img">
                            </div>
                            <div class="media-body">
                                <h4 class="color-base mb-1">{{ round($month_withdraw, 8) }} {{ $general->currency }}</h4>
                                <h6 class="mb-0">{{ __('This Month Withdraw') }}</h6>
                            </div>
                        </div>
                    </div>

                    <div class="col-lg-4 col-md-6">
                        <div class="single-feature-inner bg-light-base text-center image-hover-rotate border-radius-10">
                            <div class="thumb mb-4">
                                <img class="rotate-img" src="assets/frontend/deepblack/img/icon/7.svg" alt="img">
                            </div>
                            <div class="details">
                                <h5 class="color-base mb-1">{{ round($total_PendingWithdraw, 8) }}
                                    {{ $general->currency }}
                                </h5>
                                <h6 class="mb-0">{{ __('Total Pending Withdraw') }}</h6>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4 col-md-6">
                        <div class="single-feature-inner bg-light-base text-center image-hover-rotate border-radius-10">
                            <div class="thumb mb-4">
                                <img class="rotate-img" src="assets/frontend/deepblack/img/icon/4.svg" alt="img">
                            </div>
                            <div class="details">
                                <h5 class="color-base mb-1">{{ round($total_fundTransfer, 8) }} {{ $general->currency }}
                                </h5>
                                <h6 class="mb-0">{{ __('Total Fund Transfer') }}</h6>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4 col-md-6">
                        <div class="single-feature-inner bg-light-base text-center image-hover-rotate border-radius-10">
                            <div class="thumb mb-4">
                                <img class="rotate-img" src="assets/frontend/deepblack/img/icon/5.svg" alt="img">
                            </div>
                            <div class="details">
                                <h5 class="color-base mb-1">{{ round($month_fundTransfer, 8) }} {{ $general->currency }}
                                </h5>
                                <h6 class="mb-0">{{ __('This Month Fund Transfer') }}</h6>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('script')
    <script>
        (function($) {
            "use strict";
            $(document).ready(function() {
                $(document).on('click', '.myrefButtonFunction', function() {
                    var copyText = document.getElementById("myInputref");
                    copyText.select();
                    copyText.setSelectionRange(0, 99999);
                    document.execCommand("copy");
                    alert("Copied referral link : " + copyText.value);
                })
            });
        })(jQuery);
    </script>
@endsection
