<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <title>{{ __($general->web_name) }} | @yield(__('title')) </title>
    <link rel=icon href="{{ asset('assets/images/logo/favicon.png') }}" sizes="20x20" type="image/png">
    @if (request()->routeIs('single.page'))
        
        <meta name="description" content="{{ $menu->seo_details ?? $general->seo_details }}">
        <meta name="title" content="{{ $menu->seo_title ?? $general->seo_title }}">
    @else
        <meta name="description" content="{{ $general->seo_details }}">
        <meta name="title" content="{{ $general->seo_title }}">
    @endif
    @include($theme . 'frontend.layouts.partials.style')
    @yield('style')
</head>

<body>

    <div class="preloader" id="preloader">
        <div class="preloader-inner">
            <div class="spinner">
                <div class="dot1"></div>
                <div class="dot2"></div>
            </div>
        </div>
    </div>

    @include($theme . 'frontend.layouts.partials.nav')

    @include($theme . 'frontend.layouts.slider')

    @yield('content')

    @include($theme . 'frontend.layouts.partials.footer')

    @include($theme . 'frontend.layouts.partials.script')
    @yield('script')

    @if ($errors->any())
        @foreach ($errors->all() as $error)
            <script>
                (function($) {
                    "use strict";
                    toastr.warning('{{ $error }}')
                })
                (jQuery);
            </script>
        @endforeach
    @endif
    @if (Session::has('message'))
        <script>
            (function($) {
                "use strict";
                toastr.success('{{ Session::get('message') }}');
            })(jQuery);
        </script>
    @endif
    @if (session()->has('success'))
        <script>
            (function($) {
                "use strict";
                toastr.success('{{ session()->get('success') }}')
            })(jQuery);
        </script>
    @endif
    @if (session()->has('alert'))
        <script>
            (function($) {
                "use strict";
                toastr.error('{{ session()->get('alert') }}')
            })(jQuery);
        </script>
    @endif
</body>

</html>
