<div class="navbar-area navbar-area-2">
    <div class="navbar-top">
        <div class="container">
            <div class="row">
                <div class="col-sm-2 text-sm-left text-center">
                    <ul class="topbar-left">
                        <li class="topbar-single-info">
                            <select class="topbar-select topbar-currency" style="display: none;" id="langSel">
                                <option value="en">English</option>
                                @foreach($lang as $data)
                                <option value="{{$data->code}}" @if(Session::get('lang') === $data->code) selected  @endif>{{$data->name}}</option>
                                @endforeach
                            </select>
                        </li>
                    </ul>
                </div>
                <div class="col-sm-4 text-sm-left text-center d-none d-sm-block">
                    <ul class="topbar-left">
                        <li class="topbar-single-info"><i class="fa fa-envelope"></i>{{$general->contact_email}}</li>
                        <li class="topbar-single-info ml-3 ml-lg-0"><i class="fa fa-phone"></i>{{$general->contact_phone}}</li>
                    </ul>
                </div>
                <div class="col-sm-4 text-sm-right text-center">
                    <ul class="topbar-right float-md-right">
                        @auth
                            @if ($general->ico == 1)
                                <li class="topbar-single-info">1 {{$general->currency}} = {{ number_format($general->cp_currency_rt,6) }} {{$general->cp_currency}}</li>
                            @else
                                <li></li>
                            @endif
                        @else
                        <li></li>
                        @endif
                    </ul>
                </div>
                <div class="col-sm-2 text-sm-right text-center">
                    <ul class="topbar-right float-md-right">
                        @foreach($social as $data)
                        <li class="topbar-single-info topbar-social-icon"><a href="{{$data->link}}" target="_blank"><i class="fa fa-{{$data->icon}}"></i></a></li>
                        @endforeach
                    </ul>
                </div>
            </div>
        </div>
    </div>
    <nav class="navbar navbar-area navbar-expand-lg nav-transparent">
        <div class="container nav-container nav-white">
            <div class="responsive-mobile-menu">
                <button class="menu toggle-btn d-block d-lg-none" data-target="#investon_main_menu" aria-expanded="false" aria-label="Toggle navigation">
                    <span class="icon-left"></span>
                    <span class="icon-right"></span>
                </button>
            </div>
            <div class="logo">
                <a href="{{url('/')}}"> <img src="{{asset('assets/images/logo/logo.png')}}" alt="logo"></a>
            </div>
            <div class="collapse navbar-collapse" id="investon_main_menu">
                <ul class="navbar-nav menu-open">
                    @auth
                        @if ($general->ico == 1)
                            <li class="menu-item-has-children">
                                <a href="#">{{$general->cp_currency}} <i class="fa fa-angle-down"></i></a>
                                <ul class="sub-menu">
                                    <li><a href="{{route('wallet.index')}}"><i class="fa fa-long-arrow-right"></i>{{__('Wallets')}}</a></li>
                                    <li><a href="{{route('my.wallet.transaction.log')}}"><i class="fa fa-long-arrow-right"></i>{{__('My Transaction Log')}}</a></li>
                                    <li><a href="{{route('other.wallet.transaction.log')}}"><i class="fa fa-long-arrow-right"></i>{{__('Other Transaction Log')}}</a></li>
                                </ul>
                            </li>
                        @else
                            <li>
                                <a href="{{route('home')}}">{{__('Dashboard')}}</a>
                            </li>
                        @endif

                        <li class="menu-item-has-children">
                            <a href="#">{{__('Deposit')}} <i class="fa fa-angle-down"></i></a>
                            <ul class="sub-menu">
                                <li><a href="{{route('users.showDepositMethods')}}"><i class="fa fa-long-arrow-right"></i>{{__('Add Deposit')}}</a></li>
                                <li><a href="{{route('user.deposit.log')}}"><i class="fa fa-long-arrow-right"></i>{{__('Deposit Log')}}</a></li>
                            </ul>
                        </li>


                        <li class="menu-item-has-children">
                            <a href="#">{{__('Investment')}} <i class="fa fa-angle-down"></i></a>
                            <ul class="sub-menu">
                                <li><a href="{{route('invest.index')}}"><i class="fa fa-long-arrow-right"></i>{{__('Investment Plan')}}</a></li>
                                <li><a href="{{route('invest.log')}}"><i class="fa fa-long-arrow-right"></i>{{__('Invest Log')}}</a></li>
                            </ul>
                        </li>


                        <li class="">
                            <a href="{{route('credit-card')}}">{{__('Credit Card')}}</a>
                        </li>

                        <li class="menu-item-has-children">
                            <a href="#">{{__('Transaction')}} <i class="fa fa-angle-down"></i></a>
                            <ul class="sub-menu">
                                <li><a href="{{route('user.ref.index')}}"><i class="fa fa-long-arrow-right"></i>{{__('My Referral Tree')}}</a></li>
                                <li><a href="{{route('fund.transfer')}}"><i class="fa fa-long-arrow-right"></i>{{__('Fund Transfer')}}</a></li>
                                <li><a href="{{route('transaction.log')}}"><i class="fa fa-long-arrow-right"></i>{{__('Transaction Log')}}</a></li>
                                @if ($general->ico == 1)
                                <li><a href="{{route('purchase.coin')}}"><i class="fa fa-long-arrow-right"></i>{{__('MIN CRYPTO')}}</a></li>
                                @endif
                            </ul>
                        </li>

                        <li class="menu-item-has-children">
                            <a href="#">{{__('Withdraw')}} <i class="fa fa-angle-down"></i></a>
                            <ul class="sub-menu">
                                <li><a href="{{route('user.withdraw.method')}}"><i class="fa fa-long-arrow-right"></i>{{__('Withdraw')}}</a></li>
                                <li><a href="{{route('user.withdraw.log')}}"><i class="fa fa-long-arrow-right"></i>{{__('Withdraw Log')}}</a></li>
                            </ul>
                        </li>
                        @php $check_count = \App\Models\Support::where('status', 2)->get() @endphp
                        <li class="menu-item-has-children">
                            <a href="#">{{split_name(auth()->user()->name)[0]}} <i class="fa fa-angle-down"></i></a>
                            <ul class="sub-menu">
                                @if ($general->ico == 1)
                                    <li><a href="{{route('home')}}"><i class="fa fa-long-arrow-right"></i>{{__('Dashboard')}}</a></li>
                                @endif
                                <li><a href="{{route('profile.index')}}"><i class="fa fa-long-arrow-right"></i>{{__('Profile')}}</a></li>
                                <li><a href="{{route('customer.support.index')}}"><i class="fa fa-long-arrow-right"></i>{{__('Support')}} @if(count($check_count) == 0)  @else <span class="right badge bg-danger"> {{count($check_count)}} </span> @endif</a></li>
                                <li><a href="{{route('user.kyc.index')}}"><i class="fa fa-long-arrow-right"></i>{{__('Kyc')}}</a></li>
                                <li><a href="{{route('two.factor.index')}}"><i class="fa fa-long-arrow-right"></i>{{__('Security')}}</a></li>
                                <li><a onclick="event.preventDefault();document.getElementById('logout-form').submit();" href="{{route('logout')}}"><i class="fa fa-long-arrow-right"></i>{{__('Logout')}}</a></li>
                            </ul>
                        </li>

                        <form id="logout-form" action="{{ route('logout') }}" method="POST" class="display-none">
                            @csrf
                        </form>
                        @else
                        <li>
                            <a href="{{url('/')}}">{{__('Home')}}</a>
                        </li>
                        @foreach($frontMenu as $data)
                            <li>
                                <a href="{{route('single.page',['class' => $data->slug, 'id' =>$data->id])}}">{{__($data->title)}}</a>
                            </li>
                        @endforeach
                        <li>
                            <a href="{{route('news.index')}}">{{__('News')}}</a>
                        </li>
                        <li>
                            <a href="{{route('contacts.index')}}">{{__('Contact')}}</a>
                        </li>
                        <li class="menu-item-has-children">
                            <a href="#">{{__('Account')}} <i class="fa fa-angle-down"></i></a>
                            <ul class="sub-menu">
                                <li><a href="{{route('register')}}"><i class="fa fa-long-arrow-right"></i>{{__('Sign Up')}}</a></li>
                                <li><a href="{{route('login')}}"><i class="fa fa-long-arrow-right"></i>{{__('Sign In')}}</a></li>
                            </ul>
                        </li>
                    @endif
                </ul>
            </div>
        </div>
    </nav>
</div>