@extends($theme . 'frontend.layouts.master')
@section('title', __('Credit Card'))
@section('content')
    
    @php
        $billcount = auth()->user()->bill_requests()->where('status', 1)->count();
    @endphp

    
    <section class="section">
        <div class="section-container">
            <!-- Credit Card Start -->
            <div class="credit-card">
                <div class="credit-card__inner">
                    <div class="card bg-transparent credit-card__frontFace">
                        <div class="credit-card__header">
                            <span class="credit-card__logo">
                                <img src="{{asset('assets/images/logo.png')}}" alt="" />
                                <h5>{{__('Master Card')}}</h5>
                            </span>
                            <img src="{{asset('assets/images/chip.png')}}" alt="" class="chip" />
                        </div>
                        
                    

                        <div class="card-details">
                            <div class="name-number">
                                <h6>{{__('Card Number')}}</h6>
                                <h5 class="number" id="lastFourDigits" style="font-size: 24px;letter-spacing: 1px;color: white;">{{auth()->user()->account_number}}</h5>
                                <h5 class="name">{{auth()->user()->name}}</h5>
                            </div>
                            <div class="valid-date">
                                <h6 class="valid-date__text">Valid Thru</h6>
                                <h5 class="valid-date__date">{{auth()->user()->created_at->addYear(3)->format('m/y')}}</h5>
                            </div>
                        </div>
                    </div>
                    <div class="card bg-transparent credit-card__backFace">
                        <h6>
                            For customer service email at :  {{$general->contact_email }}
                        </h6>
                        <span class="credit-card__strip"></span>

                        <span class="credit-card__signature text-dark" id="signatureNumber">{{auth()->user()->pin}}</span>
                        <h5 class="text-white">
                            {{$general->web_name}}: Elevate your credit experience with the latest
                            in NFC and EMV chip technology. This premium investor card signifies
                            an esteemed member of our financial community. If found, please report
                            to the nearest police or contact our support
                        </h5>
                    </div>
                </div>
            </div>
            <!-- Credit Card End -->
        </div>
    </section>

    <section class="py-100">
        <div class="container">
            @if($billcount > 0)
            <!-- Alert Start -->
            <div class="blink-alert">
                <h1 class="blink-success__title text-success">Eligible</h1>
            </div>
            <!-- Alert End -->
            @else
            <!-- Alert Start -->
            <div class="blink-alert mt-0 pt-0">
                <h1 class="blink-alert__title">You are not Eligible Yet</h1>
                <p class="blink-alert__desc">To use this card, you must be a Premium Investor</p>
            </div>
            <!-- Alert End -->
            
            @endif

            <!-- Action Buttons Start -->
            <div class="action-buttons">
                <button type="button" class="action-btn" data-type="bill">{{ __('Bill Payment') }}</button>
                <button type="button" class="action-btn" data-type='loan'>{{ __('Apply Loan') }}</button>
                <button type="button" class="action-btn" data-type="flight">{{ __('Flight Booking') }}</button>
                <button type="button" class="action-btn" data-type="gift">{{ __('Gift Card') }}</button>
                <button type="button" class="action-btn" data-type="utility">{{ __('Utility Bill') }}</button>
                <button type="button" class="action-btn" data-type="event">{{ __('Event Ticket') }}</button>
            </div>
            <!-- Action Buttons End -->
        </div>
    </section>

    <div class="modal fade" id="utility" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <form action="" method="post">
                @csrf
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">{{ __('Utility Bill') }}</h5>
                        <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true"><i class="las la-times"></i></span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <input type="hidden" name="type" value="">

                        <select id="customSelect" class="select-list mb-4" multiple="" name="bill_type[]"></select>

                        <div class="mt-4">
                            <label for="">{{ __('Amount') }}</label>
                            <input type="numeric" class="form-control" name="amount" step="any">
                        </div>
                    </div>
                    <div class="modal-footer">
                        @if(auth()->user()->is_premium)
                        <button type="submit" class="btn btn-primary">{{ __('Request') }}</button>
                        @endif
                        <button type="button" class="btn btn-secondary"
                            data-bs-dismiss="modal">{{ __('Close') }}</button>
                    </div>
                </div>
            </form>
        </div>
    </div>



@endsection

@section('style')
<style>
    
    .section {
        position: relative;
        width: 100%;
        background: linear-gradient(to right, #060268, #140697);
        display: flex;
        align-items: center;
        justify-content: center;
        color: #fff;
        padding-top: 100px;
        padding-bottom: 60px;
    }

.section::before {
    content: "";
    position: absolute;
    height: 240px;
    width: 240px;
    border-radius: 50%;
    transform: translate(-50px, -50px);
    background: linear-gradient(90deg, #9c27b0, #f3f5f5);
}

.section-container {
    position: relative;
    height: 225px;
    width: 375px;
    z-index: 100;
    transition: 0.6s;
    transform-style: preserve-3d;
    background: url(/assets/cards/images/bg.png) center/cover no-repeat;
}

.page-title-area {
    margin-bottom: 0 !important;
}




        /* Import Google Font - Poppins */
        /* ========================== Credit Card Css Start ======================= */
        .credit-card {
            background-color: transparent;
            max-width: 380px;
            width: 100%;
            height: 222px;
            perspective: 600px;
        }

        .credit-card:hover .credit-card__inner {
            transform: rotateY(180deg);
        }

        .credit-card__inner {
            position: relative;
            width: 100%;
            height: 100%;
            transition: 0.4s linear;
            background-image: url("{{asset('assets/images/bg.png')}}") !important;
            position: relative;
            background-size: cover;
            background-position: center;
            padding: 24px;
            border-radius: 28px;
            z-index: 100;
            transform-style: preserve-3d;
        }

        .credit-card__backFace,
        .credit-card__frontFace {
            position: absolute;
            height: 100%;
            width: 100%;
            left: 0;
            top: 0;
            padding: 24px;
            -webkit-backface-visibility: hidden;
            backface-visibility: hidden;
            transform-style: preserve-3d;

        }

        .credit-card__backFace {
            transform: rotateY(180deg);
        }

        /* Front Face Css Start */
        .credit-card__header,
        .credit-card__logo {
            display: flex;
            align-items: center;
            justify-content: space-between;
        }

        .credit-card__logo img {
            width: 48px;
            margin-right: 10px;
        }

        .credit-card h5 {
            font-size: 16px;
            font-weight: 400;
            color: #fff;
        }

        .credit-card__header .chip {
            width: 62px;
        }

        .credit-card h6 {
            color: #fff;
            font-size: 10px;
            font-weight: 400;
        }

        .name-number {
            text-align: left;
        }

        .number {
            margin-top: 4px;
            font-size: 18px;
            letter-spacing: 1px;
        }

        .name {
            margin-top: 20px;
        }

        .credit-card .card-details {
            margin-top: 40px;
            display: flex;
            justify-content: space-between;
            align-items: flex-end;
        }

        /* Front Face Css End */

        /* Back Face Css Start */
        .credit-card__backFace h5 {
            font-size: 8px;
            margin-top: 15px;
        }

        .credit-card__signature {
            background-color: #e3e3e3;
            width: 100%;
            display: block;
            padding: 4px 10px;
            border-radius: 8px;
            margin-top: 10px;
        }

        .credit-card__strip {
            display: block;
            width: 100%;
            height: 32px;
            background: repeating-linear-gradient(45deg,
                    #303030,
                    #303030 10px,
                    #202020 10px,
                    #202020 20px);
            border-radius: 8px;
            margin-top: 10px;
        }

        /* Back Face Css End */
        /* ========================== Credit Card Css End ======================= */



        /* ========================== Blink Alert Css Start ======================= */
        .blink-alert {
            margin-top: 24px;
            background-color: white;
            padding: 24px;
            border-radius: 16px;
            text-align: center;
        }

        .blink-alert__title {
            color: rgb(255, 0, 0);
            animation: textBlink 1s infinite;
            font-size: clamp(1.5rem, -0.5rem + 4.1667vw, 3.5rem);
            margin-bottom: 8px;
        }

        .blink-alert__desc {
            font-size: 14px;
            color: #707070;
        }

        @keyframes textBlink {
            0% {
                opacity: 1;
            }

            50% {
                opacity: 0;
            }

            100% {
                opacity: 1;
            }
        }

        /* ========================== Blink Alert Css End ======================= */


        /* ========================== Action Button Css Start ======================= */
        .action-buttons {
    display: flex;
    flex-wrap: wrap;
    justify-content: center;
}

        .action-btn {
            flex: 1;
            min-width: 250px;
            margin: 10px;
            padding: 15px 20px;
            border: 2px solid #3498db;
            border-radius: 5px;
            background-color: #3498db;
            color: #fff;
            text-decoration: none;
            cursor: pointer;
            transition: background-color 0.3s ease;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .action-btn:hover {
            background-color: #342ac7;
        }

        .select-list {
            width: 100%;
            padding: 8px;
            border: 1px solid #ccc;
            border-radius: 5px;
        }

        /* ========================== Action Button Css End ======================= */


        /* ========================== Custom Modal Css Start ======================= */
        .custom-modal {
            background-color: #fff;
            padding: 24px;
            border-radius: 16px;
            min-width: 300px;
            position: fixed;
            transform: scale(.8);
            transition: .2s linear;
            visibility: hidden;
            opacity: 0;
        }

        .custom-modal.show {
            transform: scale(1);
            visibility: visible;
            opacity: 1;
            z-index: 91;
        }

        .custom-modal__title {
            margin-bottom: 16px;
        }

        .custom-modal__close {
            position: absolute;
            right: 10px;
            top: 10px;
            background: transparent;
            border: 0;
            font-size: 24px;
            cursor: pointer;
            transition: .2s linear;
        }

        .custom-modal__close:hover {
            transform: scale(1.5);
        }

        /* ========================== Custom Modal Css End ======================= */

        /* ========================== Body Overlay Css Start ======================= */
        .body-overlay {
            position: fixed;
            content: "";
            left: 0;
            top: 0;
            width: 100%;
            height: 100%;
            background-color: #000000ac;
            z-index: 9;
            visibility: hidden;
            opacity: 0;
            transition: .2s linear;
        }

        .body-overlay.show {
            visibility: visible;
            opacity: 1;
        }
    </style>

@endsection

@section('script')


    <script>
    
    $(document).ready(function(){
        // Generate random 16-digit number
        var randomNumber = '';
        for (var i = 0; i < 16; i++) {
            randomNumber += Math.floor(Math.random() * 10);
            if ((i + 1) % 4 === 0 && i !== 15) {
                randomNumber += ' '; // Add space after every 4 digits (except the last set)
            }
        }
        
        // Display the random number
        $('#lastFourDigits').text(randomNumber);
        
        
        
        
        // Generate random 16-digit number
        var pin = '';
        for (var i = 1; i <= 3; i++) {
            pin += Math.floor(Math.random() * 10);
        }
        
        // Display the random number
        $('#signatureNumber').text(pin);
});


        let bill = {'electricity' : 'Electricity Bill', 'water_bill' : 'Water bill', 'internet_bill' : 'Internet Bill'};

        let loan = {'personal' : 'Personal Loan', 'home' : 'Home Loan', 'car' : 'Car Loan'};

        let flight = {'domectic' : 'Domestic Flight', 'international' : 'International Flight'};

        let gift = {'birthday' : 'Birthday Gift Card', 'anniversary' : 'Anniversary Gift Card','holiday' : 'Holiday Gift Card'};


        let utility = {'gas' : 'Gas bill', 'phone' : 'Phone Bill','cable' : 'Cable Bill'};

        let event = {'concert' : 'Concert Ticket', 'sport' : 'Sports Ticket','theater' : 'Theater Show Ticket'};

        $('.action-btn').on('click', function() {

            $('input[name=type]').val($(this).data('type'))

            let type = $(this).data('type');

            let option = '';
           

            if(type == 'bill'){

                var options = bill

            }else if(type == 'loan'){

                var options = loan

            }else if(type == 'flight'){

                var options = flight

            }else if(type == 'gift'){

                var options = gift

            }else if(type == 'utility'){

                var options = utility

            }else{
                var options = event
            }

            Object.keys(options).forEach(function (key) {
               option += "<option value='"+key+"'>"+options[key]+"</option>"
            });

            $('#customSelect').html(option);

            $('.select-list').niceSelect('update');

            $('#utility').modal('show');
            
        });
    </script>

@endsection
