@extends($theme.'frontend.layouts.master')
@section('title',__('Invest History'))
@section('content')
    <!-- transaction-area start -->
    <div class="transaction-area left-bottom-line-bg common-pd-bottom-3" >
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <h4 class="card-title mb-0">{{__('Invest History')}}</h4>
                        </div>
                        <div class="card-body p-0">
                            <div class="table-responsive">
                                <table class="table table-hover">
                                    <thead>
                                    <tr>
                                        <th> {{__('Package')}} </th>
                                        <th> {{__('Type')}} </th>
                                        <th> {{__('Invest Amount')}} </th>
                                        <th> {{__('Payable')}} </th>
                                        <th> {{__('Already Return')}} </th>
                                        <th> {{__('Next Return Time')}} </th>
                                        <th> {{__('Status')}} </th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    @forelse($plans as $data)
                                    <tr class="table-margin">
                                        <th></th>
                                    </tr>
                                    <tr>
                                        <td>{{__($data->plan_name)}}</td>
                                        <td>
                                            @switch($data->get_period)
                                                @case(1)
                                                {{__('Hourly')}}
                                                @break
                                                @case(24)
                                                {{__('Daily')}}   @break
                                                @case(168)
                                                {{__('Weekly')}}   @break
                                                @case(720)
                                                {{__('Monthly')}}   @break
                                                @case(2880)
                                                {{__('Quarterly')}}   @break
                                                @case(8640)
                                                {{__('Yearly')}}   @break
                                            @endswitch
                                        </td>
                                        <td>{{$data->invest_amount}}  {{$general->currency}}</td>
                                        <td>{{$data->get_percent}}%/{{is_null($data->get_action) ? 'Lifetime': $data->get_action.' Times'}}  </td>
                                        <td>{{$data->took_action}} {{__('TIMES')}}</td>
                                        <td>{{date('d/m/y  h:i A',strtotime($data->next_time))}}</td>
                                        <td>
                                            @if($data->status == 0)
                                                <span class="badge badge-primary">{{__('Continue')}}</span>
                                            @else
                                                <span class="badge badge-success">{{__('Complete')}}</span>
                                            @endif
                                        </td>
                                    </tr>
                                    @empty 
                                        <tr>
                                            <td colspan="12" class="text-center">
                                                <div class="no-data-found">
                                                    <span class="icon"><i class="lar la-folder-open"></i></span>
                                                    <p class="mb-0">{{__('No Data Found')}}</p>
                                                </div>
                                            </td>
                                        </tr>
                                    @endforelse
                                    </tbody>
                                </table>
                                <div class="text-center">
                                    {{$plans->links()}}
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- transaction-area end -->
@endsection
