@extends($theme.'frontend.layouts.master')
@section('title',__('KYC'))
@section('content')

<div class="check-profit-area pt-4 pb-5">
    <div class="container">
        <div class="row">
            <div class="col-lg-12">
                @if(in_array($user->identity_verify,[0,3])  )
                <form method="post" action="{{route('user.verificationSubmit')}}" enctype="multipart/form-data">
                    @csrf
                    <div class="title text-center">
                        <h5>{{__('KYC Verification')}}</h5>
                    </div>
                    <div class="row justify-content-center mb-2">
                        <div class="col-lg-6">
                            <label class="form-label d-block w-100 golden-text" for="identity_type">@lang('Identity Type')</label>
                            <select name="identity_type" id="identity_type" class="nice-select">
                                <option class="text-white bg-dark" value="" selected disabled>@lang('Select Type')</option>
                                @foreach($identityFormList as $sForm)
                                    <option class="text-white bg-dark"
                                        value="{{$sForm->slug}}" {{ old('identity_type', @$identity_type) == $sForm->slug ? 'selected' : '' }}>@lang($sForm->name)</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="row justify-content-center mb-2">
                        @if(isset($identityForm))
                        @foreach($identityForm->services_form as $k => $v)
                        @if($v->type == "text")
                        <div class="col-lg-6">
                            <div class="form-group">
                                <label
                                    for="{{$k}}" class="golden-text">{{trans($v->field_level)}} @if($v->validation == 'required')
                                        <span class="text-danger">*</span>  @endif
                                </label>
                                <input type="text" name="{{$k}}"
                                    class="form-control "
                                    value="{{old($k)}}" id="{{$k}}"
                                    @if($v->validation == 'required') required @endif>
                                    @if($errors->has($k))
                                        <div
                                            class="error text-danger">@lang($errors->first($k)) </div>
                                    @endif
                            </div>
                        </div>
                    </div>
                    <div class="row justify-content-center mb-2">
                        @elseif($v->type == "textarea")
                        <div class="col-lg-6">
                            <div class="form-group">
                                <label
                                    for="{{$k}}" class="golden-text">{{trans($v->field_level)}} @if($v->validation == 'required')
                                        <span
                                            class="text-danger">*</span>  @endif
                                </label>
                                <textarea name="{{$k}}" id="{{$k}}"
                                        class="form-control "
                                        rows="5"
                                        placeholder="{{trans('Type Here')}}"
                                        @if($v->validation == 'required')@endif>{{old($k)}}</textarea>
                                @error($k)
                                <div class="error text-danger">
                                    {{trans($message)}}
                                </div>
                                @enderror
                            </div>
                        </div>
                    </div>
                    <div class="row justify-content-center mb-2">
                        @elseif($v->type == "file")
                        <div class="col-lg-6">
                            <div class="form-group">
                                <label class="golden-text">{{trans($v->field_level)}} @if($v->validation == 'required')
                                        <span class="text-danger">*</span>  @endif
                                </label>
                                <br>
                                <input type="file" id="file-input" class="form-control" name="{{$k}}"
                                value="{{ old($k) }}" accept="image/*"
                                @if($v->validation == "required")@endif>
                                <div class="row mt-2">
                                    <div class="col-md-12">
                                        <div id='img_contain'>
                                            <img id="image-preview" class="img-fluid" align='middle' src="{{ getFile(config('location.default')) }}" alt="your image" title=''/>
                                        </div>
                                    </div>
                                </div>
                                @error($k)
                                <div class="error text-danger">
                                    {{trans($message)}}
                                </div>
                                @enderror
                            </div>
                        </div>
                        @endif

                        @endforeach
                    </div>
                    <div class="row justify-content-center mb-2">

                        <div class="col-lg-6">
                            <div class="send-btn">
                                <button type="submit" class="btn btn-success btn-block">{{__('Submit')}}</button>
                            </div>
                        </div>
                        @endif
                    </div>
                </form>
                @elseif($user->identity_verify == 1)
                    <div class="alert mb-0 text-center">
                        <img src="{{asset('assets/images/notification.png')}}" alt="@lang('notification img')"/>
                        <span> @lang('Your KYC submission has been pending')</span>
                    </div>
                @elseif($user->identity_verify == 2)
                    <div class="alert mb-0 text-center">
                        <img src="{{asset('assets/images/notification.png')}}" alt="@lang('notification img')"/>
                        <span> @lang('Your KYC already verified')</span>
                    </div>
                @endif
            </div>
        </div>
    </div>
</div>

@endsection
@section('script')
    <script>
        "use strict";
            function readURL(input) {
                if (input.files && input.files[0]) {
                    var reader = new FileReader();
                    reader.onload = function(e) {
                        $('#image-preview').attr('src', e.target.result);
                        $('#image-preview').hide();
                        $('#image-preview').fadeIn(650);
                    };
                    reader.readAsDataURL(input.files[0]);
                }
            }
            $("#file-input").on('change',function() {
                readURL(this);
            });


        $(document).on('change', "#identity_type", function () {
            let value = $(this).find('option:selected').val();
            window.location.href = "{{route('user.kyc.index')}}/?identity_type=" + value
        });

    </script>
@endsection