@extends($theme.'frontend.layouts.master')
@section('title',__('Support'))
@section('content')

<div class="transaction-area common-pd-bottom-3">
    <div class="container">
        <div class="card">
            <div class="card-header d-flex flex-wrap align-items-center">
                <h4 class="card-title mb-0">{{__('Support Ticket')}}</h4>
                <a href="{{route('customer.new.ticket')}}" class="btn btn-primary btn-sm ml-auto"><i class="fa fa-plus"></i> @lang('New Tickets')</a>
            </div>
            <div class="card-body p-0">
                <div class="table-responsive">
                    <table class="table transaction-table">
                        <thead>
                            <tr>
                                <th>{{__('Sl')}}</th>
                                <th>{{__('Ticket Id')}}</th>
                                <th>{{__('Subject')}}</th>
                                <th>{{__('Raised Time')}}</th>
                                <th>{{__('Status')}}</th>
                                <th>{{__('Action')}}</th>
                            </tr>
                        </thead>
                        <tbody>
                        @forelse($all_support as $key=>$data)
                        <tr>
                            <td>{{$key+1}}</td>
                            <td>{{$data->ticket}}</td>
                            <td>{{$data->subject}}</td>
                            <td>{{$data->created_at->format('F dS, Y')}}</td>
                            <td>
                                @if($data->status == 1)
                                    <span class="badge badge-warning">{{__('Opened')}}</span>
                                @elseif($data->status == 2)
                                    <span class="badge badge-success">{{__('Answered')}}</span>
                                @elseif($data->status == 3)
                                    <span class="badge badge-info"> {{__('User Reply')}} </span>
                                @elseif($data->status == 9)
                                    <span class="badge badge-danger">  {{__('Closed')}} </span>
                                @endif
                            </td>
                            <td>
                                <a class="btn btn-primary btn-sm" href="{{route('ticket.customer.reply', $data->ticket )}}"><b>{{__('View')}}</b></a>
                            </td>
                        </tr>
                        @empty 
                            <tr>
                                <td colspan="6" class="text-center">
                                    <div class="no-data-found">
                                        <span class="icon"><i class="lar la-folder-open"></i></span>
                                        <p class="mb-0">{{__('No Data Found')}}</p>
                                    </div>
                                </td>
                            </tr>
                        @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    
    </div>
</div>

@stop