@extends($theme.'frontend.layouts.master')
@section('title',__('Withdraw History'))
@section('content')
    <!-- transaction-area start -->
    <div class="transaction-area left-bottom-line-bg common-pd-bottom-3" >
        <div class="container">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title mb-0">{{__('Withdraw Logs')}}</h4>
                </div>
                <div class="card-body p-0">
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead>
                            <tr>
                                <th scope="col">{{__('Gateway Name')}}</th>
                                <th scope="col">{{__('Amount')}}</th>
                                <th scope="col">{{__('Charge')}}</th>
                                <th scope="col">{{__('Method Cur Amount')}}</th>
                                <th scope="col">{{__('Status')}}</th>
                                <th scope="col">{{__('Transaction ID')}}</th>
                                <th scope="col">{{__('Time')}}</th>
                            </tr>
                            </thead>
                            <tbody>
                            @forelse($deposits as $deposit)
                            <tr>
                                <td data-label="Email">{{__($deposit->method_name)}}</td>
                                <td data-label="Username">{{round($deposit->amount, 8)}} {{$general->currency}}</td>
                                <td data-label="Mobile">{{round($deposit->charge, 8)}} {{$general->currency}}</td>
                                <td data-label="Balance">{{round($deposit->amount*$deposit->method_rate, 8)}} {{$deposit->method_cur}}</td>
                                @if($deposit->status == 0)
                                    <td data-label="Balance">{{__('pending')}}</td>
                                @elseif($deposit->status == 1)
                                    <td data-label="Balance">{{__('complete')}}</td>
                                @else
                                    <td data-label="Balance">{{__('rejected')}}</td>
                                @endif
                                <td  data-label="Details">{{$deposit->withdraw_id}}</td>
                                <td  data-label="Time">{{$deposit->updated_at->format('d/m/y  h:i A')}}</td>
                            </tr>
                            @empty 
                                <tr>
                                    <td colspan="12" class="text-center">
                                        <div class="no-data-found">
                                            <span class="icon"><i class="lar la-folder-open"></i></span>
                                            <p class="mb-0">{{__('No Data Found')}}</p>
                                        </div>
                                    </td>
                                </tr>
                            @endforelse
                            </tbody>
                        </table>
                        <div class="text-center">
                            {{$deposits->links()}}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- transaction-area end -->
@endsection
