@extends ($theme.'frontend.layouts.master')
@section('title',__('2FA Authentication'))
@section('content')

<div class="contact-area pd-top-90 pd-bottom-120">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-6 col-md-8">
                <div class="contact-page-inner bg-black-2 qr-card-area contact-page-inner-cust">
                    <div class="section-title mb-4 pb-2 text-center">
                        <h2 class="title">{{__('QR Code')}} </h2>
                    </div>
                     @if(Auth::user()->tauth == '1')
                    <form>
                        <div class="row">
                            <div class="form-group text-center">
                                <img src="{{$prevqr}}">
                            </div>
                            <div class="col-12 text-center mt-3 mb-3">
                                <button type="button" class="btn btn-danger btn-block" data-bs-toggle="modal" data-bs-target="#disableModal">{{__('Disable Two Factor Authenticator')}}</button>
                            </div>
                        </div>
                    </form>
                    @else
                    <form>
                        <div class="row">
                            <div class="form-group text-center">
                                <img src="{{$qrCodeUrl}}">
                            </div>
                            <div class="col-12 text-center mt-3 mb-3">
                                <button type="button" class="btn btn-success btn-block" data-bs-toggle="modal" data-bs-target="#enableModal">{{__('Enable Two Factor Authenticator')}}</button>
                            </div>
                        </div>
                    </form>
                    @endif
                </div>
            </div>
            <div class="col-lg-6 col-md-8">
                <div class="contact-page-inner bg-black-2 authenticator-card-area contact-page-inner-cust">
                    <div class="section-title mb-4 pb-2 text-center">
                        <h2 class="title">{{__('Authenticator')}} </h2>
                    </div>
                     <form>
                        <div class="part-text">
                            <h5>{{__('Use Google Authenticator to Scan the QR code  or use the code')}}</h5><hr/>
                        </div>
                        <div class="part-text">
                            <p>{{__('Google Authenticator is a multifactor app for mobile devices. It generates timed codes used during the 2-step verification process. To use Google Authenticator, install the Google Authenticator application on your mobile device.')}}</p>
                        </div>
                        <a type="submit" class="button btn btn-success btn-block text-center" href="https://play.google.com/store/apps/details?id=com.google.android.apps.authenticator2&hl=en" target="_blank">{{__('DOWNLOAD APP')}}</a>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>



<div class="modal fade" id="enableModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title text-dark" id="exampleModalLabel">{{__('Verify Your OTP')}}</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <form method="post" action="{{route('go2fa.create')}}">
            @csrf
            <div class="modal-body">
                <div class="form-group">
                    <input type="hidden" name="key" value="{{$secret}}">
                    <input type="text" class="form-control" name="code" placeholder="{{__('Enter Google Authenticator Code')}}">
                </div>
            </div>
            <div class="modal-footer">
                <button type="submit" class="btn btn-success">{{__('Verify')}}</button>
                <button type="button" class="btn btn-danger" data-bs-dismiss="modal">{{__('Close')}}</button>
            </div>
        </form>
      </div>
    </div>
</div>

<div class="modal fade" id="disableModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title text-dark" id="exampleModalLabel">{{__('Verify Your OTP to Disable')}}</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <form method="post" action="{{route('disable.2fa')}}">
            @csrf
            <div class="modal-body">
                <div class="form-group">
                    <input type="text" class="form-control" name="code" placeholder="{{__('Enter Google Authenticator Code')}}">
                </div>
            </div>
            <div class="modal-footer">
                <button type="submit" class="btn btn-success">{{__('Verify')}}</button>
                <button type="button" class="btn btn-danger" data-bs-dismiss="modal">{{__('Close')}}</button>
            </div>
        </form>
      </div>
    </div>
</div>


@endsection