@extends($theme.'frontend.layouts.master')
@section('title',__('Deposit History'))
@section('content')
<div class="transaction-area pd-top-90 pd-bottom-120">
    <div class="container">
        <div class="table-responsive">
            <table class="table transaction-table style-2">
                <thead>
                    <tr>
                        <th>{{__('Gateway Name')}}</th>
                        <th>{{__('Amount')}}</th>
                        <th>{{__('Charge')}}</th>
                        <th>{{__('USD Amount')}}</th>
                        <th>{{__('Status')}}</th>
                        <th>{{__('Transaction ID')}}</th>
                        <th>{{__('Time')}}</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($deposits as $deposit)
                    <tr>
                        <td data-label="Email">{{($deposit->gateway->main_name)?$deposit->gateway->main_name:$deposit->gateway->name}}</td>
                        <td data-label="Username">{{round($deposit->amount, 8)}} {{$general->currency}}</td>
                        <td data-label="Mobile">{{round($deposit->charge, 8)}} {{$general->currency}}</td>
                        <td data-label="Balance">{{round($deposit->usd_amo, 8)}} {{__('USD')}}</td>
                        @if(isset($deposit->deposit_request_table) && !is_null($deposit->deposit_request_table))
                            @if($deposit->deposit_request_table->accepted == 0)
                                <td data-label="Balance"><span class="badge bg-warning text-dark">{{__('pending')}}</span></td>
                                @elseif($deposit->deposit_request_table->accepted == 1)
                                <td data-label="Balance"><span class="badge bg-success">{{__('complete')}}</span></td>
                                @else
                                    <td data-label="Balance"><span class="badge bg-danger">{{__('rejected')}}</span></td>
                                @endif
                            @else
                            <td data-label="Balance">{{($deposit->status==0)?'incomplete':'complete'}}</td>
                        @endif
                        <td  data-label="Details">{{$deposit->trx}}</td>
                        <td  data-label="Time">{{$deposit->updated_at->format('d/m/y  h:i A')}}</td>
                    </tr>
                    @empty 
                    <tr>
                        <td colspan="6" class="text-center">
                            <div class="no-data-found">
                                <span class="icon"><i class="far fa-folder-open"></i></span>
                                <p class="mb-0">{{__('No Data Found')}}</p>
                            </div>
                        </td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
            <div class="row">
                <div class="col-md-12 text-center">
                    {{$deposits->links()}}
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
