@extends($theme.'frontend.layouts.master')
@section('title', __('Deposit Preview'))
@section('content')
<div class="payment-area bg-navy-2 pd-top-90 pd-bottom-90">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-md-8">
                <div class="contact-page-inner bg-black-2 deposit-preview-card-area contact-page-inner-cust">
                    <form method="POST" action="{{route('deposit.confirm')}}">
                        {{csrf_field()}}
                        <input type="hidden" name="gateway" value="{{$data->gateway_id}}"/>
                        @if ($data->gateway_id > 899)
                            <input type="hidden" name="depositid" value="{{$data->id}}"/>
                            <input type="hidden" name="drid" value="{{$dr->id}}"/>
                        @endif

                        <div class="row">
                            <div class="col-md-4">
                                <div class="thumb align-self-center">
                                    <img src="{{asset('assets/images/gateway')}}/{{$data->gateway->image}}" alt="icon">
                                </div>
                            </div>

                            <div class="col-md-8">
                                <div class="facility-details card">
                                    <div class="card-body">
                                        <h5 class="text-dark">Amount : {{$data->amount}}
                                            <strong>{{$general->currency}}</strong></h5>
                                        <p class="list-group-item"> {{__('Charge')}} :
                                            <strong>{{$data->charge}} </strong>{{ $general->currency }}</p>
                                        <p class="list-group-item "> {{__('Payable')}} :
                                            <strong>{{$data->charge + $data->amount}} </strong>{{ $general->currency }}</p>
    
                                        <p class="list-group-item"> {{__('In USD')}} :
                                            <strong>${{$data->usd_amo}}</strong>
                                        </p>
                                    </div>
                                </div>
                                <div class="col-12 text-center mt-3 mb-3">
                                    <input type="submit" class="btn btn-base border-radius-5 pe-5 ps-5" id="btn-confirm" value="{{__('Pay Now')}}">
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
    
@endsection
