@extends($theme.'frontend.layouts.master')
@section('title',__('Transactions'))
@section('content')
<div class="transaction-area pd-top-90 pd-bottom-120">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-12">
                <form class="transaction-log-form-area" action="{{route('search.trans.user')}}" method="Get">
                    <div class="row">
                        <div class="form-group col-md-5">
                            <input type="text" class="form-control" placeholder="Search Via Trans ID" name="trans_id" value="{{isset(request()->trans_id) ? request()->trans_id: '' }}">
                        </div>
                        <div class="form-group col-md-5">
                            <select class="form-select" name="type">
                                <option {{isset(request()->type) && (request()->type == 'All') ? 'selected': '' }} value="All">{{__('All Transactions')}}</option>
                                <option {{isset(request()->type) && (request()->type == 'Invest') ? 'selected': '' }} value="Invest">{{__('Invest')}}</option>
                                <option {{isset(request()->type) && (request()->type == 'Deposit') ? 'selected': '' }} value="Deposit">{{__('Deposit')}}</option>
                                <option {{isset(request()->type) && (request()->type == 'Transfer') ? 'selected': '' }} value="Transfer">{{__('Transfer')}}</option>
                                <option {{isset(request()->type) && (request()->type == 'Income') ? 'selected': '' }} value="Income">{{__('Income')}}</option>
                                <option {{isset(request()->type) && (request()->type == 'Withdraw') ? 'selected': '' }} value="Withdraw">{{__('Withdraw')}}</option>
                                <option {{isset(request()->type) && (request()->type == 'Referral') ? 'selected': '' }} value="Referral">{{__('Referral')}}</option>
                            </select>
                        </div>
                        <div class="form-group col-md-2">
                            <button type="submit" class="btn btn-base"> {{__('Search')}}</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
        <div class="table-responsive">
            <table class="table transaction-table style-2">
                <thead>
                    <tr>
                        <th> {{__('Trans ID')}} </th>
                        <th> {{__('Details')}} </th>
                        <th> {{__('Amount')}} </th>
                        <th> {{__('Old Balance')}} </th>
                        <th> {{__('New Balance')}} </th>
                        <th> {{__('Type')}} </th>
                        <th> {{__('Time')}} </th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($trans as $data)
                    <tr>
                        <td>{{$data->trans_id}}</td>
                        <td>{{__($data->description)}}</td>
                        <td>{{$data->amount}}{{$general->currency}}</td>
                        <td>{{$data->old_bal}}{{$general->currency}}</td>
                        <td>{{$data->new_bal}}{{$general->currency}}</td>
                        <td>
                            @if($data->status == 0)
                                <span class="badge bg-primary">{{__('Invest')}}</span>
                            @elseif($data->status == 1)
                                <span class="badge bg-success">{{__('Deposit')}}</span>
                            @elseif($data->status == 2)
                                <span class="badge bg-info">{{__('Transfer')}}</span>
                            @elseif($data->status == 3)
                                <span class="badge bg-dark">{{__('Withdraw')}}</span>
                            @elseif($data->status == 5)
                            <span class="badge bg-secondary">{{__('Referral Commission')}}</span>
                            @else
                                <span class="badge bg-warning text-dark">{{__('Income')}}</span>
                            @endif
                        </td>
                        <td>{{date('d/m/y  h:i A',strtotime($data->created_at))}}</td>
                    </tr>
                    @empty 
                    <tr>
                        <td colspan="6" class="text-center">
                            <div class="no-data-found">
                                <span class="icon"><i class="far fa-folder-open"></i></span>
                                <p class="mb-0">{{__('No Data Found')}}</p>
                            </div>
                        </td>
                    </tr>
                @endforelse
                </tbody>
            </table>
            <div class="row">
                <div class="col-md-12 text-center">
                    {{$trans->links()}}
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
