@extends($theme . 'frontend.layouts.master')
@section('title', __('Home'))
@section('content')
    <section class="hn_about_section">
        <div class="container">
            <div class="row gy-4 align-items-center">
                <div class="col-lg-6">
                    <div class="hn_about_thumb">
                        <img src="{{ asset('assets/images/about/about_right_img.png') }}" alt="image">
                    </div>
                </div>
                <div class="col-lg-6">
                    <div class="hn_about_content">
                        <span class="hn_top_title border-right">{{ __($general->about_head) }}</span>
                        <h2 class="hn_block_title">{{ __($general->about_title) }}</h2>
                        <p class="fs-lg mt-3">{{ __($general->about_body) }}</p>

                        <div class="mt-5">
                            <div class="row gy-5 hn_about_wrapper">
                                <div class="col-lg-12">
                                    <div class="hn_about_item">
                                        <div class="hn_about_item_icon">
                                            <img src="{{ asset('assets/images/about/one.png') }}" alt="icon image">
                                        </div>
                                        <div class="hn_about_item_content">
                                            <h4 class="title"><a
                                                    href="{{ route('single.page', ['class' => 'about_one']) }}">{{ __($general->single_about1_title) }}</a>
                                            </h4>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-12">
                                    <div class="hn_about_item">
                                        <div class="hn_about_item_icon">
                                            <img src="{{ asset('assets/images/about/two.png') }}" alt="icon image">
                                        </div>
                                        <div class="hn_about_item_content">
                                            <h4 class="title"><a
                                                    href="{{ route('single.page', ['class' => 'about_two']) }}">{{ __($general->single_about2_title) }}</a>
                                            </h4>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Plan Section -->
    <section class="hn_plan_section" style="background-image: url('assets/frontend/mediumpurple/images/plan-bg.jpg');">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-8">
                    <div class="hn_block_header text-center">
                        <span class="hn_top_title border-left-right">INVESTMENT PLAN</span>
                        <h2 class="hn_block_title text-white">Check Our Valuable Plans</h2>
                    </div>
                </div>
            </div>

            <div>
                <ul class="nav nav-pills plan-tabs mb-4 justify-content-center" id="pills-tab" role="tablist">
                    @if(count($roi_plans))
                    <li class="nav-item" role="presentation">
                        <button class="nav-link active" id="pills-home-tab" data-bs-toggle="pill" data-bs-target="#pills-home" type="button" role="tab" aria-controls="pills-home" aria-selected="true">
                            {{__('ROI Investment')}}
                        </button>
                    </li>
                    @endif
                    @if(count($fixed_plans))
                    <li class="nav-item" role="presentation">
                        <button class="nav-link" id="pills-profile-tab" data-bs-toggle="pill" data-bs-target="#pills-profile" type="button" role="tab" aria-controls="pills-profile" aria-selected="false">
                            {{__('Fixed Investment')}}
                        </button>
                    </li>
                    @endif
                </ul>
            </div>
            <div class="tab-content" id="pills-tabContent">
              <div class="tab-pane fade show active" id="pills-home" role="tabpanel" aria-labelledby="pills-home-tab" tabindex="0">
                <div class="row gy-4">
                    @foreach($roi_plans as $data)
                    @php
                        $getTime = \App\Models\ManageTime::where('time', $data->period)->first();
                    @endphp
                    <div class="col-lg-4 col-md-6">
                        <div class="hn_plan">
                            <div class="hn_plan_top">
                                <span class="hn_plan_package_name text-white">{{__($data->name)}}</span>
                                <h3 class="hn_plan_price text-white mt-4">{{$data->percent}}% {{__('Payback')}} <span>{{trans($getTime->name)}}</span></h3>
                                <img src="{{ asset('assets/frontend/mediumpurple/images/plan-top.png') }}" alt="image"
                                    class="hn_plan_top_img">
                            </div>
                            <div class="hn_plan_body">
                                <ul class="hn_plan_feature_list">
                                    <li><i class="fa fa-check"></i> {{__('Minimum Deposit')}} {{$data->min_amount}} {{$general->currency}}</li>
                                    <li><i class="fa fa-check"></i> {{__('Maximum Deposit')}} {{$data->max_amount}} {{$general->currency}}</li>
                                    <li><i class="fa fa-check"></i> {{__('ROI Action')}} {{$data->action}} {{__('TIMES')}}</li>
                                    <li><i class="fa fa-check"></i> {{__('Capital Return')}} @if($data->capital_back_status == 0) 
                                        <span class="badge bg bg-danger">@lang('Off')</span> @else <span class="badge bg bg-success">@lang('On')</span> @endif</li>
                                </ul>
                                <a href="{{route('invest.index')}}" class="btn hn_btn_solid_three border-0 w-100 mt-4">{{__('Invest Now')}}</a>
                                <img src="{{ asset('assets/frontend/mediumpurple/images/plan-body.png') }}" alt="image"
                                    class="hn_plan_body_img">
                            </div>
                        </div>
                    </div>
                    @endforeach
                </div>
              </div>
              <div class="tab-pane fade" id="pills-profile" role="tabpanel" aria-labelledby="pills-profile-tab" tabindex="0">
                  <div class="row gy-4">
                    @foreach($fixed_plans as $data)
                    @php
                        $getTime = \App\Models\ManageTime::where('time', $data->period)->first();
                    @endphp
                    <div class="col-lg-4 col-md-6">
                        <div class="hn_plan">
                            <div class="hn_plan_top">
                                <span class="hn_plan_package_name text-white">{{__($data->name)}}</span>
                                <h3 class="hn_plan_price text-white mt-4">{{$data->percent}}% {{__('Payback')}} <span>{{trans($getTime->name)}}</span></h3>
                                <img src="{{ asset('assets/frontend/mediumpurple/images/plan-top.png') }}" alt="image"
                                    class="hn_plan_top_img">
                            </div>
                            <div class="hn_plan_body">
                                <ul class="hn_plan_feature_list">
                                    <li><i class="fa fa-check"></i> {{__('Deposit')}} {{$data->fixed_amount}}{{$general->currency}}</li>
                                    <li><i class="fa fa-check"></i> {{__('ROI Action Lifetime TIMES')}}</li>
                                    <li><i class="fa fa-check"></i> {{__('Capital Return')}} @if($data->capital_back_status == 0) 
                                        <span class="badge bg bg-danger">@lang('Off')</span> @else <span class="badge bg bg-success">@lang('On')</span> @endif</li>
                                </ul>
                                <a href="{{route('invest.index')}}" class="btn hn_btn_solid_three border-0 w-100 mt-4">{{__('Invest Now')}}</a>
                                <img src="{{ asset('assets/frontend/mediumpurple/images/plan-body.png') }}" alt="image"
                                    class="hn_plan_body_img">
                            </div>
                        </div>
                    </div>
                    @endforeach
                </div>
              </div>
            </div>
    

            <div class="row gy-4 mt-5 justify-content-between align-items-center">
                <div class="col-lg-5">
                    <h2 class="hn_block_title text-white">{{__('Profit Calculator')}}</h2>
                    <img src="{{ asset('assets/frontend/mediumpurple/images/calculator-chart.png') }}" alt="image"
                        class="mt-4 d-lg-block d-none">
                </div>
                <div class="col-lg-6">
                    <div class="hn_profit_calculator">
                        <form>
                            <div class="row gy-3 align-items-center">
                                <div class="col-lg-4">
                                    <label class="text-white">{{__('Deposit Amount')}}</label>
                                </div>
                                <div class="col-lg-8">
                                    <input type="number" id="investAmount" name="invest_amount" class="form-control" autocomplete="off">
                                </div>
                            </div>
                            <div class="row gy-3 align-items-center mt-1">
                                <div class="col-lg-4">
                                    <label class="text-white">{{__('Choose Plan')}}</label>
                                </div>
                                <div class="col-lg-8">
                                    <select class="form-select planSelect">
                                        <option selected disabled>{{__('Select Plan')}}</option>
                                        @foreach ($roi_plans as $data)
                                            <option value="{{$data->id}}" planDetail="{{$data}}">{{__($data->name)}} @switch($data->period)
                                                @case(1)
                                                {{__('Hourly')}} @break
                                                @case(24)
                                                {{__('Daily')}} @break
                                                @case(168)
                                                {{__('Weekly')}} @break
                                                @case(720)
                                                {{__('Monthly')}} @break
                                                @case(2880)
                                                {{__('Quarterly')}} @break
                                                @case(8640)
                                                {{__('Yearly')}} @break
                                            @endswitch {{__('Max')}}  {{$data->max_amount}} {{$general->currency}}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="row gy-3 align-items-center mt-1">
                                <div class="col-lg-4">
                                    <label class="text-white">{{__('Profit Percent')}} (%)</label>
                                </div>
                                <div class="col-lg-8">
                                    <h4 class="text-white roiPerc">0</h4>
                                </div>
                            </div>
                            <div class="row gy-3 align-items-center mt-1">
                                <div class="col-lg-4">
                                    <label class="text-white">{{__('Total Revenue')}} ({{$general->currency}})</label>
                                </div>
                                <div class="col-lg-8">
                                    <h4 class="text-white totalGetAmount">0</h4>
                                </div>
                            </div>
                            <button type="button" class="btn hn_btn_solid mt-4 w-100 subBtn"><i class="fas fa-calculator"></i>
                                {{__('Calculate Profit')}}</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section class="hn_work_section">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-8">
                    <div class="hn_block_header text-center">
                        <span class="hn_top_title">{{__('OUR BEST SERVICES')}}</span>
                        <h2 class="hn_block_title">{{__('Your Path To Financial Prosperity')}}</h2>
                    </div>
                </div>
            </div>
            <div class="row g-sm-4 g-3 justify-content-center">
                @foreach($services as $key => $data)
                <div class="col-lg-3 col-6">
                    <div class="hn_work_item">
                        <img src="{{asset('assets/images/service/'.$data->icon)}}" alt="image">
                        <h3 class="hn_work_item_title">{{__($data->title)}}</h3>
                        <p class="mb-0">{{__($data->description)}}</p>
                        <span class="hn_work_number">{{$key+1}}</span>
                    </div>
                </div>
                @endforeach
            </div>
        </div>
    </section>

    <section class="hn_transaction_section"
        style="background-image: url('assets/frontend/mediumpurple/images/choose.jpg');">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-6">
                    <div class="hn_block_header text-center">
                        <span class="hn_top_title">{{__('LATEST')}}</span>
                        <h2 class="hn_block_title text-white">{{__('Transaction')}}</h2>
                    </div>
                </div>
            </div>
            <div class="row gy-4">
                <div class="col-xl-6">
                    <div class="hn_transaction_box">
                        <h3 class="hn_transaction_box_title">{{__('Investments history')}}</h3>
                        <ul class="hn_transaction_list">
                            @foreach ($deposits as $data)
                            <li>
                                <span>{{$data->user->name}}</span>
                                <span>{{__('Payment system')}} <strong class="fw-bold">{{$data->gateway->name}}</strong></span>
                                <span>{{__('Amount')}} <strong class="fw-bold hn_transaction_amount">{{$data->usd_amo}} {{$general->currency}}</strong></span>
                            </li>
                            @endforeach
                        </ul>
                    </div>
                </div>
                <div class="col-xl-6">
                    <div class="hn_transaction_box">
                        <h3 class="hn_transaction_box_title">{{__('Withdrawals history')}}</h3>
                        <ul class="hn_transaction_list">
                            @foreach ($withdraw as $data)
                            <li>
                                <span>{{$data->user->name}}</span>
                                <span>{{__('Payment system')}} <strong class="fw-bold">{{$data->method_name}}</strong></span>
                                <span>{{__('Amount')}} <strong class="fw-bold hn_transaction_amount">{{$data->amount}} {{$data->method_cur}}</strong></span>
                            </li>
                            @endforeach
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section class="hn_investor_section">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-6">
                    <div class="hn_block_header text-center">
                        <span class="hn_top_title">{{__($general->investor_head)}}</span>
                        <h2 class="hn_block_title">{{__($general->investor_title)}}</h2>
                    </div>
                </div>
            </div>
            <div class="row gy-4">
                @foreach($investors as $data)
                <div class="col-xl-3 col-lg-4 col-sm-6">
                    <div class="hn_investor_item">
                        <div class="hn_investor_thumb">
                            <img src="{{asset('assets/images/investor/'.$data->image)}}" alt="image">
                        </div>
                        <div class="hn_investor_content">
                            <h3 class="investor_name">{{__($data->name)}}</h3>
                            <p class="invest_amount">{{__($data->designation)}}</p>
                        </div>
                    </div>
                </div>
                @endforeach
            </div>
        </div>
    </section>

    <section class="hn_choose_section" style="background-image: url('assets/frontend/mediumpurple/images/choose.jpg');">
        <div class="container">
            <div class="row gy-4">
                <div class="col-lg-4 col-sm-6">
                    <div class="hn_choose_item">
                        <img src="{{asset('assets/images/work/'.$workAreaFirst->icon)}}" alt="image">
                        <h3 class="hn_choose_item_title"><a href="{{route('single.page',['class' => 'work','id'=>$workAreaFirst->id])}}" class="text-white">{{__($workAreaFirst->title)}}</a></h3>
                        <p class="mb-0 mt-4 text-white">{{__(short_text($workAreaFirst->description,25))}}</p>
                    </div>
                </div>
                @foreach($workArea as $data)
                <div class="col-lg-4 col-sm-6">
                    <div class="hn_choose_item">
                        <img src="{{asset('assets/images/work/'.$data->icon)}}" alt="image">
                        <h3 class="hn_choose_item_title"><a href="{{route('single.page',['class' => 'work','id'=>$data->id])}}" class="text-white">{{__($data->title)}}</a></h3>
                        <p class="mb-0 mt-4 text-white">{{__(short_text($data->description,25))}}</p>
                    </div>
                </div>
                @endforeach
            </div>
        </div>
    </section>
    
    <section class="hn_faq_section">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-8">
                    <div class="hn_block_header text-center">
                        <span class="hn_top_title">{{__('FAQ')}}</span>
                        <h2 class="hn_block_title">{{__('Frequently Asked Questions')}}</h2>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-lg-12">
                    <div class="accordion hn_faq_accordion" id="accordionFaq">
                        @foreach ($faqs as $key => $data)
                            <div class="accordion-item">
                                <h2 class="accordion-header" id="headingOne{{$data->id}}">
                                    <button class="accordion-button @if($key == 0) @else collapsed @endif" type="button" data-bs-toggle="collapse"
                                        data-bs-target="#collapseOne{{$data->id}}" aria-expanded="@if($key == 0) true @else false @endif" aria-controls="collapseOne{{$data->id}}">
                                        {{__($data->question)}}
                                    </button>
                                </h2>
                                <div id="collapseOne{{$data->id}}" class="accordion-collapse collapse @if($key == 0) show @endif" aria-labelledby="headingOne{{$data->id}}" data-bs-parent="#accordionFaq">
                                    <div class="accordion-body">
                                        <p class="mb-0">{!! __($data->answer) !!}</p>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section class="hn_affiliate_section"
        style="background-image: url('assets/frontend/mediumpurple/images/choose.jpg');">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-7">
                    <div class="hn_block_header text-center">
                        <span class="hn_top_title">{{__('AFFILIATE')}}</span>
                        <h2 class="hn_block_title text-white">{{__('Our Refferal Comission')}}</h2>
                    </div>
                </div>
            </div>
            <div class="row gy-5">
                <div class="col-xl-12">
                    <div class="row gy-4">
                        @foreach ($rankings as $rank)
                        <div class="col-lg-4 col-6">
                            <div class="hn_referral_item">
                                <div class="hn_referral_item_level">
                                    <span>{{ $rank->title }}</span>
                                </div>
                                <h3 class="hn_referral_amount">{{ $rank->bonus }} {{ $general->currency }}</h3>
                                <p class="mb-0">{{__('Referral Bonus')}}</p>
                            </div>
                        </div>
                        @endforeach
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section class="hn_blog_section">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-xl-6 col-lg-10">
                    <div class="hn_block_header text-center">
                        <span class="hn_top_title">{{__('LATEST NEWS')}}</span>
                        <h2 class="hn_block_title">{{__('News and articles')}}</h2>
                    </div>
                </div>
            </div>
            <div class="row gy-4 justify-content-center">
                @foreach($news as $data)
                <div class="col-lg-4 col-md-6">
                    <div class="hn_blog_post">
                        <div class="hn_blog_thumb">
                            <img src="{{asset('assets/images/news/'.$data->image)}}" alt="image">
                        </div>
                        <div class="hn_blog_content">
                            <span class="hn_blog_date">{{date('F j, Y', strtotime($data->updated_at))}}</span>
                            <ul class="hn_blog_meta">
                                <li><i class="far fa-user-circle"></i> {{__('By Author')}}</li>
                            </ul>
                            <h4 class="hn_blog_title">
                                <a href="{{route('single.page',['class' => 'news', 'id' =>$data->id])}}">{{$data->title}}</a>
                            </h4>
                        </div>
                    </div>
                </div>
                @endforeach
            </div>
        </div>
    </section>

    <input type="hidden" value="{{ $general->cp_currency }}" id="cp_currency">
    <input type="hidden" value="{{ $general->currency }}" id="currency">
@stop
