<header class="hn_header">
    <div class="container">
      <div class="hn_header_box d-flex flex-wrap align-items-center">
        <div class="hn_logo_box">
          <a href="{{url('/')}}">
            <img src="{{asset('assets/images/logo/logo.png')}}" alt="image" class="hn_logo">
          </a>
        </div> 
        <div class="hn_menu_box">
          <div class="hn_header_top d-flex flex-wrap align-items-center justify-content-between gap-3">
            <ul class="hn_header_info p-0 m-0 list-unstyled d-flex flex-wrap align-items-center gap-3">
              <li class="d-flex align-items-center gap-2">
                <i class="far fa-envelope"></i>
                <p class="mb-0">
                    <a href="mailto:{{$general->contact_email}}">{{$general->contact_email}}</a>
                </p>
              </li>
              <li class="d-flex align-items-center gap-2">
                <i class="fas fa-phone-alt"></i>
                <p class="mb-0">
                  <a href="tel:{{$general->contact_phone}}">{{$general->contact_phone}}</a>
                </p>
              </li>
            </ul>
  
            <div class="hn_lang d-flex align-items-center gap-2">
              <i class="fas fa-globe-americas"></i>
              <select id="langSel">
                <option value="en">Eng</option>
                @foreach($lang as $data)
                    <option value="{{$data->code}}" @if(Session::get('lang') === $data->code) selected  @endif>{{$data->name}}</option>
                @endforeach
              </select>
            </div>
          </div>
          <div class="hn_header_bottom d-flex flex-wrap align-items-center justify-content-between">
            <ul class="hn_main_menu d-flex flex- wrap align-items-center gap-xxl-3 gap-xl-2">
                @auth
                    @if ($general->ico == 1)
                    <li class="nav-item dropdown">
                        <a href="#" class="nav-link dropdown-toggle" data-bs-toggle="dropdown" role="button" aria-haspopup="true"
                            aria-expanded="false">{{$general->cp_currency}}</a>
                        <div class="dropdown-menu">
                            <a class="dropdown-item" href="{{route('wallet.index')}}">{{__('Wallets')}}</a>
                            <a class="dropdown-item" href="{{route('my.wallet.transaction.log')}}">{{__('My Transaction Log')}}</a>
                            <a class="dropdown-item" href="{{route('other.wallet.transaction.log')}}">{{__('Other Transaction Log')}}</a>
                        </div>
                    </li>
                    @else
                        <li>
                            <a href="{{route('home')}}">{{__('Dashboard')}}</a>
                        </li>
                    @endif

                    <li class="nav-item dropdown">
                        <a href="#" class="nav-link dropdown-toggle" data-bs-toggle="dropdown" role="button" aria-haspopup="true"
                            aria-expanded="false">{{__('Deposit')}}</a>
                        <div class="dropdown-menu">
                            <a class="dropdown-item" href="{{route('users.showDepositMethods')}}">{{__('Add Deposit')}}</a>
                            <a class="dropdown-item" href="{{route('user.deposit.log')}}">{{__('Deposit Log')}}</a>
                        </div>
                    </li>


                    <li class="nav-item dropdown">
                        <a href="#" class="nav-link dropdown-toggle" data-bs-toggle="dropdown" role="button" aria-haspopup="true"
                            aria-expanded="false">{{__('Investment')}}</a>
                        <div class="dropdown-menu">
                            <a class="dropdown-item" href="{{route('invest.index')}}">{{__('Investment Plan')}}</a>
                            <a class="dropdown-item" href="{{route('invest.log')}}">{{__('Invest Log')}}</a>
                        </div>
                    </li>

                    <li>
                        <a href="{{route('credit-card')}}">{{__('Credit Card')}}</a>
                    </li>

                    <li class="nav-item dropdown">
                        <a href="#" class="nav-link dropdown-toggle" data-bs-toggle="dropdown" role="button" aria-haspopup="true" aria-expanded="false">
                            {{__('Transaction')}}
                        </a>
                        <div class="dropdown-menu">
                            <a class="dropdown-item" href="{{route('user.ref.index')}}">{{__('My Referral Tree')}}</a>
                            <a class="dropdown-item" href="{{route('fund.transfer')}}">{{__('Fund Transfer')}}</a>
                            <a class="dropdown-item" href="{{route('transaction.log')}}">{{__('Transaction Log')}}</a>
                            @if ($general->ico == 1)
                            <a class="dropdown-item" href="{{route('purchase.coin')}}">{{__('MIN CRYPTO')}}</a>
                            @endif
                        </div>
                    </li>

                    <li class="nav-item dropdown">
                        <a href="#" class="nav-link dropdown-toggle" data-bs-toggle="dropdown" role="button" aria-haspopup="true" aria-expanded="false">
                            {{__('Withdraw')}}
                        </a>
                        <div class="dropdown-menu">
                            <a class="dropdown-item" href="{{route('user.withdraw.method')}}">{{__('Withdraw')}}</a>
                            <a class="dropdown-item" href="{{route('user.withdraw.log')}}">{{__('Withdraw Log')}}</a>
                        </div>
                    </li>
                    @php $check_count = \App\Models\Support::where('status', 2)->get() @endphp
                    <li class="nav-item dropdown">
                        <a href="#" class="nav-link dropdown-toggle" data-bs-toggle="dropdown" role="button" aria-haspopup="true" aria-expanded="false">
                            {{split_name(auth()->user()->name)[0]}}
                        </a>
                        <div class="dropdown-menu">
                            <a class="dropdown-item" href="{{route('profile.index')}}">{{__('Profile')}}</a>
                            <a class="dropdown-item" href="{{route('customer.support.index')}}">{{__('Support')}} @if(count($check_count) == 0)  @else <span class="right badge bg-danger"> {{count($check_count)}} </span> @endif</a>
                            <a class="dropdown-item" href="{{route('user.kyc.index')}}">{{__('Kyc')}}</a>
                            <a class="dropdown-item" href="{{route('two.factor.index')}}">{{__('Security')}}</a>
                            <a href="{{route('logout')}}" class="dropdown-item" onclick="event.preventDefault();document.getElementById('logout-form').submit();">{{__('Logout')}}</a>
                        </div>
                    </li>

                    <form id="logout-form" action="{{ route('logout') }}" method="POST" class="display-none">
                        @csrf
                    </form>
                @else
                    <li>
                        <a href="{{url('/')}}">{{__('Home')}}</a>
                    </li>
                    @foreach($frontMenu as $data)
                        <li>
                            <a href="{{route('single.page',['class' => $data->slug, 'id' =>$data->id])}}">{{__($data->title)}}</a>
                        </li>
                    @endforeach
                    <li>
                        <a href="{{route('news.index')}}">{{__('News')}}</a>
                    </li>
                    <li>
                        <a href="{{route('contacts.index')}}">{{__('Contact')}}</a>
                    </li>
                @endif
            </ul>
            
            @auth
            <div class="hn_auth-btns d-flex flex-wrap align-items-center gap-3">
              <a href="{{route('login')}}" class="btn btn-md hn_btn_solid">
                <i class="fas fa-sign-in-alt"></i>
                {{__('Dashboard')}}
              </a>
            </div>
            @else
            <div class="hn_auth-btns d-flex flex-wrap align-items-center gap-3">
              <a href="{{route('register')}}" class="btn btn-md hn_btn_solid d-flex align-items-center gap-2">
                <i class="fas fa-user-plus"></i> 
                {{__('Registration')}}
              </a>
              <a href="{{route('login')}}" class="btn btn-md hn_btn_solid">
                <i class="fas fa-sign-in-alt"></i>
                {{__('Login')}}
              </a>
            </div>
            @endif
          </div>
        </div>
        <button type="button" id="mobile-menu-open">
          <i class="fas fa-bars"></i>
        </button>
      </div>
    </div>
  </header>
  
  <nav class="mobile-menu-nav">
    <div class="d-flex flex-wrap align-items-center justify-content-between border-bottom pb-2 mb-3">
      <p class="mb-0 text-white"><b>{{__('Menu')}}</b></p>
      <button type="button" class="bg-transparent text-white" id="mobile-menu-close">
        <i class="fas fa-times-circle"></i>
      </button>
    </div>
    <ul class="mobile-menu">
        @auth
            <li>
                <a href="{{route('home')}}">{{__('Dashboard')}}</a>
            </li>
            @if ($general->ico == 1)
            <li class="nav-item dropdown">
                <a href="#" class="nav-link dropdown-toggle" data-bs-toggle="dropdown" href="#" role="button" aria-haspopup="true"
                    aria-expanded="false">{{$general->cp_currency}}</a>
                <div class="dropdown-menu">
                    <a class="dropdown-item" href="{{route('wallet.index')}}">{{__('Wallets')}}</a>
                    <a class="dropdown-item" href="{{route('my.wallet.transaction.log')}}">{{__('My Transaction Log')}}</a>
                    <a class="dropdown-item" href="{{route('other.wallet.transaction.log')}}">{{__('Other Transaction Log')}}</a>
                </div>
            </li>
            @else
                <li>
                    <a href="{{route('home')}}">{{__('Dashboard')}}</a>
                </li>
            @endif

            <li class="nav-item dropdown">
                <a href="#" class="nav-link dropdown-toggle" data-bs-toggle="dropdown" href="#" role="button" aria-haspopup="true"
                    aria-expanded="false">{{__('Deposit')}}</a>
                <div class="dropdown-menu">
                    <a class="dropdown-item" href="{{route('users.showDepositMethods')}}">{{__('Add Deposit')}}</a>
                    <a class="dropdown-item" href="{{route('user.deposit.log')}}">{{__('Deposit Log')}}</a>
                </div>
            </li>


            <li class="nav-item dropdown">
                <a href="#" class="nav-link dropdown-toggle" data-bs-toggle="dropdown" href="#" role="button" aria-haspopup="true"
                    aria-expanded="false">{{__('Investment')}}</a>
                <div class="dropdown-menu">
                    <a class="dropdown-item" href="{{route('invest.index')}}">{{__('Investment Plan')}}</a>
                    <a class="dropdown-item" href="{{route('invest.log')}}">{{__('Invest Log')}}</a>
                </div>
            </li>

            <li class="">
                <a href="{{route('credit-card')}}">{{__('Credit Card')}}</a>
            </li>

            <li class="nav-item dropdown">
                <a href="#" class="nav-link dropdown-toggle" data-bs-toggle="dropdown" href="#" role="button" aria-haspopup="true"
                    aria-expanded="false">{{__('Transaction')}}</a>
                <div class="dropdown-menu">
                    <a class="dropdown-item" href="{{route('user.ref.index')}}">{{__('My Referral Tree')}}</a>
                    <a class="dropdown-item" href="{{route('fund.transfer')}}">{{__('Fund Transfer')}}</a>
                    <a class="dropdown-item" href="{{route('transaction.log')}}">{{__('Transaction Log')}}</a>
                    @if ($general->ico == 1)
                    <a class="dropdown-item" href="{{route('purchase.coin')}}">{{__('MIN CRYPTO')}}</a>
                    @endif
                </div>
            </li>

            <li class="nav-item dropdown">
                <a href="#" class="nav-link dropdown-toggle" data-bs-toggle="dropdown" href="#" role="button" aria-haspopup="true"
                    aria-expanded="false">{{__('Withdraw')}}</a>
                <div class="dropdown-menu">
                    <a class="dropdown-item" href="{{route('user.withdraw.method')}}">{{__('Withdraw')}}</a>
                    <a class="dropdown-item" href="{{route('user.withdraw.log')}}">{{__('Withdraw Log')}}</a>
                </div>
            </li>
            @php $check_count = \App\Models\Support::where('status', 2)->get() @endphp
            <li class="nav-item dropdown">
                <a href="#" class="nav-link dropdown-toggle" data-bs-toggle="dropdown" href="#" role="button" aria-haspopup="true"
                    aria-expanded="false">{{split_name(auth()->user()->name)[0]}}</a>
                <div class="dropdown-menu">
                    <a class="dropdown-item" href="{{route('profile.index')}}">{{__('Profile')}}</a>
                    <a class="dropdown-item" href="{{route('customer.support.index')}}">{{__('Support')}} @if(count($check_count) == 0)  @else <span class="right badge bg-danger"> {{count($check_count)}} </span> @endif</a>
                    <a class="dropdown-item" href="{{route('user.kyc.index')}}">{{__('Kyc')}}</a>
                    <a class="dropdown-item" href="{{route('two.factor.index')}}">{{__('Security')}}</a>
                    <a onclick="event.preventDefault();document.getElementById('logout-form').submit();" href="{{route('logout')}}">{{__('Logout')}}</a>
                </div>
            </li>

            <form id="logout-form" action="{{ route('logout') }}" method="POST" class="display-none">
                @csrf
            </form>
        @else
            <li>
                <a href="{{url('/')}}">{{__('Home')}}</a>
            </li>
            @foreach($frontMenu as $data)
                <li>
                    <a href="{{route('single.page',['class' => $data->slug, 'id' =>$data->id])}}">{{__($data->title)}}</a>
                </li>
            @endforeach
            <li>
                <a href="{{route('news.index')}}">{{__('News')}}</a>
            </li>
            <li>
                <a href="{{route('contacts.index')}}">{{__('Contact')}}</a>
            </li>
            <li>
                <a href="{{route('login')}}">{{__('Login')}}</a>
            </li>
            <li>
                <a href="{{route('register')}}">{{__('Register')}}</a>
            </li>
        @endif
    </ul>
  
    <div class="hn_lang d-flex align-items-center gap-2 mt-3">
      <i class="fas fa-globe-americas"></i>
      <select id="langSel">
        <option value="en">Eng</option>
        @foreach($lang as $data)
            <option value="{{$data->code}}" @if(Session::get('lang') === $data->code) selected  @endif>{{$data->name}}</option>
        @endforeach
      </select>
    </div>
</nav>