@extends($theme.'frontend.layouts.master')
@section('title',__('News'))
@section('content')
    <div class="blog-area pd-top-120 pd-bottom-120">
        <div class="container">
            <div class="row">
                @foreach($news as $data)
                <div class="col-lg-4 col-md-6">
                    <div class="hn_blog_post">
                        <div class="hn_blog_thumb">
                            <img src="{{asset('assets/images/news/'.$data->image)}}" alt="image">
                        </div>
                        <div class="hn_blog_content">
                            <span class="hn_blog_date">{{date('F j, Y', strtotime($data->updated_at))}}</span>
                            <ul class="hn_blog_meta">
                                <li><i class="far fa-user-circle"></i> {{__('By Author')}}</li>
                            </ul>
                            <h4 class="hn_blog_title">
                                <a href="{{route('single.page',['class' => 'news', 'id' =>$data->id])}}">{{$data->title}}</a>
                            </h4>
                        </div>
                    </div>
                </div>
                @endforeach
                <div class="pagination text-center">
                    {{$news->links()}}
                </div>
            </div>
        </div>
    </div>
@stop